/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.lexer.batch;

import java.util.ArrayList;
import java.util.Set;
import org.netbeans.api.lexer.InputAttributes;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.lib.lexer.EmbeddingContainer;
import org.netbeans.lib.lexer.LAState;
import org.netbeans.lib.lexer.LexerInputOperation;
import org.netbeans.lib.lexer.LexerUtilsConstants;
import org.netbeans.lib.lexer.TokenHierarchyOperation;
import org.netbeans.lib.lexer.TokenList;
import org.netbeans.lib.lexer.token.AbstractToken;
import org.netbeans.lib.lexer.token.TextToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BatchTokenList<T extends TokenId>
extends ArrayList<Object>
implements TokenList<T> {
    private static final boolean testing = Boolean.getBoolean("netbeans.debug.lexer.test");
    private static boolean maintainLAState;
    private final TokenHierarchyOperation<?, T> tokenHierarchyOperation;
    private final LanguagePath languagePath;
    private final Set<T> skipTokenIds;
    private final InputAttributes inputAttributes;
    private LexerInputOperation<T> lexerInputOperation;
    private LAState laState;
    private boolean inited;

    public static boolean isMaintainLAState() {
        return maintainLAState;
    }

    public static void setMaintainLAState(boolean maintainLAState) {
        BatchTokenList.maintainLAState = maintainLAState;
    }

    public BatchTokenList(TokenHierarchyOperation<?, T> tokenHierarchyOperation, Language<T> language, Set<T> skipTokenIds, InputAttributes inputAttributes) {
        this.tokenHierarchyOperation = tokenHierarchyOperation;
        this.languagePath = LanguagePath.get(language);
        this.skipTokenIds = skipTokenIds;
        this.inputAttributes = inputAttributes;
        if (testing) {
            this.laState = LAState.empty();
        }
    }

    @Override
    public abstract char childTokenCharAt(int var1, int var2);

    protected abstract LexerInputOperation<T> createLexerInputOperation();

    protected void init() {
        this.lexerInputOperation = this.createLexerInputOperation();
    }

    @Override
    public TokenList<? extends TokenId> root() {
        return this;
    }

    @Override
    public TokenHierarchyOperation<?, ? extends TokenId> tokenHierarchyOperation() {
        return this.tokenHierarchyOperation;
    }

    @Override
    public LanguagePath languagePath() {
        return this.languagePath;
    }

    @Override
    public synchronized int tokenCount() {
        if (!this.inited) {
            this.init();
            this.inited = true;
        }
        if (this.lexerInputOperation != null) {
            this.tokenOrEmbeddingContainerImpl(Integer.MAX_VALUE);
        }
        return this.size();
    }

    @Override
    public int tokenCountCurrent() {
        return this.size();
    }

    @Override
    public int childTokenOffset(int rawOffset) {
        return rawOffset;
    }

    @Override
    public int tokenOffset(int index) {
        int offset;
        Token<T> token = this.existingToken(index);
        if (token.isFlyweight()) {
            offset = 0;
            while (--index >= 0) {
                token = this.existingToken(index);
                offset += token.length();
                if (token.isFlyweight()) continue;
                offset += token.offset(null);
                break;
            }
        } else {
            offset = token.offset(null);
        }
        return offset;
    }

    @Override
    public synchronized Object tokenOrEmbeddingContainer(int index) {
        return this.tokenOrEmbeddingContainerImpl(index);
    }

    private Object tokenOrEmbeddingContainerImpl(int index) {
        if (!this.inited) {
            this.init();
            this.inited = true;
        }
        while (this.lexerInputOperation != null && index >= this.size()) {
            AbstractToken<T> token = this.lexerInputOperation.nextToken();
            if (token != null) {
                this.add(token);
                if (this.laState == null) continue;
                this.laState = this.laState.add(this.lexerInputOperation.lookahead(), this.lexerInputOperation.lexerState());
                continue;
            }
            this.lexerInputOperation.release();
            this.lexerInputOperation = null;
            this.trimToSize();
        }
        return index < this.size() ? this.get(index) : null;
    }

    private Token<T> existingToken(int index) {
        return LexerUtilsConstants.token(this.get(index));
    }

    @Override
    public int lookahead(int index) {
        return this.laState != null ? this.laState.lookahead(index) : -1;
    }

    @Override
    public Object state(int index) {
        return this.laState != null ? this.laState.state(index) : null;
    }

    @Override
    public int startOffset() {
        return 0;
    }

    @Override
    public int endOffset() {
        int cntM1 = this.tokenCount() - 1;
        if (cntM1 >= 0) {
            return this.tokenOffset(cntM1) + LexerUtilsConstants.token(this, cntM1).length();
        }
        return 0;
    }

    @Override
    public int modCount() {
        return -1;
    }

    @Override
    public synchronized AbstractToken<T> replaceFlyToken(int index, AbstractToken<T> flyToken, int offset) {
        TextToken nonFlyToken = ((TextToken)flyToken).createCopy(this, offset);
        this.set(index, nonFlyToken);
        return nonFlyToken;
    }

    @Override
    public void wrapToken(int index, EmbeddingContainer embeddingContainer) {
        this.set(index, embeddingContainer);
    }

    @Override
    public InputAttributes inputAttributes() {
        return this.inputAttributes;
    }

    @Override
    public boolean isContinuous() {
        return this.skipTokenIds == null;
    }

    @Override
    public Set<T> skipTokenIds() {
        return this.skipTokenIds;
    }
}

