/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.lexer.batch;

import java.io.IOException;
import java.io.Reader;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.lib.lexer.LexerInputOperation;
import org.netbeans.lib.lexer.TokenList;
import org.netbeans.lib.lexer.batch.CopyTextTokenList;
import org.netbeans.lib.lexer.batch.SkimTokenList;
import org.netbeans.lib.lexer.token.AbstractToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SkimLexerInputOperation<T extends TokenId>
extends LexerInputOperation<T> {
    private static final char[] EMPTY_CHAR_ARRAY = new char[0];
    private static final int DEFAULT_READ_CHAR_ARRAY_SIZE = 4096;
    private static final int MIN_READ_SIZE = 512;
    private static final int DEFAULT_CLUSTER_SIZE = 4096;
    private static final int MAX_UNUSED_CLUSTER_SIZE_FRACTION = 50;
    private Reader reader;
    private char[] readCharArray;
    private CharSequence readCharSequence;
    private int readStartIndex;
    private int readEndIndex;
    private boolean eofRead;
    private SkimTokenList<T> cluster;
    private int clusterTextEndIndex;
    private int defaultClusterSize = 4096;
    private int clusterStartOffset;
    private int offsetShift;

    public SkimLexerInputOperation(TokenList<T> tokenList, Reader reader) {
        super(tokenList, 0, null);
        this.reader = reader;
        this.readCharArray = new char[4096];
    }

    public SkimLexerInputOperation(TokenList<T> tokenList, CharSequence readCharSequence) {
        super(tokenList, 0, null);
        this.readCharSequence = readCharSequence;
        this.readEndIndex = readCharSequence.length();
    }

    @Override
    public int read(int index) {
        if ((index += this.readStartIndex) < this.readEndIndex) {
            return this.readCharArray != null ? this.readCharArray[index] : this.readCharSequence.charAt(index);
        }
        if (!this.eofRead) {
            this.eofRead = this.readCharArray != null ? this.readNextCharArray() : true;
            return this.read(index);
        }
        return -1;
    }

    @Override
    public char readExisting(int index) {
        return this.readCharArray != null ? this.readCharArray[index] : this.readCharSequence.charAt(index);
    }

    @Override
    public void approveToken(AbstractToken<T> token) {
        int tokenLength = token.length();
        if (this.isSkipToken(token)) {
            this.preventFlyToken();
            this.skipChars(this.tokenLength());
        } else if (token.isFlyweight()) {
            assert (this.isFlyTokenAllowed());
            this.flyTokenAdded();
            this.skipChars(tokenLength);
        } else {
            if (this.clusterTextEndIndex != 0 && tokenLength + this.clusterTextEndIndex > this.cluster.getText().length) {
                this.finishCluster();
            }
            if (this.clusterTextEndIndex == 0) {
                int clusterSize = this.defaultClusterSize;
                if (clusterSize < tokenLength) {
                    clusterSize = tokenLength;
                }
                this.defaultClusterSize = clusterSize;
                this.cluster = new SkimTokenList((CopyTextTokenList)this.tokenList(), this.clusterStartOffset, new char[clusterSize]);
            }
            char[] clusterText = this.cluster.getText();
            if (this.readCharArray != null) {
                System.arraycopy(this.readCharArray, this.readStartIndex, clusterText, this.clusterTextEndIndex, tokenLength);
            } else {
                for (int i = 0; i < tokenLength; ++i) {
                    clusterText[this.clusterTextEndIndex + i] = this.readCharSequence.charAt(this.readStartIndex + i);
                }
            }
            int rawOffset = this.offsetShift << 16 | this.clusterTextEndIndex;
            token.setTokenList(this.cluster);
            token.setRawOffset(rawOffset);
            this.clusterTextEndIndex += tokenLength;
            this.clearFlySequence();
        }
        this.readStartIndex += tokenLength;
        this.tokenApproved();
    }

    private void skipChars(int skipLength) {
        if (this.clusterTextEndIndex != 0) {
            if (this.offsetShift + skipLength > Short.MAX_VALUE) {
                this.finishCluster();
                this.clusterStartOffset += skipLength;
            } else {
                this.offsetShift += skipLength;
            }
        } else {
            this.clusterStartOffset += skipLength;
        }
    }

    public void finish() {
        if (this.clusterTextEndIndex != 0) {
            this.finishCluster();
        }
    }

    private void finishCluster() {
        int clusterTextLength = this.cluster.getText().length;
        if (clusterTextLength / 50 > clusterTextLength - this.clusterTextEndIndex) {
            char[] newText = new char[this.clusterTextEndIndex];
            System.arraycopy(this.cluster.getText(), 0, newText, 0, this.clusterTextEndIndex);
            this.cluster.setText(newText);
        }
        this.clusterStartOffset += this.clusterTextEndIndex + this.offsetShift;
        this.clusterTextEndIndex = 0;
        this.offsetShift = 0;
        this.cluster = null;
    }

    private boolean readNextCharArray() {
        int retainLength = this.readEndIndex - this.readStartIndex;
        int minReadSize = this.readCharArray.length - retainLength;
        char[] newReadCharArray = this.readCharArray;
        if (minReadSize < 512) {
            newReadCharArray = new char[this.readCharArray.length * 2];
        }
        System.arraycopy(this.readCharArray, this.readStartIndex, newReadCharArray, 0, retainLength);
        this.readCharArray = newReadCharArray;
        this.readStartIndex = 0;
        this.readEndIndex = retainLength;
        boolean eof = false;
        while (this.readEndIndex < this.readCharArray.length) {
            int readSize;
            try {
                readSize = this.reader.read(this.readCharArray, this.readEndIndex, this.readCharArray.length - this.readEndIndex);
            }
            catch (IOException e) {
                readSize = -1;
            }
            if (readSize == -1) {
                eof = true;
                try {
                    this.reader.close();
                }
                catch (IOException e) {}
                break;
            }
            this.readEndIndex += readSize;
        }
        return eof;
    }
}

