/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.lexer.batch;

import java.util.Set;
import org.netbeans.api.lexer.InputAttributes;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.lib.lexer.EmbeddingContainer;
import org.netbeans.lib.lexer.TokenHierarchyOperation;
import org.netbeans.lib.lexer.TokenList;
import org.netbeans.lib.lexer.batch.CopyTextTokenList;
import org.netbeans.lib.lexer.token.AbstractToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SkimTokenList<T extends TokenId>
implements TokenList<T> {
    private CopyTextTokenList<T> tokenList;
    private int startOffset;
    private char[] text;

    public SkimTokenList(CopyTextTokenList<T> tokenList, int startOffset, char[] text) {
        this.tokenList = tokenList;
        this.startOffset = startOffset;
        this.text = text;
    }

    public CopyTextTokenList<T> getTokenList() {
        return this.tokenList;
    }

    @Override
    public int startOffset() {
        return this.tokenList.startOffset();
    }

    @Override
    public int endOffset() {
        return this.tokenList.endOffset();
    }

    char[] getText() {
        return this.text;
    }

    void setText(char[] text) {
        this.text = text;
    }

    @Override
    public int childTokenOffset(int rawOffset) {
        int offsetShift = rawOffset >> 16;
        return this.startOffset + (rawOffset & 0xFFFF) + offsetShift;
    }

    @Override
    public char childTokenCharAt(int rawOffset, int index) {
        return this.text[rawOffset + index & 0xFFFF];
    }

    @Override
    public int modCount() {
        return 0;
    }

    @Override
    public Object tokenOrEmbeddingContainer(int index) {
        return this.tokenList.tokenOrEmbeddingContainer(index);
    }

    @Override
    public AbstractToken<T> replaceFlyToken(int index, AbstractToken<T> flyToken, int offset) {
        return this.tokenList.replaceFlyToken(index, flyToken, offset);
    }

    @Override
    public int lookahead(int index) {
        return this.tokenList.lookahead(index);
    }

    @Override
    public Object state(int index) {
        return this.tokenList.state(index);
    }

    @Override
    public int tokenOffset(int index) {
        return this.tokenList.tokenOffset(index);
    }

    @Override
    public int tokenCount() {
        return this.tokenList.tokenCount();
    }

    @Override
    public int tokenCountCurrent() {
        return this.tokenList.tokenCountCurrent();
    }

    @Override
    public TokenList<? extends TokenId> root() {
        return this.tokenList.root();
    }

    @Override
    public TokenHierarchyOperation<?, ? extends TokenId> tokenHierarchyOperation() {
        return this.tokenList.tokenHierarchyOperation();
    }

    @Override
    public LanguagePath languagePath() {
        return this.tokenList.languagePath();
    }

    @Override
    public void wrapToken(int index, EmbeddingContainer embeddingContainer) {
        this.tokenList.wrapToken(index, embeddingContainer);
    }

    @Override
    public InputAttributes inputAttributes() {
        return this.tokenList.inputAttributes();
    }

    @Override
    public boolean isContinuous() {
        return this.tokenList.isContinuous();
    }

    @Override
    public Set<T> skipTokenIds() {
        return this.tokenList.skipTokenIds();
    }
}

