/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.lexer.inc;

import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.netbeans.api.lexer.InputAttributes;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.lib.editor.util.swing.DocumentListenerPriority;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.lib.lexer.LanguageManager;
import org.netbeans.spi.lexer.LanguageHierarchy;
import org.netbeans.spi.lexer.MutableTextInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DocumentInput<D extends Document>
extends MutableTextInput<D>
implements DocumentListener {
    private static final String PROP_MIME_TYPE = "mimeType";
    private D doc;
    private LanguageHierarchy languageHierarchy;
    private CharSequence text;

    public static <D extends Document> DocumentInput<D> get(D doc) {
        DocumentInput<D> di = (DocumentInput<D>)doc.getProperty(MutableTextInput.class);
        if (di == null) {
            di = new DocumentInput<D>(doc);
            doc.putProperty(MutableTextInput.class, di);
        }
        return di;
    }

    public DocumentInput(D doc) {
        this.doc = doc;
        this.text = DocumentUtilities.getText(doc);
        DocumentUtilities.addDocumentListener(doc, (DocumentListener)this, (DocumentListenerPriority)DocumentListenerPriority.LEXER);
    }

    @Override
    public Language<? extends TokenId> language() {
        String mimeType;
        Language<? extends TokenId> lang = (Language<? extends TokenId>)this.doc.getProperty(Language.class);
        if (lang == null && (mimeType = (String)this.doc.getProperty(PROP_MIME_TYPE)) != null) {
            lang = LanguageManager.getInstance().findLanguage(mimeType);
        }
        return lang;
    }

    @Override
    public CharSequence text() {
        return this.text;
    }

    @Override
    public InputAttributes inputAttributes() {
        return (InputAttributes)this.doc.getProperty(InputAttributes.class);
    }

    @Override
    public D inputSource() {
        return this.doc;
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.modified(true, e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.modified(false, e);
    }

    private void modified(boolean insert, DocumentEvent e) {
        int offset = e.getOffset();
        int length = e.getLength();
        if (insert) {
            this.tokenHierarchyControl().textModified(offset, 0, null, length);
        } else {
            this.tokenHierarchyControl().textModified(offset, length, DocumentUtilities.getModificationText((DocumentEvent)e), 0);
        }
    }
}

