/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.lexer.inc;

import java.util.Set;
import org.netbeans.api.lexer.InputAttributes;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.lib.editor.util.CompactMap;
import org.netbeans.lib.lexer.EmbeddedTokenList;
import org.netbeans.lib.lexer.EmbeddingContainer;
import org.netbeans.lib.lexer.LexerUtilsConstants;
import org.netbeans.lib.lexer.TokenHierarchyOperation;
import org.netbeans.lib.lexer.TokenList;
import org.netbeans.lib.lexer.inc.IncTokenList;
import org.netbeans.lib.lexer.inc.RemovedTokenList;
import org.netbeans.lib.lexer.inc.StandaloneTokenList;
import org.netbeans.lib.lexer.inc.TokenHierarchyEventInfo;
import org.netbeans.lib.lexer.inc.TokenListChange;
import org.netbeans.lib.lexer.token.AbstractToken;
import org.netbeans.lib.lexer.token.TextToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SnapshotTokenList<T extends TokenId>
implements TokenList<T> {
    private TokenHierarchyOperation<?, T> snapshot;
    private IncTokenList<T> liveTokenList;
    private int liveTokenGapStart = -1;
    private int liveTokenGapEnd;
    private int liveTokenGapStartOffset;
    private int liveTokenOffsetDiff;
    private Object[] origTokensOrBranches;
    private int[] origOffsets;
    private int origTokenStartIndex;
    private int origTokenCount;
    private CompactMap<AbstractToken<T>, Token2OffsetEntry<T>> token2offset;

    public int liveTokenGapStart() {
        return this.liveTokenGapStart;
    }

    public int liveTokenGapEnd() {
        return this.liveTokenGapEnd;
    }

    public SnapshotTokenList(TokenHierarchyOperation<?, T> snapshot) {
        this.snapshot = snapshot;
        this.liveTokenList = (IncTokenList)snapshot.liveTokenHierarchyOperation().tokenList();
        this.token2offset = new CompactMap();
    }

    public TokenHierarchyOperation<?, T> snapshot() {
        return this.snapshot;
    }

    @Override
    public LanguagePath languagePath() {
        return this.liveTokenList.languagePath();
    }

    @Override
    public Object tokenOrEmbeddingContainer(int index) {
        if (this.liveTokenGapStart == -1 || index < this.liveTokenGapStart) {
            return this.liveTokenList.tokenOrEmbeddingContainer(index);
        }
        if ((index -= this.liveTokenGapStart) < this.origTokenCount) {
            return this.origTokensOrBranches[this.origTokenStartIndex + index];
        }
        return this.liveTokenList.tokenOrEmbeddingContainer(this.liveTokenGapEnd + index - this.origTokenCount);
    }

    @Override
    public int lookahead(int index) {
        return -1;
    }

    @Override
    public Object state(int index) {
        return null;
    }

    @Override
    public int tokenOffset(int index) {
        int offset;
        if (this.liveTokenGapStart == -1 || index < this.liveTokenGapStart) {
            return this.liveTokenList.tokenOffset(index);
        }
        if ((index -= this.liveTokenGapStart) < this.origTokenCount) {
            return this.origOffsets[this.origTokenStartIndex + index];
        }
        AbstractToken token = LexerUtilsConstants.token(this.liveTokenList.tokenOrEmbeddingContainerUnsync(this.liveTokenGapEnd + (index -= this.origTokenCount)));
        if (token.isFlyweight()) {
            offset = token.length();
            while (--index >= 0) {
                token = LexerUtilsConstants.token(this.liveTokenList.tokenOrEmbeddingContainerUnsync(this.liveTokenGapEnd + index));
                if (token.isFlyweight()) {
                    offset += token.length();
                    continue;
                }
                offset += this.tokenOffset(token, this.liveTokenList, token.rawOffset());
                break;
            }
            if (index == -1 && (index += this.liveTokenGapStart + this.origTokenCount) >= 0) {
                offset += this.tokenOffset(index);
            }
        } else {
            offset = this.tokenOffset(token, this.liveTokenList, token.rawOffset());
        }
        return offset;
    }

    public <TT extends TokenId> int tokenOffset(AbstractToken<TT> token, TokenList<TT> tokenList, int rawOffset) {
        if (tokenList.getClass() == EmbeddedTokenList.class) {
            EmbeddedTokenList etl = (EmbeddedTokenList)tokenList;
            AbstractToken<TokenId> rootBranchToken = etl.rootToken();
            Token2OffsetEntry entry = (Token2OffsetEntry)((Object)this.token2offset.get(rootBranchToken));
            if (entry != null) {
                return entry.offset() + etl.childTokenOffsetShift(rawOffset);
            }
            int offset = etl.childTokenOffset(rawOffset);
            TokenList<TokenId> rootTokenList = etl.root();
            if (rootTokenList != null && rootTokenList.getClass() == IncTokenList.class && offset >= this.liveTokenGapStartOffset) {
                offset += this.liveTokenOffsetDiff;
            }
            return offset;
        }
        Token2OffsetEntry entry = (Token2OffsetEntry)((Object)this.token2offset.get(token));
        if (entry != null) {
            return entry.offset();
        }
        if (tokenList.getClass() == IncTokenList.class) {
            if ((rawOffset = tokenList.childTokenOffset(rawOffset)) >= this.liveTokenGapStartOffset) {
                rawOffset += this.liveTokenOffsetDiff;
            }
            return rawOffset;
        }
        return tokenList.childTokenOffset(rawOffset);
    }

    @Override
    public int tokenCount() {
        return this.liveTokenGapStart == -1 ? this.liveTokenList.tokenCount() : this.liveTokenList.tokenCount() - (this.liveTokenGapEnd - this.liveTokenGapStart) + this.origTokenCount;
    }

    @Override
    public int tokenCountCurrent() {
        return this.liveTokenGapStart == -1 ? this.liveTokenList.tokenCountCurrent() : this.liveTokenList.tokenCountCurrent() - (this.liveTokenGapEnd - this.liveTokenGapStart) + this.origTokenCount;
    }

    @Override
    public int modCount() {
        return -1;
    }

    @Override
    public int childTokenOffset(int rawOffset) {
        return rawOffset;
    }

    @Override
    public char childTokenCharAt(int rawOffset, int index) {
        throw new IllegalStateException("Not expected to be called");
    }

    @Override
    public void wrapToken(int index, EmbeddingContainer embeddingContainer) {
        if (this.liveTokenGapStart == -1 || index < this.liveTokenGapStart) {
            this.liveTokenList.wrapToken(index, embeddingContainer);
        } else if ((index -= this.liveTokenGapStart) < this.origTokenCount) {
            this.origTokensOrBranches[this.origTokenStartIndex + index] = embeddingContainer;
        } else {
            this.liveTokenList.wrapToken(this.liveTokenGapEnd + index - this.origTokenCount, embeddingContainer);
        }
    }

    @Override
    public AbstractToken<T> replaceFlyToken(int index, AbstractToken<T> flyToken, int offset) {
        AbstractToken<T> nonFlyToken;
        if (this.liveTokenGapStart == -1 || index < this.liveTokenGapStart) {
            nonFlyToken = this.liveTokenList.replaceFlyToken(index, flyToken, offset);
        } else if ((index -= this.liveTokenGapStart) < this.origTokenCount) {
            this.origTokensOrBranches[this.origTokenStartIndex + index] = nonFlyToken = ((TextToken)flyToken).createCopy(this, offset);
        } else {
            nonFlyToken = this.liveTokenList.replaceFlyToken(this.liveTokenGapEnd + index - this.origTokenCount, flyToken, offset - this.liveTokenOffsetDiff);
        }
        return nonFlyToken;
    }

    @Override
    public TokenList<? extends TokenId> root() {
        return this;
    }

    @Override
    public TokenHierarchyOperation<?, ? extends TokenId> tokenHierarchyOperation() {
        return this.snapshot;
    }

    @Override
    public InputAttributes inputAttributes() {
        return this.liveTokenList.inputAttributes();
    }

    @Override
    public boolean isContinuous() {
        return true;
    }

    @Override
    public Set<T> skipTokenIds() {
        return null;
    }

    @Override
    public int startOffset() {
        if (this.tokenCountCurrent() > 0 || this.tokenCount() > 0) {
            return this.tokenOffset(0);
        }
        return 0;
    }

    @Override
    public int endOffset() {
        int cntM1 = this.tokenCount() - 1;
        if (cntM1 >= 0) {
            return this.tokenOffset(cntM1) + LexerUtilsConstants.token(this, cntM1).length();
        }
        return 0;
    }

    public boolean canModifyToken(int index, AbstractToken token) {
        return this.liveTokenGapStart != -1 && index >= this.liveTokenGapStart && index < this.liveTokenGapEnd && !this.token2offset.containsKey((Object)token);
    }

    public void update(TokenHierarchyEventInfo eventInfo, TokenListChange<T> change) {
        int extraOrigTokenCount;
        RemovedTokenList<T> removedTokenList = change.tokenChangeInfo().removedTokenList();
        int startRemovedIndex = change.index();
        int endRemovedIndex = startRemovedIndex + removedTokenList.tokenCount();
        if (this.liveTokenGapStart == -1) {
            this.liveTokenGapStart = startRemovedIndex;
            this.liveTokenGapEnd = startRemovedIndex;
            this.liveTokenGapStartOffset = change.offset();
            this.origTokensOrBranches = new Object[removedTokenList.tokenCount()];
            this.origOffsets = new int[this.origTokensOrBranches.length];
        }
        int liveTokenIndexDiff = change.tokenChangeInfo().addedTokenCount() - removedTokenList.tokenCount();
        if (startRemovedIndex < this.liveTokenGapStart) {
            Object tokenOrEmbeddingContainer;
            int index;
            int offset;
            extraOrigTokenCount = this.liveTokenGapStart - startRemovedIndex;
            this.ensureOrigTokensStartCapacity(extraOrigTokenCount);
            this.origTokenStartIndex -= extraOrigTokenCount;
            this.origTokenCount += extraOrigTokenCount;
            int bound = Math.min(endRemovedIndex, this.liveTokenGapStart);
            this.liveTokenGapStartOffset = offset = change.offset();
            for (index = startRemovedIndex; index < bound; ++index) {
                TokenList tokenList;
                tokenOrEmbeddingContainer = removedTokenList.tokenOrEmbeddingContainer(index - startRemovedIndex);
                AbstractToken token = LexerUtilsConstants.token(tokenOrEmbeddingContainer);
                if (!token.isFlyweight() && (tokenList = token.tokenList()) == null) {
                    tokenList = new StandaloneTokenList(change.languagePath(), eventInfo.originalText().toCharArray(offset, offset + token.length()));
                    token.setTokenList(tokenList);
                }
                this.origOffsets[this.origTokenStartIndex] = offset;
                this.origTokensOrBranches[this.origTokenStartIndex++] = tokenOrEmbeddingContainer;
                offset += token.length();
            }
            while (index < this.liveTokenGapStart) {
                tokenOrEmbeddingContainer = this.liveTokenList.tokenOrEmbeddingContainerUnsync(index + liveTokenIndexDiff);
                AbstractToken t = LexerUtilsConstants.token(tokenOrEmbeddingContainer);
                if (!t.isFlyweight()) {
                    this.token2offset.putEntry(new Token2OffsetEntry(t, offset));
                }
                this.origOffsets[this.origTokenStartIndex] = offset;
                this.origTokensOrBranches[this.origTokenStartIndex++] = tokenOrEmbeddingContainer;
                offset += t.length();
                ++index;
            }
            this.liveTokenGapStart = startRemovedIndex;
        }
        if (endRemovedIndex > this.liveTokenGapEnd) {
            AbstractToken token;
            Object tokenOrEmbeddingContainer;
            extraOrigTokenCount = endRemovedIndex - this.liveTokenGapEnd;
            this.ensureOrigTokensEndCapacity(extraOrigTokenCount);
            this.origTokenCount += extraOrigTokenCount;
            int origTokenIndex = this.origTokenStartIndex + this.origTokenCount - 1;
            int bound = Math.max(startRemovedIndex, this.liveTokenGapEnd);
            int index = endRemovedIndex;
            int offset = change.removedEndOffset();
            for (index = endRemovedIndex - 1; index >= bound; --index) {
                TokenList tokenList;
                tokenOrEmbeddingContainer = removedTokenList.tokenOrEmbeddingContainer(index - startRemovedIndex);
                token = LexerUtilsConstants.token(tokenOrEmbeddingContainer);
                offset -= token.length();
                if (!token.isFlyweight() && (tokenList = token.tokenList()) == null) {
                    tokenList = new StandaloneTokenList(change.languagePath(), eventInfo.originalText().toCharArray(offset, offset + token.length()));
                    token.setTokenList(tokenList);
                }
                this.origOffsets[origTokenIndex] = offset + this.liveTokenOffsetDiff;
                if (this.liveTokenOffsetDiff != 0) {
                    this.token2offset.putEntry(new Token2OffsetEntry(token, this.origOffsets[origTokenIndex]));
                }
                this.origTokensOrBranches[origTokenIndex--] = tokenOrEmbeddingContainer;
            }
            while (index >= this.liveTokenGapEnd) {
                tokenOrEmbeddingContainer = this.liveTokenList.tokenOrEmbeddingContainerUnsync(index + liveTokenIndexDiff);
                token = LexerUtilsConstants.token(tokenOrEmbeddingContainer);
                offset -= token.length();
                if (!token.isFlyweight()) {
                    this.token2offset.putEntry(new Token2OffsetEntry(token, offset));
                }
                this.origOffsets[origTokenIndex] = offset + this.liveTokenOffsetDiff;
                this.token2offset.putEntry(new Token2OffsetEntry(token, this.origOffsets[origTokenIndex]));
                this.origTokensOrBranches[origTokenIndex--] = tokenOrEmbeddingContainer;
                --index;
            }
            this.liveTokenGapEnd = endRemovedIndex;
        }
        this.liveTokenOffsetDiff += eventInfo.removedLength() - eventInfo.insertedLength();
        this.liveTokenGapEnd += liveTokenIndexDiff;
    }

    private void ensureOrigTokensStartCapacity(int extraOrigTokenCount) {
        if (extraOrigTokenCount > this.origTokensOrBranches.length - this.origTokenCount) {
            Object[] newOrigTokensOrBranches = new Object[this.origTokensOrBranches.length * 3 / 2 + extraOrigTokenCount];
            int[] newOrigOffsets = new int[newOrigTokensOrBranches.length];
            int newIndex = Math.max(extraOrigTokenCount, (newOrigTokensOrBranches.length - (this.origTokenCount + extraOrigTokenCount)) / 2);
            System.arraycopy(this.origTokensOrBranches, this.origTokenStartIndex, newOrigTokensOrBranches, newIndex, this.origTokenCount);
            System.arraycopy(this.origOffsets, this.origTokenStartIndex, newOrigOffsets, newIndex, this.origTokenCount);
            this.origTokensOrBranches = newOrigTokensOrBranches;
            this.origOffsets = newOrigOffsets;
            this.origTokenStartIndex = newIndex;
        } else if (extraOrigTokenCount > this.origTokenStartIndex) {
            int newIndex = this.origTokensOrBranches.length - this.origTokenCount;
            System.arraycopy(this.origTokensOrBranches, this.origTokenStartIndex, this.origTokensOrBranches, newIndex, this.origTokenCount);
            System.arraycopy(this.origOffsets, this.origTokenStartIndex, this.origOffsets, newIndex, this.origTokenCount);
            this.origTokenStartIndex = this.origTokensOrBranches.length - this.origTokenCount;
        }
    }

    private void ensureOrigTokensEndCapacity(int extraOrigTokenCount) {
        if (extraOrigTokenCount > this.origTokensOrBranches.length - this.origTokenCount) {
            Object[] newOrigTokensOrBranches = new Object[this.origTokensOrBranches.length * 3 / 2 + extraOrigTokenCount];
            int[] newOrigOffsets = new int[newOrigTokensOrBranches.length];
            int newIndex = (newOrigTokensOrBranches.length - (this.origTokenCount + extraOrigTokenCount)) / 2;
            System.arraycopy(this.origTokensOrBranches, this.origTokenStartIndex, newOrigTokensOrBranches, newIndex, this.origTokenCount);
            System.arraycopy(this.origOffsets, this.origTokenStartIndex, newOrigOffsets, newIndex, this.origTokenCount);
            this.origTokensOrBranches = newOrigTokensOrBranches;
            this.origOffsets = newOrigOffsets;
            this.origTokenStartIndex = newIndex;
        } else if (extraOrigTokenCount > this.origTokensOrBranches.length - this.origTokenCount - this.origTokenStartIndex) {
            System.arraycopy(this.origTokensOrBranches, this.origTokenStartIndex, this.origTokensOrBranches, 0, this.origTokenCount);
            System.arraycopy(this.origOffsets, this.origTokenStartIndex, this.origOffsets, 0, this.origTokenCount);
            this.origTokenStartIndex = 0;
        }
    }

    public String toString() {
        return "liveTokenGapStart=" + this.liveTokenGapStart + ", liveTokenGapEnd=" + this.liveTokenGapEnd + ", liveTokenGapStartOffset=" + this.liveTokenGapStartOffset + ", liveTokenOffsetDiff=" + this.liveTokenOffsetDiff + ",\n origTokenStartIndex=" + this.origTokenStartIndex + ", origTokenCount=" + this.origTokenCount + ", token2offset: " + this.token2offset;
    }

    public int tokenShiftStartOffset() {
        return this.liveTokenGapStartOffset;
    }

    public int tokenShiftEndOffset() {
        return this.liveTokenGapStartOffset + this.liveTokenOffsetDiff;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Token2OffsetEntry<T extends TokenId>
    extends CompactMap.MapEntry<AbstractToken<T>, Token2OffsetEntry<T>> {
        private final AbstractToken<T> token;
        private final int offset;

        Token2OffsetEntry(AbstractToken<T> token, int offset) {
            this.token = token;
            this.offset = offset;
        }

        public AbstractToken<T> getKey() {
            return this.token;
        }

        public Token2OffsetEntry<T> getValue() {
            return this;
        }

        protected int valueHashCode() {
            return this.offset;
        }

        protected boolean valueEquals(Object value2) {
            return value2 instanceof Token2OffsetEntry && ((Token2OffsetEntry)((Object)value2)).offset() == this.offset();
        }

        public int offset() {
            return this.offset;
        }

        public Token2OffsetEntry<T> setValue(Token2OffsetEntry<T> value) {
            throw new IllegalStateException("Prohibited");
        }

        public String toString() {
            return String.valueOf(this.offset);
        }
    }
}

