/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.lexer.inc;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.lib.editor.util.ArrayUtilities;
import org.netbeans.lib.lexer.LAState;
import org.netbeans.lib.lexer.LexerUtilsConstants;
import org.netbeans.lib.lexer.inc.MutableTokenList;
import org.netbeans.lib.lexer.inc.RemovedTokenList;
import org.netbeans.lib.lexer.inc.TokenChangeInfo;
import org.netbeans.lib.lexer.token.AbstractToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TokenListChange<T extends TokenId> {
    private final TokenChangeInfo<T> tokenChangeInfo;
    private List<Object> addedTokensOrBranches;
    private LAState laState;
    private int offsetGapIndex;
    private int removedEndOffset;
    private int addedEndOffset;

    public TokenListChange(MutableTokenList<T> tokenList) {
        this.tokenChangeInfo = new TokenChangeInfo<T>(tokenList);
    }

    public TokenChangeInfo<T> tokenChangeInfo() {
        return this.tokenChangeInfo;
    }

    public MutableTokenList<T> tokenList() {
        return (MutableTokenList)this.tokenChangeInfo.currentTokenList();
    }

    public LanguagePath languagePath() {
        return this.tokenList().languagePath();
    }

    public int index() {
        return this.tokenChangeInfo.index();
    }

    public void setIndex(int tokenIndex) {
        this.tokenChangeInfo.setIndex(tokenIndex);
    }

    public int offset() {
        return this.tokenChangeInfo.offset();
    }

    public void setOffset(int offset) {
        this.tokenChangeInfo.setOffset(offset);
    }

    public int offsetGapIndex() {
        return this.offsetGapIndex;
    }

    public void setOffsetGapIndex(int offsetGapIndex) {
        this.offsetGapIndex = offsetGapIndex;
    }

    public void addToken(AbstractToken<T> token, int lookahead, Object state) {
        if (this.addedTokensOrBranches == null) {
            this.addedTokensOrBranches = new ArrayList<Object>(2);
            this.laState = LAState.empty();
        }
        this.addedTokensOrBranches.add(token);
        this.laState = this.laState.add(lookahead, state);
    }

    public List<Object> addedTokensOrBranches() {
        return this.addedTokensOrBranches;
    }

    public AbstractToken<T> addedToken(int index) {
        return LexerUtilsConstants.token(this.addedTokensOrBranches.get(0));
    }

    public void syncAddedTokenCount() {
        this.tokenChangeInfo.setAddedTokenCount(this.addedTokensOrBranches.size());
    }

    public void setRemovedTokens(Object[] removedTokensOrBranches) {
        this.tokenChangeInfo.setRemovedTokenList(new RemovedTokenList(this.languagePath(), removedTokensOrBranches));
    }

    public int removedEndOffset() {
        return this.removedEndOffset;
    }

    public void setRemovedEndOffset(int removedEndOffset) {
        this.removedEndOffset = removedEndOffset;
    }

    public int addedEndOffset() {
        return this.addedEndOffset;
    }

    public void setAddedEndOffset(int addedEndOffset) {
        this.addedEndOffset = addedEndOffset;
    }

    public boolean isBoundsChange() {
        return this.tokenChangeInfo.isBoundsChange();
    }

    public void markBoundsChange() {
        this.tokenChangeInfo.markBoundsChange();
    }

    public LAState laState() {
        return this.laState;
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int indent) {
        int i;
        int digitCount;
        StringBuilder sb = new StringBuilder();
        sb.append('\"');
        sb.append(this.languagePath().innerLanguage().mimeType());
        sb.append("\", index=");
        sb.append(this.index());
        sb.append(", offset=");
        sb.append(this.offset());
        RemovedTokenList<T> removedTL = this.tokenChangeInfo.removedTokenList();
        if (removedTL != null && removedTL.tokenCount() > 0) {
            digitCount = ArrayUtilities.digitCount((int)(removedTL.tokenCount() - 1));
            for (i = 0; i < removedTL.tokenCount(); ++i) {
                sb.append('\n');
                ArrayUtilities.appendSpaces((StringBuilder)sb, (int)indent);
                sb.append("R[");
                ArrayUtilities.appendIndex((StringBuilder)sb, (int)i, (int)digitCount);
                sb.append("]: ");
                LexerUtilsConstants.appendTokenInfo(sb, removedTL.tokenOrEmbeddingContainer(i), null);
            }
        }
        if (this.addedTokensOrBranches() != null) {
            digitCount = ArrayUtilities.digitCount((int)(this.addedTokensOrBranches().size() - 1));
            for (i = 0; i < this.addedTokensOrBranches().size(); ++i) {
                sb.append('\n');
                ArrayUtilities.appendSpaces((StringBuilder)sb, (int)indent);
                sb.append("A[");
                ArrayUtilities.appendIndex((StringBuilder)sb, (int)i, (int)digitCount);
                sb.append("]: ");
                LexerUtilsConstants.appendTokenInfo(sb, this.addedTokensOrBranches.get(i), null);
            }
        }
        return sb.toString();
    }
}

