/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.lexer.token;

import org.netbeans.api.lexer.PartType;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.lib.editor.util.CharSequenceUtilities;
import org.netbeans.lib.lexer.EmbeddedTokenList;
import org.netbeans.lib.lexer.LexerApiPackageAccessor;
import org.netbeans.lib.lexer.LexerUtilsConstants;
import org.netbeans.lib.lexer.TokenList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractToken<T extends TokenId>
extends Token<T>
implements CharSequence {
    private final T id;
    private TokenList<T> tokenList;
    private int rawOffset;

    public AbstractToken(T id) {
        assert (id != null);
        this.id = id;
    }

    AbstractToken(T id, TokenList<T> tokenList, int rawOffset) {
        this.id = id;
        this.tokenList = tokenList;
        this.rawOffset = rawOffset;
    }

    @Override
    public abstract int length();

    @Override
    public final T id() {
        return this.id;
    }

    @Override
    public CharSequence text() {
        if (this.tokenList != null) {
            if (this.tokenList.getClass() == EmbeddedTokenList.class) {
                EmbeddedTokenList etl = (EmbeddedTokenList)this.tokenList;
                return etl.updateStatus() ? this : null;
            }
            return this;
        }
        return null;
    }

    public final TokenList<T> tokenList() {
        return this.tokenList;
    }

    public final void setTokenList(TokenList<T> tokenList) {
        this.tokenList = tokenList;
    }

    public final int rawOffset() {
        return this.rawOffset;
    }

    public final void setRawOffset(int rawOffset) {
        this.rawOffset = rawOffset;
    }

    @Override
    public final boolean isFlyweight() {
        return this.rawOffset == -1;
    }

    public final void makeFlyweight() {
        this.setRawOffset(-1);
    }

    @Override
    public PartType partType() {
        return PartType.COMPLETE;
    }

    @Override
    public boolean isCustomText() {
        return false;
    }

    @Override
    public final int offset(TokenHierarchy<?> tokenHierarchy) {
        if (this.rawOffset == -1) {
            return -1;
        }
        if (tokenHierarchy != null) {
            return LexerApiPackageAccessor.get().tokenHierarchyOperation(tokenHierarchy).tokenOffset(this, this.tokenList, this.rawOffset);
        }
        return this.tokenList != null ? this.tokenList.childTokenOffset(this.rawOffset) : this.rawOffset;
    }

    @Override
    public boolean isPreprocessedText() {
        return false;
    }

    @Override
    public CharSequence preprocessedText() {
        return null;
    }

    @Override
    public String preprocessError() {
        return null;
    }

    @Override
    public int preprocessErrorIndex() {
        return -1;
    }

    @Override
    public boolean hasProperties() {
        return false;
    }

    @Override
    public Object getProperty(Object key) {
        return null;
    }

    @Override
    public final char charAt(int index) {
        if (index < 0 || index >= this.length()) {
            throw new IndexOutOfBoundsException("index=" + index + ", length=" + this.length());
        }
        return this.tokenList.childTokenCharAt(this.rawOffset, index);
    }

    @Override
    public final CharSequence subSequence(int start, int end) {
        return CharSequenceUtilities.toString((CharSequence)this, (int)start, (int)end);
    }

    @Override
    public String toString() {
        CharSequence text = this.text();
        try {
            return text != null ? CharSequenceUtilities.toString((CharSequence)this, (int)0, (int)this.length()) : "<null>";
        }
        catch (NullPointerException e) {
            System.err.println("id=" + LexerUtilsConstants.idToString(this.id) + ", IHC=" + System.identityHashCode(this));
            throw e;
        }
    }

    public String dumpInfo(TokenHierarchy<?> tokenHierarchy) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.dumpInfoTokenType());
        sb.append('(').append(this.id()).append(", ");
        CharSequence text = this.text();
        if (text != null) {
            sb.append('\"');
            for (int i = 0; i < text.length(); ++i) {
                try {
                    CharSequenceUtilities.debugChar((StringBuilder)sb, (char)text.charAt(i));
                    continue;
                }
                catch (IndexOutOfBoundsException e) {
                    sb.append("IOOBE at index=").append(i).append("!!!");
                    break;
                }
            }
            sb.append('\"');
        } else {
            sb.append("<null-text>");
        }
        sb.append(", ").append(this.offset(tokenHierarchy));
        sb.append(", ").append(this.length()).append(')');
        return sb.toString();
    }

    protected String dumpInfoTokenType() {
        return "AbsT";
    }
}

