/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.lexer;

import java.util.Set;
import org.netbeans.api.lexer.PartType;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.lib.editor.util.CharSequenceUtilities;
import org.netbeans.lib.lexer.LanguageOperation;
import org.netbeans.lib.lexer.LexerInputOperation;
import org.netbeans.lib.lexer.TokenIdImpl;
import org.netbeans.lib.lexer.token.ComplexToken;
import org.netbeans.lib.lexer.token.CustomTextToken;
import org.netbeans.lib.lexer.token.DefaultToken;
import org.netbeans.lib.lexer.token.PreprocessedTextToken;
import org.netbeans.lib.lexer.token.PropertyToken;
import org.netbeans.lib.lexer.token.TextToken;
import org.netbeans.spi.lexer.TokenPropertyProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TokenFactory<T extends TokenId> {
    private static final boolean testing = Boolean.getBoolean("netbeans.debug.lexer.test");
    public static final Token SKIP_TOKEN = new TextToken<TokenIdImpl>(new TokenIdImpl("skip-token-id(should never be part of token sequence", 0, null), "");
    private final LexerInputOperation<T> operation;

    TokenFactory(LexerInputOperation<T> operation) {
        this.operation = operation;
    }

    public Token<T> createToken(T id) {
        return this.createToken(id, this.operation.readIndex());
    }

    public Token<T> createToken(T id, int length) {
        if (this.isSkipToken(id)) {
            this.operation.tokenRecognized(length, true);
            return this.skipToken();
        }
        if (this.operation.tokenRecognized(length, false)) {
            return new PreprocessedTextToken<T>(id, this.operation.tokenLength());
        }
        return new DefaultToken<T>(id, this.operation.tokenLength());
    }

    public Token<T> createToken(T id, int length, PartType partType) {
        this.checkPartTypeNonNull(partType);
        if (partType == PartType.COMPLETE) {
            return this.createToken(id, length);
        }
        if (this.isSkipToken(id)) {
            this.operation.tokenRecognized(length, true);
            return this.skipToken();
        }
        if (this.operation.tokenRecognized(length, false)) {
            return new ComplexToken<T>(id, this.operation.tokenLength(), null, null, partType);
        }
        return new PropertyToken<T>(id, this.operation.tokenLength(), null, partType);
    }

    public Token<T> getFlyweightToken(T id, String text) {
        assert (text.length() <= this.operation.readIndex());
        if (testing) {
            for (int i = 0; i < text.length(); ++i) {
                if (text.charAt(i) == this.operation.readExisting(i)) continue;
                throw new IllegalArgumentException("Flyweight text in TokenFactory.getFlyweightToken(" + id + ", \"" + CharSequenceUtilities.debugText((CharSequence)text) + "\") " + "differs from recognized text: '" + CharSequenceUtilities.debugChar((char)this.operation.readExisting(i)) + "' != '" + CharSequenceUtilities.debugChar((char)text.charAt(i)) + "' at index=" + i);
            }
        }
        if (this.isSkipToken(id)) {
            this.operation.tokenRecognized(text.length(), true);
            return this.skipToken();
        }
        if (this.operation.tokenRecognized(text.length(), false)) {
            return new PreprocessedTextToken<T>(id, this.operation.tokenLength());
        }
        if (this.operation.isFlyTokenAllowed()) {
            LanguageOperation<T> langOp = this.operation.languageOperation();
            return langOp.getFlyweightToken(id, text);
        }
        return new DefaultToken<T>(id, this.operation.tokenLength());
    }

    public Token<T> createPropertyToken(T id, int length, TokenPropertyProvider propertyProvider, PartType partType) {
        this.checkPartTypeNonNull(partType);
        if (this.isSkipToken(id)) {
            this.operation.tokenRecognized(length, true);
            return this.skipToken();
        }
        if (this.operation.tokenRecognized(length, false)) {
            return new ComplexToken<T>(id, this.operation.tokenLength(), propertyProvider, null, partType);
        }
        return new PropertyToken<T>(id, this.operation.tokenLength(), propertyProvider, partType);
    }

    public Token<T> createCustomTextToken(T id, CharSequence text, int length, PartType partType) {
        this.checkPartTypeNonNull(partType);
        if (this.isSkipToken(id)) {
            this.operation.tokenRecognized(length, true);
            return this.skipToken();
        }
        if (this.operation.tokenRecognized(length, false)) {
            return new ComplexToken<T>(id, this.operation.tokenLength(), null, text, partType);
        }
        return new CustomTextToken<T>(id, this.operation.tokenLength(), text, partType);
    }

    private boolean isSkipToken(T id) {
        Set<T> skipTokenIds = this.operation.skipTokenIds();
        return skipTokenIds != null && skipTokenIds.contains(id);
    }

    private Token<T> skipToken() {
        return SKIP_TOKEN;
    }

    private void checkPartTypeNonNull(PartType partType) {
        if (partType == null) {
            throw new IllegalArgumentException("partType must be non-null");
        }
    }
}

