/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seplatform;

import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.java.j2seplatform.platformdefinition.J2SEPlatformImpl;
import org.netbeans.modules.java.j2seplatform.platformdefinition.PlatformConvertor;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataObject;
import org.openide.modules.ModuleInstall;
import org.openide.util.Exceptions;

public class J2SEPlatformModule
extends ModuleInstall {
    private static final String DEFAULT_PLATFORM = "Services/Platforms/org-netbeans-api-java-Platform/default_platform.xml";

    public void restored() {
        super.restored();
        J2SEPlatformModule.updateBuildProperties();
    }

    public static void updateBuildProperties() {
        ProjectManager.mutex().postWriteRequest(new Runnable(){

            public void run() {
                try {
                    J2SEPlatformModule.recoverDefaultPlatform();
                    EditableProperties ep = PropertyUtils.getGlobalProperties();
                    boolean save = J2SEPlatformModule.updateSourceLevel(ep);
                    if (save |= J2SEPlatformModule.updateBuildProperties(ep)) {
                        PropertyUtils.putGlobalProperties((EditableProperties)ep);
                    }
                }
                catch (IOException ioe) {
                    Exceptions.printStackTrace((Throwable)ioe);
                }
            }
        });
    }

    private static boolean updateSourceLevel(EditableProperties ep) {
        JavaPlatform platform = JavaPlatformManager.getDefault().getDefaultPlatform();
        String ver = platform.getSpecification().getVersion().toString();
        if (!ver.equals(ep.getProperty("default.javac.source"))) {
            ep.setProperty("default.javac.source", ver);
            ep.setProperty("default.javac.target", ver);
            return true;
        }
        return false;
    }

    private static boolean updateBuildProperties(EditableProperties ep) {
        boolean changed = false;
        JavaPlatform[] installedPlatforms = JavaPlatformManager.getDefault().getPlatforms(null, new Specification("j2se", null));
        for (int i = 0; i < installedPlatforms.length; ++i) {
            String systemName;
            String key;
            if (installedPlatforms[i].equals(JavaPlatformManager.getDefault().getDefaultPlatform()) || !(installedPlatforms[i] instanceof J2SEPlatformImpl) || ep.containsKey((Object)(key = PlatformConvertor.createName(systemName = ((J2SEPlatformImpl)installedPlatforms[i]).getAntName(), "home")))) continue;
            try {
                PlatformConvertor.generatePlatformProperties(installedPlatforms[i], systemName, ep);
                changed = true;
                continue;
            }
            catch (PlatformConvertor.BrokenPlatformException b) {
                Logger.getLogger(J2SEPlatformModule.class.getName()).info("Platform: " + installedPlatforms[i].getDisplayName() + " is missing: " + b.getMissingTool());
                continue;
            }
            catch (IOException ioe) {
                Exceptions.printStackTrace((Throwable)ioe);
            }
        }
        return changed;
    }

    private static void recoverDefaultPlatform() {
        FileObject defaultPlatform = Repository.getDefault().getDefaultFileSystem().findResource(DEFAULT_PLATFORM);
        if (defaultPlatform != null) {
            try {
                DataObject dobj = DataObject.find((FileObject)defaultPlatform);
                boolean valid = false;
                InstanceCookie ic = (InstanceCookie)dobj.getCookie(InstanceCookie.class);
                if (ic != null) {
                    try {
                        ic.instanceCreate();
                        valid = true;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (!valid) {
                    Logger.getLogger("global").log(Level.WARNING, "default_platform.xml is broken, regenerating.");
                    Object attr = defaultPlatform.getAttribute("removeWritables");
                    if (attr instanceof Callable) {
                        ((Callable)attr).call();
                    }
                }
            }
            catch (Exception e) {
                Exceptions.printStackTrace((Throwable)e);
            }
        } else {
            Logger.getLogger("global").log(Level.WARNING, "The default platform is hidden.");
        }
    }
}

