/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seplatform.libraries;

import java.net.URL;
import java.util.List;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class J2SELibraryClassPathProvider
implements ClassPathProvider {
    private FileObject lastUsedRoot;
    private Library lastUsedLibrary;

    public ClassPath findClassPath(FileObject file, String type) {
        assert (file != null);
        Library ll = this.getLastUsedLibrary(file);
        Library[] libraries = ll != null ? new Library[]{ll} : LibraryManager.getDefault().getLibraries();
        for (int i = 0; i < libraries.length; ++i) {
            List resources;
            ClassPath sourcePath;
            FileObject root;
            if (!"j2se".equalsIgnoreCase(libraries[i].getType()) || (root = (sourcePath = ClassPathSupport.createClassPath((URL[])(resources = libraries[i].getContent("src")).toArray(new URL[resources.size()]))).findOwnerRoot(file)) == null) continue;
            this.setLastUsedLibrary(root, libraries[i]);
            if ("classpath/source".equals(type)) {
                return sourcePath;
            }
            if ("classpath/compile".equals(type)) {
                resources = libraries[i].getContent("classpath");
                return ClassPathSupport.createClassPath((URL[])resources.toArray(new URL[resources.size()]));
            }
            if (!"classpath/boot".equals(type)) break;
            return JavaPlatformManager.getDefault().getDefaultPlatform().getBootstrapLibraries();
        }
        return null;
    }

    private synchronized Library getLastUsedLibrary(FileObject fo) {
        if (this.lastUsedRoot != null && FileUtil.isParentOf((FileObject)this.lastUsedRoot, (FileObject)fo)) {
            return this.lastUsedLibrary;
        }
        return null;
    }

    private synchronized void setLastUsedLibrary(FileObject root, Library lib) {
        this.lastUsedRoot = root;
        this.lastUsedLibrary = lib;
    }
}

