/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seplatform.libraries;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.queries.JavadocForBinaryQuery;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.spi.java.queries.JavadocForBinaryQueryImplementation;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.ChangeSupport;
import org.openide.util.WeakListeners;

public class JavadocForBinaryQueryLibraryImpl
implements JavadocForBinaryQueryImplementation {
    private static int MAX_DEPTH = 3;
    private final Map<URL, URL> normalizedURLCache = new HashMap<URL, URL>();

    public JavadocForBinaryQuery.Result findJavadoc(URL b) {
        boolean isNormalizedURL = JavadocForBinaryQueryLibraryImpl.isNormalizedURL(b);
        for (Library lib : LibraryManager.getDefault().getLibraries()) {
            String type = lib.getType();
            if (!"j2se".equalsIgnoreCase(type)) continue;
            for (URL entry : lib.getContent("classpath")) {
                URL normalizedEntry = isNormalizedURL ? this.getNormalizedURL(entry) : entry;
                if (normalizedEntry == null || !normalizedEntry.equals(b)) continue;
                class R
                implements JavadocForBinaryQuery.Result,
                PropertyChangeListener {
                    private Library lib;
                    private final ChangeSupport cs = new ChangeSupport((Object)this);
                    private URL[] cachedRoots;

                    public R(Library lib) {
                        this.lib = lib;
                        this.lib.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.lib));
                    }

                    public synchronized URL[] getRoots() {
                        if (this.cachedRoots == null) {
                            ArrayList<URL> result = new ArrayList<URL>();
                            for (URL u : this.lib.getContent("javadoc")) {
                                result.add(JavadocForBinaryQueryLibraryImpl.getIndexFolder(u));
                            }
                            this.cachedRoots = result.toArray(new URL[result.size()]);
                        }
                        return this.cachedRoots;
                    }

                    public synchronized void addChangeListener(ChangeListener l) {
                        assert (l != null) : "Listener can not be null";
                        this.cs.addChangeListener(l);
                    }

                    public synchronized void removeChangeListener(ChangeListener l) {
                        assert (l != null) : "Listener can not be null";
                        this.cs.removeChangeListener(l);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void propertyChange(PropertyChangeEvent event) {
                        if ("content".equals(event.getPropertyName())) {
                            R r = this;
                            synchronized (r) {
                                this.cachedRoots = null;
                            }
                            this.cs.fireChange();
                        }
                    }
                }
                return new R(lib);
            }
        }
        return null;
    }

    private URL getNormalizedURL(URL url) {
        FileObject fo;
        if (JavadocForBinaryQueryLibraryImpl.isNormalizedURL(url)) {
            return url;
        }
        URL normalizedURL = this.normalizedURLCache.get(url);
        if (normalizedURL == null && (fo = URLMapper.findFileObject((URL)url)) != null) {
            try {
                normalizedURL = fo.getURL();
                this.normalizedURLCache.put(url, normalizedURL);
            }
            catch (FileStateInvalidException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }
        return normalizedURL;
    }

    private static boolean isNormalizedURL(URL url) {
        if ("jar".equals(url.getProtocol())) {
            url = FileUtil.getArchiveFile((URL)url);
        }
        return "file".equals(url.getProtocol());
    }

    static boolean isValidLibraryJavadocRoot(URL rootURL) {
        assert (rootURL != null && rootURL.toExternalForm().endsWith("/"));
        FileObject root = URLMapper.findFileObject((URL)rootURL);
        if (root == null) {
            return false;
        }
        return JavadocForBinaryQueryLibraryImpl.findIndexFolder(root, 1) != null;
    }

    private static URL getIndexFolder(URL rootURL) {
        if (rootURL == null) {
            return null;
        }
        FileObject root = URLMapper.findFileObject((URL)rootURL);
        if (root == null) {
            return rootURL;
        }
        FileObject result = JavadocForBinaryQueryLibraryImpl.findIndexFolder(root, 1);
        try {
            return result == null ? rootURL : result.getURL();
        }
        catch (FileStateInvalidException e) {
            ErrorManager.getDefault().notify((Throwable)e);
            return rootURL;
        }
    }

    private static FileObject findIndexFolder(FileObject fo, int depth) {
        if (depth > MAX_DEPTH) {
            return null;
        }
        if (fo.getFileObject("index-files", null) != null || fo.getFileObject("index-all.html", null) != null) {
            return fo;
        }
        for (FileObject child : fo.getChildren()) {
            FileObject result;
            if (!child.isFolder() || (result = JavadocForBinaryQueryLibraryImpl.findIndexFolder(child, depth + 1)) == null) continue;
            return result;
        }
        return null;
    }
}

