/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seplatform.wizard;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.netbeans.modules.java.j2seplatform.platformdefinition.J2SEPlatformImpl;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Utilities;

public final class NewJ2SEPlatform
extends J2SEPlatformImpl
implements Runnable {
    private static Set propertiesToFix = new HashSet();
    private boolean valid;

    public static NewJ2SEPlatform create(FileObject installFolder) throws IOException {
        assert (installFolder != null);
        HashMap platformProperties = new HashMap();
        return new NewJ2SEPlatform(null, Collections.singletonList(installFolder.getURL()), platformProperties, Collections.EMPTY_MAP);
    }

    private NewJ2SEPlatform(String name, List installFolders, Map platformProperties, Map systemProperties) {
        super(name, name, installFolders, platformProperties, systemProperties, null, null);
    }

    public boolean isValid() {
        return this.valid;
    }

    public void run() {
        try {
            FileObject java = this.findTool("java");
            if (java == null) {
                return;
            }
            File javaFile = FileUtil.toFile((FileObject)java);
            if (javaFile == null) {
                return;
            }
            String javapath = javaFile.getAbsolutePath();
            String filePath = File.createTempFile("nb-platformdetect", "properties").getAbsolutePath();
            this.getSDKProperties(javapath, filePath);
            File f = new File(filePath);
            Properties p = new Properties();
            FileInputStream is = new FileInputStream(f);
            p.load(is);
            HashMap<String, String> m = new HashMap<String, String>(p.size());
            Enumeration<Object> en = p.keys();
            while (en.hasMoreElements()) {
                String k = (String)en.nextElement();
                String v = p.getProperty(k);
                v = this.fixSymLinks(k, v);
                m.put(k, v);
            }
            this.setSystemProperties(m);
            this.valid = true;
            ((InputStream)is).close();
            f.delete();
        }
        catch (IOException ex) {
            this.valid = false;
        }
    }

    private String fixSymLinks(String key, String value) {
        if (Utilities.isUnix() && propertiesToFix.contains(key)) {
            try {
                String[] pathElements = value.split(File.pathSeparator);
                boolean changed = false;
                Iterator it = this.getInstallFolders().iterator();
                while (it.hasNext()) {
                    String canonicalPath;
                    String path;
                    File f = FileUtil.toFile((FileObject)((FileObject)it.next()));
                    if (f == null || (path = f.getAbsolutePath()).equals(canonicalPath = f.getCanonicalPath())) continue;
                    for (int i = 0; i < pathElements.length; ++i) {
                        if (!pathElements[i].startsWith(canonicalPath)) continue;
                        pathElements[i] = path + pathElements[i].substring(canonicalPath.length());
                        changed = true;
                    }
                }
                if (changed) {
                    StringBuffer sb = new StringBuffer();
                    for (int i = 0; i < pathElements.length; ++i) {
                        if (i > 0) {
                            sb.append(File.pathSeparatorChar);
                        }
                        sb.append(pathElements[i]);
                    }
                    return sb.toString();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return value;
    }

    private void getSDKProperties(String javaPath, String path) throws IOException {
        Runtime runtime = Runtime.getRuntime();
        try {
            String[] command = new String[]{javaPath, "-classpath", InstalledFileLocator.getDefault().locate("modules/ext/org-netbeans-modules-java-j2seplatform-probe.jar", "org.netbeans.modules.java.j2seplatform", false).getAbsolutePath(), "org.netbeans.modules.java.j2seplatform.wizard.SDKProbe", path};
            Process process = runtime.exec(command);
            process.waitFor();
            int exitValue = process.exitValue();
            if (exitValue != 0) {
                throw new IOException();
            }
        }
        catch (InterruptedException ex) {
            IOException e = new IOException();
            ErrorManager.getDefault().annotate((Throwable)e, (Throwable)ex);
            throw e;
        }
    }

    static {
        propertiesToFix.add("sun.boot.class.path");
        propertiesToFix.add("sun.boot.library.path");
        propertiesToFix.add("java.library.path");
        propertiesToFix.add("java.ext.dirs");
        propertiesToFix.add("java.home");
    }
}

