/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.UIResource;
import org.openide.util.Exceptions;
import org.openide.util.Utilities;

final class CloseButtonTabbedPane
extends JTabbedPane {
    private Image closeTabImage;
    private Image closeTabPressedImage;
    private Image closeTabMouseOverImage;
    static final String PROP_CLOSE = "close";
    private int pressedCloseButtonIndex = -1;
    private int mouseOverCloseButtonIndex = -1;
    private boolean draggedOut = false;

    CloseButtonTabbedPane() {
        this.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                CloseButtonTabbedPane.this.reset();
            }
        });
        CloseButtonListener.install();
        this.setFocusable(false);
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setFocusCycleRoot(true);
        this.setFocusTraversalPolicy(new CBTPPolicy());
    }

    private Component sel() {
        Component c = this.getSelectedComponent();
        return c == null ? this : c;
    }

    public Component add(Component c) {
        Component result = super.add(c);
        if (!(c instanceof UIResource)) {
            String s = c.getName();
            if (s != null) {
                s = s + "  ";
            }
            this.setTitleAt(this.getComponentCount() - 1, s);
        }
        return result;
    }

    public void setTitleAt(int idx, String title) {
        String nue;
        String string = nue = title.indexOf("</html>") != -1 ? Utilities.replaceString((String)title, (String)"</html>", (String)"&nbsp;&nbsp;</html>") : title + "  ";
        if (!title.equals(this.getTitleAt(idx))) {
            super.setTitleAt(idx, nue);
        }
    }

    private void reset() {
        this.setMouseOverCloseButtonIndex(-1);
        this.setPressedCloseButtonIndex(-1);
        this.draggedOut = false;
    }

    private Rectangle getCloseButtonBoundsAt(int i) {
        Rectangle b = this.getBoundsAt(i);
        if (b == null) {
            return null;
        }
        b = new Rectangle(b);
        CloseButtonTabbedPane.fixGetBoundsAt(b);
        Dimension tabsz = this.getSize();
        if (b.x + b.width >= tabsz.width || b.y + b.height >= tabsz.height) {
            return null;
        }
        if ((this.isWindowsVistaLaF() || this.isWindowsXPLaF() || this.isWindowsLaF()) && i == this.getSelectedIndex()) {
            b.x -= 3;
            b.y -= 2;
        } else if (this.isWindowsXPLaF() || this.isWindowsLaF() || this.isAquaLaF()) {
            b.x -= 2;
        }
        if (i == this.getTabCount() - 1) {
            if (this.isMetalLaF()) {
                --b.x;
            } else if (this.isAquaLaF()) {
                b.x -= 3;
            }
        }
        return new Rectangle(b.x + b.width - 13, b.y + b.height / 2 - 5, 12, 12);
    }

    private boolean isWindowsVistaLaF() {
        String osName = System.getProperty("os.name");
        return osName.indexOf("Vista") >= 0 || osName.equals("Windows NT (unknown)") && "6.0".equals(System.getProperty("os.version"));
    }

    private boolean isWindowsXPLaF() {
        Boolean isXP = (Boolean)Toolkit.getDefaultToolkit().getDesktopProperty("win.xpstyle.themeActive");
        return this.isWindowsLaF() && isXP != null && isXP != false;
    }

    private boolean isWindowsLaF() {
        String lfID = UIManager.getLookAndFeel().getID();
        return lfID.endsWith("Windows");
    }

    private boolean isAquaLaF() {
        return "Aqua".equals(UIManager.getLookAndFeel().getID());
    }

    private boolean isMetalLaF() {
        String lfID = UIManager.getLookAndFeel().getID();
        return "Metal".equals(lfID);
    }

    public void paint(Graphics g) {
        super.paint(g);
        int selectedIndex = this.getSelectedIndex();
        int n = this.getTabCount();
        for (int i = 0; i < n; ++i) {
            Rectangle r = this.getCloseButtonBoundsAt(i);
            if (r == null) continue;
            if (i == this.mouseOverCloseButtonIndex || i == this.pressedCloseButtonIndex && this.draggedOut) {
                g.drawImage(this.getCloseTabMouseOverImage(), r.x, r.y, this);
                continue;
            }
            if (i == this.pressedCloseButtonIndex) {
                g.drawImage(this.getCloseTabPressedImage(), r.x, r.y, this);
                continue;
            }
            g.drawImage(this.getCloseTabImage(), r.x, r.y, this);
        }
    }

    private Image getCloseTabImage() {
        if (null == this.closeTabImage) {
            this.closeTabImage = this.isWindowsVistaLaF() ? Utilities.loadImage((String)"org/openide/awt/resources/vista_close_enabled.png") : (this.isWindowsXPLaF() ? Utilities.loadImage((String)"org/openide/awt/resources/xp_close_enabled.png") : (this.isWindowsLaF() ? Utilities.loadImage((String)"org/openide/awt/resources/win_close_enabled.png") : (this.isAquaLaF() ? Utilities.loadImage((String)"org/openide/awt/resources/mac_close_enabled.png") : Utilities.loadImage((String)"org/openide/awt/resources/metal_close_enabled.png"))));
        }
        return this.closeTabImage;
    }

    private Image getCloseTabPressedImage() {
        if (null == this.closeTabPressedImage) {
            this.closeTabPressedImage = this.isWindowsVistaLaF() ? Utilities.loadImage((String)"org/openide/awt/resources/vista_close_pressed.png") : (this.isWindowsXPLaF() ? Utilities.loadImage((String)"org/openide/awt/resources/xp_close_pressed.png") : (this.isWindowsLaF() ? Utilities.loadImage((String)"org/openide/awt/resources/win_close_pressed.png") : (this.isAquaLaF() ? Utilities.loadImage((String)"org/openide/awt/resources/mac_close_pressed.png") : Utilities.loadImage((String)"org/openide/awt/resources/metal_close_pressed.png"))));
        }
        return this.closeTabPressedImage;
    }

    private Image getCloseTabMouseOverImage() {
        if (null == this.closeTabMouseOverImage) {
            this.closeTabMouseOverImage = this.isWindowsVistaLaF() ? Utilities.loadImage((String)"org/openide/awt/resources/vista_close_rollover.png") : (this.isWindowsXPLaF() ? Utilities.loadImage((String)"org/openide/awt/resources/xp_close_rollover.png") : (this.isWindowsLaF() ? Utilities.loadImage((String)"org/openide/awt/resources/win_close_rollover.png") : (this.isAquaLaF() ? Utilities.loadImage((String)"org/openide/awt/resources/mac_close_rollover.png") : Utilities.loadImage((String)"org/openide/awt/resources/metal_close_rollover.png"))));
        }
        return this.closeTabMouseOverImage;
    }

    private void setPressedCloseButtonIndex(int index) {
        Rectangle r;
        if (this.pressedCloseButtonIndex == index) {
            return;
        }
        if (this.pressedCloseButtonIndex >= 0 && this.pressedCloseButtonIndex < this.getTabCount()) {
            r = this.getCloseButtonBoundsAt(this.pressedCloseButtonIndex);
            this.repaint(r.x, r.y, r.width + 2, r.height + 2);
            JComponent c = this._getJComponentAt(this.pressedCloseButtonIndex);
            if (c != null) {
                this.setToolTipTextAt(this.pressedCloseButtonIndex, c.getToolTipText());
            }
        }
        this.pressedCloseButtonIndex = index;
        if (this.pressedCloseButtonIndex >= 0 && this.pressedCloseButtonIndex < this.getTabCount()) {
            r = this.getCloseButtonBoundsAt(this.pressedCloseButtonIndex);
            this.repaint(r.x, r.y, r.width + 2, r.height + 2);
            this.setMouseOverCloseButtonIndex(-1);
            this.setToolTipTextAt(this.pressedCloseButtonIndex, null);
        }
    }

    private void setMouseOverCloseButtonIndex(int index) {
        Rectangle r;
        if (this.mouseOverCloseButtonIndex == index) {
            return;
        }
        if (this.mouseOverCloseButtonIndex >= 0 && this.mouseOverCloseButtonIndex < this.getTabCount()) {
            r = this.getCloseButtonBoundsAt(this.mouseOverCloseButtonIndex);
            this.repaint(r.x, r.y, r.width + 2, r.height + 2);
            JComponent c = this._getJComponentAt(this.mouseOverCloseButtonIndex);
            if (c != null) {
                this.setToolTipTextAt(this.mouseOverCloseButtonIndex, c.getToolTipText());
            }
        }
        this.mouseOverCloseButtonIndex = index;
        if (this.mouseOverCloseButtonIndex >= 0 && this.mouseOverCloseButtonIndex < this.getTabCount()) {
            r = this.getCloseButtonBoundsAt(this.mouseOverCloseButtonIndex);
            this.repaint(r.x, r.y, r.width + 2, r.height + 2);
            this.setPressedCloseButtonIndex(-1);
            this.setToolTipTextAt(this.mouseOverCloseButtonIndex, null);
        }
    }

    private JComponent _getJComponentAt(int tabIndex) {
        Component c = this.getComponentAt(tabIndex);
        return c instanceof JComponent ? (JComponent)c : null;
    }

    private void fireCloseRequest(Component c) {
        this.firePropertyChange(PROP_CLOSE, null, c);
    }

    static void fixGetBoundsAt(Rectangle b) {
        if (b.y < 0) {
            b.y = -b.y;
        }
        if (b.x < 0) {
            b.x = -b.x;
        }
    }

    static int findTabForCoordinate(JTabbedPane tab, int x, int y) {
        for (int i = 0; i < tab.getTabCount(); ++i) {
            Rectangle b = tab.getBoundsAt(i);
            if (b == null) continue;
            b = new Rectangle(b);
            CloseButtonTabbedPane.fixGetBoundsAt(b);
            if (!b.contains(x, y)) continue;
            return i;
        }
        return -1;
    }

    protected void processMouseEvent(MouseEvent me) {
        try {
            super.processMouseEvent(me);
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            Exceptions.attachLocalizedMessage((Throwable)aioobe, (String)"Suppressed AIOOBE bug in BasicTabbedPaneUI");
            Logger.getAnonymousLogger().log(Level.WARNING, null, aioobe);
        }
    }

    private class CBTPPolicy
    extends FocusTraversalPolicy {
        private CBTPPolicy() {
        }

        public Component getComponentAfter(Container aContainer, Component aComponent) {
            return CloseButtonTabbedPane.this.sel();
        }

        public Component getComponentBefore(Container aContainer, Component aComponent) {
            return CloseButtonTabbedPane.this.sel();
        }

        public Component getFirstComponent(Container aContainer) {
            return CloseButtonTabbedPane.this.sel();
        }

        public Component getLastComponent(Container aContainer) {
            return CloseButtonTabbedPane.this.sel();
        }

        public Component getDefaultComponent(Container aContainer) {
            return CloseButtonTabbedPane.this.sel();
        }
    }

    private static class CloseButtonListener
    implements AWTEventListener {
        private static boolean installed = false;

        private CloseButtonListener() {
        }

        private static synchronized void install() {
            if (installed) {
                return;
            }
            installed = true;
            Toolkit.getDefaultToolkit().addAWTEventListener(new CloseButtonListener(), 48L);
        }

        public void eventDispatched(AWTEvent ev) {
            Component c;
            MouseEvent e = (MouseEvent)ev;
            for (c = (Component)e.getSource(); c != null && !(c instanceof CloseButtonTabbedPane); c = c.getParent()) {
            }
            if (c == null) {
                return;
            }
            CloseButtonTabbedPane tab = (CloseButtonTabbedPane)c;
            Point p = SwingUtilities.convertPoint((Component)e.getSource(), e.getPoint(), tab);
            if (e.getID() == 500) {
                return;
            }
            int index = CloseButtonTabbedPane.findTabForCoordinate(tab, p.x, p.y);
            Rectangle r = null;
            if (index >= 0) {
                r = tab.getCloseButtonBoundsAt(index);
            }
            if (r == null) {
                r = new Rectangle(0, 0, 0, 0);
            }
            switch (e.getID()) {
                case 501: {
                    if (!r.contains(p)) break;
                    tab.setPressedCloseButtonIndex(index);
                    tab.draggedOut = false;
                    e.consume();
                    return;
                }
                case 502: {
                    if (r.contains(p) && tab.pressedCloseButtonIndex >= 0) {
                        Component tc = tab.getComponentAt(tab.pressedCloseButtonIndex);
                        tab.reset();
                        tab.fireCloseRequest(tc);
                        e.consume();
                        return;
                    }
                    tab.reset();
                    break;
                }
                case 504: {
                    break;
                }
                case 505: {
                    break;
                }
                case 503: {
                    if (r.contains(p)) {
                        tab.setMouseOverCloseButtonIndex(index);
                        tab.draggedOut = false;
                        e.consume();
                        return;
                    }
                    if (tab.mouseOverCloseButtonIndex < 0) break;
                    tab.setMouseOverCloseButtonIndex(-1);
                    tab.draggedOut = false;
                    e.consume();
                    break;
                }
                case 506: {
                    if (tab.pressedCloseButtonIndex < 0) break;
                    if (tab.draggedOut != !r.contains(p)) {
                        tab.draggedOut = !r.contains(p);
                        tab.repaint(r.x, r.y, r.width + 2 + 6, r.height + 2 + 6);
                    }
                    e.consume();
                    return;
                }
            }
        }
    }
}

