/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.core.settings;

import java.beans.IntrospectionException;
import java.util.prefs.Preferences;
import org.netbeans.modules.xml.core.settings.Util;
import org.openide.nodes.BeanNode;
import org.openide.util.HelpCtx;
import org.openide.util.NbPreferences;
import org.openide.util.actions.SystemAction;

public class CoreSettings {
    private static final CoreSettings INSTANCE = new CoreSettings();
    public static final String PROP_AUTO_PARSING_DELAY = "autoParsingDelay";
    public static final String PROP_DEFAULT_ACTION = "defaultAction";
    public static final String PROP_PREFERED_SHORT_EMPTY_ELEMENT = "preferedShortEmptyElement";

    private static Preferences getPreferences() {
        return NbPreferences.forModule((Class)CoreSettings.class);
    }

    public static CoreSettings getDefault() {
        return INSTANCE;
    }

    private CoreSettings() {
    }

    public String displayName() {
        String displayName = Util.THIS.getString("CTL_XML_option");
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("CoreSettings::displayName = " + displayName);
        }
        return displayName;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public int getAutoParsingDelay() {
        int autoParsingDelay = CoreSettings.getPreferences().getInt(PROP_AUTO_PARSING_DELAY, 3000);
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("CoreSettings::getAutoParsingDelay: " + autoParsingDelay);
        }
        return autoParsingDelay;
    }

    public void setAutoParsingDelay(int delay) {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("CoreSettings::setAutoParsingDelay: " + delay);
        }
        if (delay < 0) {
            throw new IllegalArgumentException();
        }
        CoreSettings.getPreferences().putInt(PROP_AUTO_PARSING_DELAY, delay);
    }

    public String getDefaultAction() {
        return CoreSettings.getPreferences().get(PROP_DEFAULT_ACTION, null);
    }

    public void setDefaultAction(String defaultAction) {
        CoreSettings.getPreferences().put(PROP_DEFAULT_ACTION, defaultAction);
    }

    public SystemAction getDefaultAction(SystemAction[] actions, SystemAction systemDefault) {
        String defaultAction = this.getDefaultAction();
        if (defaultAction == null) {
            return systemDefault;
        }
        if (actions == null) {
            return systemDefault;
        }
        for (int i = 0; i < actions.length; ++i) {
            Class<?> klass;
            String name;
            SystemAction next = actions[i];
            if (next == null || !(name = (klass = next.getClass()).getName()).equals(defaultAction)) continue;
            return next;
        }
        return systemDefault;
    }

    public boolean isPreferedShortEmptyElement() {
        return CoreSettings.getPreferences().getBoolean(PROP_PREFERED_SHORT_EMPTY_ELEMENT, false);
    }

    public void setPreferedShortEmptyElement(boolean pref) {
        CoreSettings.getPreferences().putBoolean(PROP_PREFERED_SHORT_EMPTY_ELEMENT, pref);
    }

    private static BeanNode createViewNode() throws IntrospectionException {
        return new BeanNode((Object)CoreSettings.getDefault());
    }
}

