/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.core.wizard;

import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.xml.core.wizard.ExternalReferenceDecorator;
import org.netbeans.modules.xml.core.wizard.FolderNode;
import org.netbeans.modules.xml.core.wizard.Util;
import org.netbeans.modules.xml.core.wizard.WaitNode;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.RequestProcessor;

public class NamespaceChildren
extends Children.Keys {
    private HashMap nsFilesMap;
    private FileObject[] rootFolders;
    private ExternalReferenceDecorator decorator;

    public NamespaceChildren(FileObject[] roots, ExternalReferenceDecorator decorator) {
        this.rootFolders = roots;
        this.decorator = decorator;
        this.nsFilesMap = new HashMap();
    }

    protected Node[] createNodes(Object key) {
        List fobjs;
        if (key == WaitNode.WAIT_KEY) {
            return WaitNode.createNode();
        }
        if (key instanceof String && (fobjs = (List)this.nsFilesMap.get(key)) != null && !fobjs.isEmpty()) {
            Node[] filterNodes = new Node[fobjs.size()];
            int i = 0;
            for (int j = 0; j < fobjs.size(); ++j) {
                try {
                    FileObject fobj = (FileObject)fobjs.get(j);
                    Node node = DataObject.find((FileObject)fobj).getNodeDelegate();
                    filterNodes[i++] = this.decorator.createExternalReferenceNode(node);
                    continue;
                }
                catch (DataObjectNotFoundException donfe) {
                    // empty catch block
                }
            }
            Children.Array children = new Children.Array();
            children.add(filterNodes);
            NamespaceNode node = new NamespaceNode((Children)children, (String)key);
            return new Node[]{node};
        }
        return new Node[0];
    }

    protected void addNotify() {
        super.addNotify();
        this.setKeys(WaitNode.getKeys());
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                for (int i = 0; i < NamespaceChildren.this.rootFolders.length; ++i) {
                    FileObject root = NamespaceChildren.this.rootFolders[i];
                    Map map = Util.getFiles2NSMappingInProj(FileUtil.toFile((FileObject)root), Util.getDocumentType());
                    Set set = map.entrySet();
                    Iterator it = set.iterator();
                    while (it.hasNext()) {
                        Map.Entry entry = it.next();
                        String ns = (String)entry.getValue();
                        ArrayList<FileObject> fobjs = (ArrayList<FileObject>)NamespaceChildren.this.nsFilesMap.get(ns);
                        if (fobjs == null) {
                            fobjs = new ArrayList<FileObject>();
                        }
                        fobjs.add((FileObject)entry.getKey());
                        NamespaceChildren.this.nsFilesMap.put(ns, fobjs);
                    }
                }
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        NamespaceChildren.this.setKeys(NamespaceChildren.this.nsFilesMap.keySet());
                    }
                });
            }
        });
    }

    protected void removeNotify() {
        this.setKeys(Collections.emptySet());
    }

    private static class NamespaceNode
    extends FolderNode {
        public static final String NO_NAME_SPACE = "NO_NAME_SPACE";

        NamespaceNode(Children children, String myNamespace) {
            super(children);
            this.setName(myNamespace);
            if (NO_NAME_SPACE.equals(myNamespace)) {
                this.setDisplayName("NoTargetNameSpace");
            }
        }

        public String getHtmlDisplayName() {
            String name = this.getDisplayName();
            return name;
        }

        public String getNamespace() {
            return this.getName();
        }
    }
}

