/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.core.wizard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import javax.swing.tree.TreePath;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.xml.core.wizard.AbstractPanel;
import org.netbeans.modules.xml.core.wizard.ExternalReferenceDataNode;
import org.netbeans.modules.xml.core.wizard.ExternalReferenceDecorator;
import org.netbeans.modules.xml.core.wizard.FolderNode;
import org.netbeans.modules.xml.core.wizard.NamespaceChildren;
import org.netbeans.modules.xml.core.wizard.SchemaParser;
import org.netbeans.modules.xml.core.wizard.Util;
import org.netbeans.spi.project.SubprojectProvider;
import org.netbeans.spi.project.ui.LogicalViewProvider;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.TreeTableView;
import org.openide.explorer.view.Visualizer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.util.NbBundle;

public class SchemaPanel
extends AbstractPanel
implements ExplorerManager.Provider,
PropertyChangeListener,
ItemListener,
ActionListener {
    private static final long serialVersionUID = -7568909683682244030L;
    private transient ExplorerManager explorerManager;
    private TemplateWizard templateWizard;
    private ExternalReferenceDecorator decorator;
    private Map registeredNodes;
    private FileObject primarySchema;
    private DefaultComboBoxModel nsModel;
    private DefaultComboBoxModel rootModel;
    private JLabel locationLabel;
    private JPanel locationPanel;
    private JLabel namespaceLabel;
    private JTextField namespaceTextField;
    private JCheckBox primarySchemaCheckBox;
    private JComboBox rootComboBox;
    private JLabel rootElementLabel;
    private JPanel schemaDetailPanel;
    static /* synthetic */ Class class$org$netbeans$modules$xml$core$wizard$SchemaPanel$Column;
    static final /* synthetic */ boolean $assertionsDisabled;

    public SchemaPanel(TemplateWizard tw) {
        this.initComponents();
        this.initAccessibility();
        this.templateWizard = tw;
        this.registeredNodes = new HashMap();
        this.decorator = new ExternalReferenceDecorator(this);
        LocationView locationView = new LocationView();
        locationView.setDefaultActionAllowed(false);
        locationView.setPopupAllowed(false);
        locationView.setSelectionMode(1);
        locationView.setRootVisible(false);
        locationView.getAccessibleContext().setAccessibleName(this.locationLabel.getToolTipText());
        locationView.getAccessibleContext().setAccessibleDescription(this.locationLabel.getToolTipText());
        Node.Property[] columns = new Node.Property[]{new Column("name", String.class, true), new ImportColumn("Import"), new Column("prefix", String.class, false)};
        locationView.setProperties(columns);
        locationView.setTreePreferredWidth(200);
        locationView.setTableColumnPreferredWidth(0, 25);
        locationView.setTableColumnPreferredWidth(1, 25);
        this.locationPanel.add((Component)((Object)locationView), "Center");
        this.explorerManager = new ExplorerManager();
        this.explorerManager.addPropertyChangeListener((PropertyChangeListener)this);
        this.explorerManager.setRootContext(this.createRootNode());
    }

    private void initComponents() {
        this.locationPanel = new JPanel();
        this.locationLabel = new JLabel();
        this.schemaDetailPanel = new JPanel();
        this.rootComboBox = new JComboBox();
        this.rootElementLabel = new JLabel();
        this.primarySchemaCheckBox = new JCheckBox();
        this.primarySchemaCheckBox.addItemListener(this);
        this.namespaceLabel = new JLabel();
        this.namespaceTextField = new JTextField();
        this.setName(Util.THIS.getString("PROP_schema_panel_name"));
        this.locationPanel.setBorder(BorderFactory.createEtchedBorder());
        this.locationPanel.setLayout(new BorderLayout());
        this.locationLabel.setLabelFor(this.locationPanel);
        this.locationLabel.setText(NbBundle.getMessage((Class)SchemaPanel.class, (String)"LBL_SchemaPanel_Location"));
        this.locationLabel.setToolTipText(NbBundle.getMessage((Class)SchemaPanel.class, (String)"TIP_SchemaPanel_Location"));
        this.schemaDetailPanel.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage((Class)SchemaPanel.class, (String)"LBL_SchemaDetailPanel_Header")));
        this.rootComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.rootComboBox.setEnabled(false);
        this.rootElementLabel.setLabelFor(this.rootComboBox);
        this.rootElementLabel.setText(NbBundle.getMessage((Class)SchemaPanel.class, (String)"LBL_SchemaPanel_Root_Element"));
        this.rootElementLabel.setToolTipText(NbBundle.getMessage((Class)SchemaPanel.class, (String)"TIP_SchemaPanel_Root_Element"));
        this.rootElementLabel.setEnabled(false);
        this.primarySchemaCheckBox.setText(NbBundle.getMessage((Class)SchemaPanel.class, (String)"LBL_SchemaPanel_Primary_Schema"));
        this.primarySchemaCheckBox.setToolTipText(NbBundle.getMessage((Class)SchemaPanel.class, (String)"TIP_SchemaPanel_Primary_Schema"));
        this.primarySchemaCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.primarySchemaCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.namespaceLabel.setLabelFor(this.namespaceTextField);
        this.namespaceLabel.setText(NbBundle.getMessage((Class)SchemaPanel.class, (String)"LBL_SchemaPanel_Namespace"));
        this.namespaceLabel.setToolTipText(NbBundle.getMessage((Class)SchemaPanel.class, (String)"TIP_SchemaPanel_Namespace"));
        GroupLayout schemaDetailPanelLayout = new GroupLayout((Container)this.schemaDetailPanel);
        this.schemaDetailPanel.setLayout((LayoutManager)schemaDetailPanelLayout);
        schemaDetailPanelLayout.setHorizontalGroup((GroupLayout.Group)schemaDetailPanelLayout.createParallelGroup(1).add((GroupLayout.Group)schemaDetailPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)schemaDetailPanelLayout.createParallelGroup(1).add((GroupLayout.Group)schemaDetailPanelLayout.createSequentialGroup().add(20, 20, 20).add((Component)this.rootElementLabel).add(16, 16, 16).add((Component)this.rootComboBox, -2, 116, -2)).add((Component)this.primarySchemaCheckBox).add((GroupLayout.Group)schemaDetailPanelLayout.createSequentialGroup().add((Component)this.namespaceLabel).addPreferredGap(0).add((Component)this.namespaceTextField, -1, 375, Short.MAX_VALUE))).addContainerGap()));
        schemaDetailPanelLayout.setVerticalGroup((GroupLayout.Group)schemaDetailPanelLayout.createParallelGroup(1).add(2, (GroupLayout.Group)schemaDetailPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).add((GroupLayout.Group)schemaDetailPanelLayout.createParallelGroup(3).add((Component)this.namespaceLabel).add((Component)this.namespaceTextField, -2, -1, -2)).add(19, 19, 19).add((Component)this.primarySchemaCheckBox).addPreferredGap(0).add((GroupLayout.Group)schemaDetailPanelLayout.createParallelGroup(3).add((Component)this.rootElementLabel).add((Component)this.rootComboBox, -2, -1, -2)).addContainerGap()));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.locationLabel).add((Component)this.schemaDetailPanel, -1, -1, Short.MAX_VALUE).add(2, (Component)this.locationPanel, -1, 487, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.locationLabel).addPreferredGap(0).add((Component)this.locationPanel, -2, 247, -2).addPreferredGap(0).add((Component)this.schemaDetailPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
    }

    private void primarySchemaCheckBoxActionPerformed(ActionEvent evt) {
    }

    private void initAccessibility() {
        Util util = Util.THIS;
        this.locationLabel.setDisplayedMnemonic(util.getChar("PROP_schema_locationLabel_mne"));
        this.rootElementLabel.setDisplayedMnemonic(util.getChar("PROP_schema_rootLabel_mne"));
        this.namespaceLabel.setDisplayedMnemonic(util.getChar("PROP_schema_nsLabel_mne"));
        this.primarySchemaCheckBox.setMnemonic(util.getChar("PROP_schema_checkbox_mne"));
    }

    private void updatePossibilities() {
        Component editor;
        SchemaParser parser = new SchemaParser();
        String systemId = null;
        try {
            URL context = this.model.getTargetFolderURL();
            if (context != null) {
                systemId = new URL(context, systemId).toExternalForm();
            }
        }
        catch (MalformedURLException ex) {
            // empty catch block
        }
        SchemaParser.SchemaInfo info = parser.parse(systemId);
        if (info == null) {
            return;
        }
        this.nsModel.removeAllElements();
        if (info.namespace != null) {
            this.nsModel.addElement(info.namespace);
        }
        if (info.roots.size() > 0) {
            this.rootModel.removeAllElements();
            Iterator it = info.roots.iterator();
            while (it.hasNext()) {
                String next = (String)it.next();
                this.rootModel.addElement(next);
            }
        }
        if ((editor = this.rootComboBox.getEditor().getEditorComponent()) instanceof JTextComponent) {
            ((JTextComponent)editor).selectAll();
        }
    }

    protected void initView() {
        this.rootModel = new DefaultComboBoxModel();
        this.rootComboBox.setModel(this.rootModel);
    }

    protected void updateModel() {
        File file;
        String uri = null;
        if (this.primarySchema != null && (uri = (file = FileUtil.toFile((FileObject)this.primarySchema)).getName()) != null) {
            uri = uri.replaceAll(" ", "%20");
            try {
                uri = new URI(uri).toASCIIString();
            }
            catch (URISyntaxException e) {
                // empty catch block
            }
        }
        this.model.setSystemID(uri == null || uri.length() == 0 ? null : uri);
        String ns = this.namespaceTextField.getText();
        this.model.setNamespace(ns == null ? null : ns);
        Object root = this.rootComboBox.getSelectedItem();
        this.model.setRoot(root == null ? null : root.toString());
        int selected = this.countSelectedNodes();
        if (selected > 0) {
            List nodes = this.getSelectedNodes();
            for (int i = 0; i < nodes.size(); ++i) {
                ExternalReferenceDataNode erdn;
                Node n = (Node)nodes.get(i);
                if (!(n instanceof ExternalReferenceDataNode) || !ns.equals((erdn = (ExternalReferenceDataNode)n).getNamespace()) || !uri.equals(erdn.getSchemaFileName())) continue;
                this.model.setPrefix(erdn.getPrefix());
            }
            this.model.setSchemaNodes(nodes);
        }
    }

    protected void updateView() {
    }

    protected Node createRootNode() {
        try {
            DataFolder folder = this.templateWizard.getTargetFolder();
            Project project = FileOwnerQuery.getOwner((FileObject)folder.getPrimaryFile());
            SubprojectProvider provider = (SubprojectProvider)project.getLookup().lookup(SubprojectProvider.class);
            Set refProjects = provider.getSubprojects();
            Iterator it = refProjects.iterator();
            Node[] rootNodes = new Node[1 + (refProjects == null ? 0 : refProjects.size())];
            LogicalViewProvider viewProvider = (LogicalViewProvider)project.getLookup().lookup(LogicalViewProvider.class);
            rootNodes[0] = this.decorator.createExternalReferenceNode(viewProvider.createLogicalView());
            int rootIndex = 1;
            ArrayList<FileObject> projectRoots = new ArrayList<FileObject>();
            projectRoots.add(project.getProjectDirectory());
            if (refProjects != null) {
                while (it.hasNext()) {
                    Object o = it.next();
                    Project refPrj = (Project)o;
                    viewProvider = (LogicalViewProvider)refPrj.getLookup().lookup(class$org$netbeans$spi$project$ui$LogicalViewProvider == null ? SchemaPanel.class$("org.netbeans.spi.project.ui.LogicalViewProvider") : class$org$netbeans$spi$project$ui$LogicalViewProvider);
                    rootNodes[rootIndex++] = this.decorator.createExternalReferenceNode(viewProvider.createLogicalView());
                    projectRoots.add(refPrj.getProjectDirectory());
                }
            }
            FileObject[] roots = projectRoots.toArray(new FileObject[projectRoots.size()]);
            Children.Array fileChildren = new Children.Array();
            fileChildren.add(rootNodes);
            FolderNode byFilesNode = new FolderNode((Children)fileChildren);
            byFilesNode.setDisplayName(NbBundle.getMessage((Class)SchemaPanel.class, (String)"LBL_SchemaPanel_Category_By_File"));
            NamespaceChildren nsChildren = new NamespaceChildren(roots, this.decorator);
            FolderNode byNsNode = new FolderNode((Children)nsChildren);
            byNsNode.setDisplayName(NbBundle.getMessage((Class)SchemaPanel.class, (String)"LBL_SchemaPanel_Category_By_Namespace"));
            Children.Array categories = new Children.Array();
            categories.add(new Node[]{byFilesNode, byNsNode});
            AbstractNode rootNode = new AbstractNode((Children)categories);
            rootNode.setDisplayName(NbBundle.getMessage((Class)SchemaPanel.class, (String)"CTL_SchemaPanel_Column_Name_name"));
            rootNode.setShortDescription(NbBundle.getMessage((Class)SchemaPanel.class, (String)"CTL_SchemaPanel_Column_Desc_name"));
            return rootNode;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public ExplorerManager getExplorerManager() {
        return this.explorerManager;
    }

    public ExternalReferenceDataNode createExternalReferenceNode(Node original) {
        DataObject dobj = (DataObject)original.getLookup().lookup(DataObject.class);
        NodeSet set = (NodeSet)this.registeredNodes.get(dobj);
        if (set == null) {
            set = new NodeSet(this);
            this.registeredNodes.put(dobj, set);
        }
        ExternalReferenceDataNode erdn = new ExternalReferenceDataNode(original, this.decorator);
        set.add(erdn);
        if (set.isSelected() && erdn.canSelect()) {
            erdn.setSelected(true);
        }
        erdn.addPropertyChangeListener(this);
        return erdn;
    }

    public void propertyChange(PropertyChangeEvent event) {
        String pname = event.getPropertyName();
        if ("selectedNodes".equals(pname)) {
            Node[] nodes = (Node[])event.getNewValue();
            if (nodes != null && nodes.length > 0 && nodes[0] instanceof ExternalReferenceDataNode) {
                ExternalReferenceDataNode node = (ExternalReferenceDataNode)nodes[0];
                this.validateInput(node);
            }
        } else if (pname.equals("prefix")) {
            ExternalReferenceDataNode erdn = (ExternalReferenceDataNode)((Object)event.getSource());
            String prefix = (String)event.getNewValue();
            DataObject dobj = (DataObject)erdn.getLookup().lookup(DataObject.class);
            NodeSet set = (NodeSet)this.registeredNodes.get(dobj);
            if (!$assertionsDisabled && set == null) {
                throw new AssertionError((Object)"node not created by customizer");
            }
            if (set == null) {
                set = new NodeSet(this);
                set.add(erdn);
            }
            set.setPrefix(prefix);
            this.validateInput(erdn);
        } else if (pname.equals("selected")) {
            ExternalReferenceDataNode erdn = (ExternalReferenceDataNode)((Object)event.getSource());
            boolean selected = (Boolean)event.getNewValue();
            DataObject dobj = (DataObject)erdn.getLookup().lookup(DataObject.class);
            NodeSet set = (NodeSet)this.registeredNodes.get(dobj);
            if (!$assertionsDisabled && set == null) {
                throw new AssertionError((Object)"node not created by customizer");
            }
            if (set == null) {
                set = new NodeSet(this);
                set.add(erdn);
            }
            set.setSelected(selected);
            this.validateInput(erdn);
        }
    }

    private void validateInput(ExternalReferenceDataNode erdn) {
        int selected;
        String msg = null;
        String ep = erdn.getPrefix();
        if (ep.length() == 0 || !this.isValidPrefix(erdn) && erdn.isSelected()) {
            msg = NbBundle.getMessage((Class)SchemaPanel.class, (String)"LBL_SchemaPanel_InvalidPrefix");
        }
        if ((selected = this.countSelectedNodes()) < 0) {
            msg = "ERROR MSG";
        }
    }

    private boolean isValidPrefix(ExternalReferenceDataNode node) {
        DataObject dobj = (DataObject)node.getLookup().lookup(DataObject.class);
        NodeSet nodeSet = (NodeSet)this.registeredNodes.get(dobj);
        Collection sets = this.registeredNodes.values();
        Iterator it = sets.iterator();
        while (it.hasNext()) {
            NodeSet set = (NodeSet)it.next();
            if (set.equals(nodeSet) || !set.isSelected()) continue;
            ExternalReferenceDataNode other = (ExternalReferenceDataNode)((Object)set.getNodes().get(0));
            if (!node.getPrefix().equals(other.getPrefix())) continue;
            return false;
        }
        return true;
    }

    public int countSelectedNodes() {
        int results = 0;
        Collection sets = this.registeredNodes.values();
        Iterator it = sets.iterator();
        while (it.hasNext()) {
            NodeSet set = (NodeSet)it.next();
            List nodes = set.getNodes();
            if (nodes.size() <= 0) continue;
            ++results;
        }
        return results;
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            Component editor;
            if (this.primarySchema == null) {
                return;
            }
            this.rootComboBox.setEnabled(true);
            this.rootElementLabel.setEnabled(true);
            SchemaParser.SchemaInfo info = Util.getRootElements(this.primarySchema);
            if (info == null) {
                this.rootModel.removeAllElements();
                return;
            }
            if (info.roots.size() > 0) {
                this.rootModel.removeAllElements();
                Iterator it = info.roots.iterator();
                while (it.hasNext()) {
                    String next = (String)it.next();
                    this.rootModel.addElement(next);
                }
            }
            if ((editor = this.rootComboBox.getEditor().getEditorComponent()) instanceof JTextComponent) {
                ((JTextComponent)editor).selectAll();
            }
            this.fireChange();
        } else if (e.getStateChange() == 2) {
            this.rootComboBox.setEnabled(false);
            this.rootElementLabel.setEnabled(false);
            this.rootModel.removeAllElements();
            this.fireChange();
        }
    }

    public void actionPerformed(ActionEvent evt) {
        this.primarySchemaCheckBox.setEnabled(true);
    }

    public boolean isPrimarySchemaSelected() {
        return this.primarySchemaCheckBox.isSelected();
    }

    protected List getSelectedNodes() {
        LinkedList results = new LinkedList();
        Collection sets = this.registeredNodes.values();
        Iterator it = sets.iterator();
        while (it.hasNext()) {
            List nodes;
            NodeSet set = (NodeSet)it.next();
            if (!set.isSelected() || (nodes = set.getNodes()).size() <= 0) continue;
            results.add(nodes.get(0));
        }
        return results;
    }

    static {
        $assertionsDisabled = !SchemaPanel.class.desiredAssertionStatus();
    }

    protected class Column
    extends PropertySupport.ReadOnly {
        private String key;

        public Column(String key, Class type, boolean tree) {
            super(key, type, NbBundle.getMessage((Class)(class$org$netbeans$modules$xml$core$wizard$SchemaPanel$Column == null ? (class$org$netbeans$modules$xml$core$wizard$SchemaPanel$Column = SchemaPanel.class$("org.netbeans.modules.xml.core.wizard.SchemaPanel$Column")) : class$org$netbeans$modules$xml$core$wizard$SchemaPanel$Column), (String)("CTL_SchemaPanel_Column_Name_" + key)), NbBundle.getMessage((Class)(class$org$netbeans$modules$xml$core$wizard$SchemaPanel$Column == null ? (class$org$netbeans$modules$xml$core$wizard$SchemaPanel$Column = SchemaPanel.class$("org.netbeans.modules.xml.core.wizard.SchemaPanel$Column")) : class$org$netbeans$modules$xml$core$wizard$SchemaPanel$Column), (String)("CTL_SchemaPanel_Column_Desc_" + key)));
            this.key = key;
            this.setValue("TreeColumnTTV", tree);
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.key;
        }
    }

    protected class ImportColumn
    extends PropertySupport.ReadOnly {
        private String key;

        public ImportColumn(String name) {
            super("selected", Boolean.TYPE, name, NbBundle.getMessage((Class)(class$org$netbeans$modules$xml$core$wizard$SchemaPanel$Column == null ? (class$org$netbeans$modules$xml$core$wizard$SchemaPanel$Column = SchemaPanel.class$("org.netbeans.modules.xml.core.wizard.SchemaPanel$Column")) : class$org$netbeans$modules$xml$core$wizard$SchemaPanel$Column), (String)"CTL_SchemaPanel_Column_Desc_selected"));
            this.key = "selected";
            this.setValue("TreeColumnTTV", Boolean.FALSE);
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.key;
        }
    }

    private class LocationView
    extends TreeTableView {
        private static final long serialVersionUID = 1L;

        public LocationView() {
            this.tree.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    ExternalReferenceDataNode erdn;
                    Object comp;
                    Node node;
                    TreePath path = LocationView.this.tree.getPathForLocation(e.getX(), e.getY());
                    if (path != null && (node = Visualizer.findNode((Object)(comp = path.getLastPathComponent()))) instanceof ExternalReferenceDataNode && (erdn = (ExternalReferenceDataNode)node).canSelect()) {
                        DataObject dobj;
                        FileObject fobj;
                        boolean selected = !erdn.isSelected();
                        String ns = null;
                        if (selected && !(fobj = (dobj = (DataObject)erdn.getLookup().lookup(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = SchemaPanel.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject)).getPrimaryFile()).isFolder()) {
                            ns = erdn.getNamespace();
                            SchemaPanel.this.primarySchema = fobj;
                            if (SchemaPanel.this.primarySchemaCheckBox.isSelected()) {
                                SchemaParser.SchemaInfo info = Util.getRootElements(SchemaPanel.this.primarySchema);
                                if (info == null) {
                                    SchemaPanel.this.rootModel.removeAllElements();
                                    return;
                                }
                                if (info.roots.size() > 0) {
                                    SchemaPanel.this.rootModel.removeAllElements();
                                    Iterator it = info.roots.iterator();
                                    while (it.hasNext()) {
                                        String next = (String)it.next();
                                        SchemaPanel.this.rootModel.addElement(next);
                                    }
                                }
                            }
                        }
                        SchemaPanel.this.namespaceTextField.setText(ns);
                        erdn.setSelected(selected);
                        if (SchemaPanel.this.primarySchemaCheckBox.isSelected()) {
                            SchemaPanel.this.primarySchemaCheckBox.setSelected(selected);
                        }
                    }
                }
            });
        }
    }

    private static class NodeSet {
        private PropertyChangeListener listener;
        private List nodes;
        private boolean selected;

        public NodeSet(PropertyChangeListener listener) {
            this.listener = listener;
        }

        public void add(ExternalReferenceDataNode node) {
            if (this.nodes == null) {
                this.nodes = new LinkedList();
            }
            this.nodes.add(node);
        }

        public List getNodes() {
            return this.nodes;
        }

        public boolean isSelected() {
            return this.selected;
        }

        public void setPrefix(String prefix) {
            for (int i = 0; i < this.nodes.size(); ++i) {
                ExternalReferenceDataNode node = (ExternalReferenceDataNode)((Object)this.nodes.get(i));
                if (node.getPrefix().equals(prefix)) continue;
                node.removePropertyChangeListener(this.listener);
                node.setPrefix(prefix);
                node.addPropertyChangeListener(this.listener);
            }
        }

        public void setSelected(boolean select) {
            this.selected = select;
            for (int i = 0; i < this.nodes.size(); ++i) {
                ExternalReferenceDataNode node = (ExternalReferenceDataNode)((Object)this.nodes.get(i));
                if (!node.canSelect()) continue;
                node.removePropertyChangeListener(this.listener);
                node.setSelected(select);
                node.addPropertyChangeListener(this.listener);
            }
        }
    }
}

