/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.lib2;

import org.netbeans.modules.editor.lib2.Acceptor;

public class AcceptorFactory {
    public static final Acceptor TRUE = new Fixed(true);
    public static final Acceptor FALSE = new Fixed(false);
    public static final Acceptor NL = new Char('\n');
    public static final Acceptor SPACE_NL = new TwoChar(' ', '\n');
    public static final Acceptor WHITESPACE = new Acceptor(){

        public final boolean accept(char ch) {
            return Character.isWhitespace(ch);
        }
    };
    public static final Acceptor LETTER_DIGIT = new Acceptor(){

        public final boolean accept(char ch) {
            return Character.isLetterOrDigit(ch);
        }
    };
    public static final Acceptor JAVA_IDENTIFIER = new Acceptor(){

        public final boolean accept(char ch) {
            return Character.isJavaIdentifierPart(ch);
        }
    };
    public static final Acceptor NON_JAVA_IDENTIFIER = new Acceptor(){

        public final boolean accept(char ch) {
            return !Character.isJavaIdentifierPart(ch);
        }
    };

    private static final class Char
    implements Acceptor {
        private char hit;

        public Char(char hit) {
            this.hit = hit;
        }

        public final boolean accept(char ch) {
            return ch == this.hit;
        }
    }

    private static final class Fixed
    implements Acceptor {
        private boolean state;

        public Fixed(boolean state) {
            this.state = state;
        }

        public final boolean accept(char ch) {
            return this.state;
        }
    }

    private static final class TwoChar
    implements Acceptor {
        private char hit1;
        private char hit2;

        public TwoChar(char hit1, char hit2) {
            this.hit1 = hit1;
            this.hit2 = hit2;
        }

        public final boolean accept(char ch) {
            return ch == this.hit1 || ch == this.hit2;
        }
    }
}

