/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.lib2;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

public class DocumentsRegistry {
    public static final String DOCUMENT_ID_PROP = "id";
    public static final String COMPONENT_ID_PROP = "componentId";
    private static final WeakReference[] EMPTY = new WeakReference[0];
    private static WeakReference[] docRefs = EMPTY;
    private static int docRefsCount;
    private static final ArrayList<Integer> docAct;
    private static WeakReference[] compRefs;
    private static int compRefsCount;
    private static final ArrayList<Integer> compAct;
    public static final String PROP_ACTIVE_COMPONENT = "org.netbeans.modules.editor.lib2.DocumentsRegistry.PROP_ACTIVE_COMPONENT";
    public static final String PROP_ACTIVE_DOCUMENT = "org.netbeans.modules.editor.lib2.DocumentsRegistry.PROP_ACTIVE_DOCUMENT";
    private static final PropertyChangeSupport PCS;
    private static int consolidateCounter;

    public static void addPropertyChangeListener(PropertyChangeListener l) {
        PCS.addPropertyChangeListener(l);
    }

    public static void removePropertyChangeListener(PropertyChangeListener l) {
        PCS.removePropertyChangeListener(l);
    }

    public static synchronized int getID(Document doc) {
        Integer i = DocumentsRegistry.getIDInteger(doc);
        return i != null ? i : -1;
    }

    public static synchronized int getID(JTextComponent c) {
        return DocumentsRegistry.getIDImpl(c);
    }

    public static synchronized Document getDocument(int docID) {
        if (docID < 0 || docID >= docRefsCount) {
            return null;
        }
        WeakReference wr = docRefs[docID];
        return wr != null ? (Document)wr.get() : null;
    }

    public static synchronized JTextComponent getComponent(int compID) {
        if (compID < 0 || compID >= compRefsCount) {
            return null;
        }
        WeakReference wr = compRefs[compID];
        return wr != null ? (JTextComponent)wr.get() : null;
    }

    public static synchronized int addDocument(Document doc) {
        Integer docID = DocumentsRegistry.getIDInteger(doc);
        if (docID != null) {
            return docID;
        }
        if (docRefsCount >= docRefs.length) {
            docRefs = DocumentsRegistry.realloc(docRefs);
        }
        DocumentsRegistry.docRefs[DocumentsRegistry.docRefsCount] = new WeakReference<Document>(doc);
        doc.putProperty(DOCUMENT_ID_PROP, new Integer(docRefsCount));
        return docRefsCount++;
    }

    public static synchronized int addComponent(JTextComponent c) {
        int compID = DocumentsRegistry.getIDImpl(c);
        if (compID != -1) {
            if (compRefs[compID] == null) {
                DocumentsRegistry.compRefs[compID] = new WeakReference<JTextComponent>(c);
            }
            return compID;
        }
        if (compRefsCount >= compRefs.length) {
            compRefs = DocumentsRegistry.realloc(compRefs);
        }
        DocumentsRegistry.compRefs[DocumentsRegistry.compRefsCount] = new WeakReference<JTextComponent>(c);
        c.putClientProperty(COMPONENT_ID_PROP, new Integer(compRefsCount));
        return compRefsCount++;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int removeComponent(JTextComponent c) {
        boolean lastComponent = false;
        Class<DocumentsRegistry> clazz = DocumentsRegistry.class;
        synchronized (DocumentsRegistry.class) {
            int compID = DocumentsRegistry.getIDImpl(c);
            if (compID != -1) {
                DocumentsRegistry.compRefs[compID] = null;
                for (int i = compAct.size() - 1; i >= 0; --i) {
                    if (compAct.get(i) != compID) continue;
                    compAct.remove(i);
                    break;
                }
                lastComponent = compAct.isEmpty();
            }
            // ** MonitorExit[var3_2] (shouldn't be in output)
            if (lastComponent) {
                PCS.firePropertyChange(PROP_ACTIVE_COMPONENT, null, c);
            }
            return compID;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void activate(JTextComponent c) {
        boolean activated = true;
        Class<DocumentsRegistry> clazz = DocumentsRegistry.class;
        synchronized (DocumentsRegistry.class) {
            int ind;
            int compID = DocumentsRegistry.getIDImpl(c);
            if (compID == -1) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            int actSize = compAct.size();
            for (ind = 0; ind < actSize; ++ind) {
                int id = compAct.get(ind);
                if (id != compID) continue;
                if (ind == 0) break;
                compAct.add(0, compAct.remove(ind));
                activated = true;
                break;
            }
            if (ind == actSize) {
                compAct.add(0, compID);
                activated = true;
            }
            if (DocumentsRegistry.doActivate(c.getDocument())) {
                activated = true;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (activated) {
                PCS.firePropertyChange(PROP_ACTIVE_COMPONENT, null, c);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void activate(Document doc) {
        Class<DocumentsRegistry> clazz = DocumentsRegistry.class;
        synchronized (DocumentsRegistry.class) {
            boolean activated = DocumentsRegistry.doActivate(doc);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            if (activated) {
                PCS.firePropertyChange(PROP_ACTIVE_DOCUMENT, null, doc);
            }
            return;
        }
    }

    public static synchronized Document getMostActiveDocument() {
        return DocumentsRegistry.getValidDoc(0, true);
    }

    public static synchronized Document getLeastActiveDocument() {
        int lastInd = docAct.size() - 1;
        return DocumentsRegistry.getValidDoc(lastInd, false);
    }

    public static Document getLessActiveDocument(Document doc) {
        return DocumentsRegistry.getLessActiveDocument(DocumentsRegistry.getID(doc));
    }

    public static synchronized Document getLessActiveDocument(int docID) {
        return DocumentsRegistry.getNextActiveDoc(docID, true);
    }

    public static Document getMoreActiveDocument(Document doc) {
        return DocumentsRegistry.getMoreActiveDocument(DocumentsRegistry.getID(doc));
    }

    public static synchronized Document getMoreActiveDocument(int docID) {
        return DocumentsRegistry.getNextActiveDoc(docID, false);
    }

    public static synchronized Iterator getDocumentIterator() {
        DocumentsRegistry.consolidate();
        ArrayList<Document> docList = new ArrayList<Document>();
        int actSize = docAct.size();
        for (int i = 0; i < actSize; ++i) {
            Object doc;
            int ind = docAct.get(i);
            WeakReference wr = docRefs[ind];
            if (wr == null || (doc = wr.get()) == null) continue;
            docList.add((Document)doc);
        }
        return docList.iterator();
    }

    public static synchronized JTextComponent getMostActiveComponent() {
        return DocumentsRegistry.getValidComp(0, true);
    }

    public static synchronized JTextComponent getLeastActiveComponent() {
        int lastInd = compAct.size() - 1;
        return DocumentsRegistry.getValidComp(lastInd, false);
    }

    public static JTextComponent getLessActiveComponent(JTextComponent c) {
        return DocumentsRegistry.getLessActiveComponent(DocumentsRegistry.getID(c));
    }

    public static synchronized JTextComponent getLessActiveComponent(int compID) {
        return DocumentsRegistry.getNextActiveComp(compID, true);
    }

    public static JTextComponent getMoreActiveComponent(JTextComponent c) {
        return DocumentsRegistry.getMoreActiveComponent(DocumentsRegistry.getID(c));
    }

    public static synchronized JTextComponent getMoreActiveComponent(int compID) {
        return DocumentsRegistry.getNextActiveComp(compID, false);
    }

    public static synchronized Iterator getComponentIterator() {
        DocumentsRegistry.consolidate();
        ArrayList<JTextComponent> compList = new ArrayList<JTextComponent>();
        int actSize = compAct.size();
        for (int i = 0; i < actSize; ++i) {
            Object comp;
            int ind = compAct.get(i);
            WeakReference wr = compRefs[ind];
            if (wr == null || (comp = wr.get()) == null) continue;
            compList.add((JTextComponent)comp);
        }
        return compList.iterator();
    }

    private static WeakReference[] realloc(WeakReference[] refs) {
        WeakReference[] tmp = new WeakReference[refs.length * 2 + 4];
        System.arraycopy(refs, 0, tmp, 0, refs.length);
        return tmp;
    }

    private static void consolidate() {
        while (++consolidateCounter >= 20) {
            WeakReference wr;
            int ind;
            int i;
            consolidateCounter = 0;
            for (i = docAct.size() - 1; i >= 0; --i) {
                ind = docAct.get(i);
                wr = docRefs[ind];
                if (wr == null || wr.get() != null) continue;
                docAct.remove(i);
                DocumentsRegistry.docRefs[ind] = null;
            }
            for (i = compAct.size() - 1; i >= 0; --i) {
                ind = compAct.get(i);
                wr = compRefs[ind];
                if (wr == null || wr.get() != null) continue;
                compAct.remove(i);
                DocumentsRegistry.compRefs[ind] = null;
            }
        }
    }

    private static int getIDImpl(JTextComponent c) {
        Integer id = c == null ? null : (Integer)c.getClientProperty(COMPONENT_ID_PROP);
        return id == null ? -1 : id;
    }

    private static Integer getIDInteger(Document doc) {
        if (doc == null) {
            return null;
        }
        return (Integer)doc.getProperty(DOCUMENT_ID_PROP);
    }

    private static boolean doActivate(Document doc) {
        Integer docIDInteger = DocumentsRegistry.getIDInteger(doc);
        if (docIDInteger == null) {
            return false;
        }
        int docID = docIDInteger != null ? docIDInteger : -1;
        int size = docAct.size();
        for (int ind = 0; ind < size; ++ind) {
            int id = docAct.get(ind);
            if (id != docID) continue;
            if (ind == 0) {
                return false;
            }
            docAct.add(0, docAct.remove(ind));
            return true;
        }
        docAct.add(0, docIDInteger);
        return true;
    }

    private static Document getValidDoc(int ind, boolean forward) {
        DocumentsRegistry.consolidate();
        int actSize = docAct.size();
        while (ind >= 0 && ind < actSize) {
            Document doc;
            int docID = docAct.get(ind);
            WeakReference wr = docRefs[docID];
            Document document = doc = wr != null ? (Document)wr.get() : null;
            if (doc != null) {
                return doc;
            }
            ind += forward ? 1 : -1;
        }
        return null;
    }

    private static Document getNextActiveDoc(int docID, boolean forward) {
        int ind;
        DocumentsRegistry.consolidate();
        int actSize = docAct.size();
        int n = ind = forward ? 0 : actSize - 1;
        while (ind >= 0 && ind < actSize) {
            if (docAct.get(ind) == docID) {
                return DocumentsRegistry.getValidDoc(ind += forward ? 1 : -1, forward);
            }
            ind += forward ? 1 : -1;
        }
        return null;
    }

    private static JTextComponent getValidComp(int ind, boolean forward) {
        DocumentsRegistry.consolidate();
        int actSize = compAct.size();
        while (ind >= 0 && ind < actSize) {
            JTextComponent c;
            int compID = compAct.get(ind);
            WeakReference wr = compRefs[compID];
            JTextComponent jTextComponent = c = wr != null ? (JTextComponent)wr.get() : null;
            if (c != null) {
                return c;
            }
            ind += forward ? 1 : -1;
        }
        return null;
    }

    private static JTextComponent getNextActiveComp(int compID, boolean forward) {
        int ind;
        int actSize = compAct.size();
        int n = ind = forward ? 0 : actSize - 1;
        while (ind >= 0 && ind < actSize) {
            if (compAct.get(ind) == compID) {
                return DocumentsRegistry.getValidComp(ind += forward ? 1 : -1, forward);
            }
            ind += forward ? 1 : -1;
        }
        return null;
    }

    public static synchronized String registryToString() {
        WeakReference wr;
        int i;
        StringBuffer sb = new StringBuffer();
        sb.append("Document References:\n");
        for (i = 0; i < docRefsCount; ++i) {
            wr = docRefs[i];
            sb.append("docRefs[" + i + "]=" + (wr != null ? wr.get() : "null") + "\n");
        }
        sb.append("Component References:\n");
        for (i = 0; i < compRefsCount; ++i) {
            wr = compRefs[i];
            sb.append("compRefs[" + i + "]=" + (wr != null ? wr.get() : "null") + "\n");
        }
        sb.append("\nActive Document Indexes:\n");
        for (i = 0; i < docAct.size(); ++i) {
            sb.append(docAct.get(i));
            if (i == docAct.size() - 1) continue;
            sb.append(", ");
        }
        sb.append("\nActive Component Indexes:\n");
        for (i = 0; i < compAct.size(); ++i) {
            sb.append(compAct.get(i));
            if (i == compAct.size() - 1) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    private DocumentsRegistry() {
    }

    static {
        docAct = new ArrayList();
        compRefs = EMPTY;
        compAct = new ArrayList();
        PCS = new PropertyChangeSupport(DocumentsRegistry.class);
    }
}

