/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.lib2.highlighting;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.modules.editor.lib2.highlighting.CompoundHighlightsContainer;
import org.netbeans.modules.editor.lib2.highlighting.HighlightingSpiPackageAccessor;
import org.netbeans.modules.editor.lib2.highlighting.HighlightsLayerAccessor;
import org.netbeans.modules.editor.lib2.highlighting.HighlightsLayerFilter;
import org.netbeans.spi.editor.highlighting.HighlightsContainer;
import org.netbeans.spi.editor.highlighting.HighlightsLayer;
import org.netbeans.spi.editor.highlighting.HighlightsLayerFactory;
import org.openide.ErrorManager;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.TopologicalSortException;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.ProxyLookup;

public final class HighlightingManager {
    private static final Logger LOG = Logger.getLogger(HighlightingManager.class.getName());
    private static HighlightingManager instance;
    final WeakHashMap<JTextComponent, WeakReference<Highlighting>> CACHE = new WeakHashMap();

    public static synchronized HighlightingManager getInstance() {
        if (instance == null) {
            instance = new HighlightingManager();
        }
        return instance;
    }

    public HighlightsContainer getHighlights(JTextComponent pane, HighlightsLayerFilter filter) {
        return this.getHighlighting(pane).getContainer(filter);
    }

    private HighlightingManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Highlighting getHighlighting(JTextComponent pane) {
        WeakHashMap<JTextComponent, WeakReference<Highlighting>> weakHashMap = this.CACHE;
        synchronized (weakHashMap) {
            Highlighting h;
            WeakReference<Highlighting> ref = this.CACHE.get(pane);
            Highlighting highlighting = h = ref == null ? null : (Highlighting)ref.get();
            if (h == null) {
                h = new Highlighting(pane);
                this.CACHE.put(pane, new WeakReference<Highlighting>(h));
            }
            return h;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Highlighting
    implements PropertyChangeListener {
        private static final String PROP_MIME_TYPE = "mimeType";
        private static final String PROP_DOCUMENT = "document";
        private static final String PROP_HL_INCLUDES = "HighlightsLayerIncludes";
        private static final String PROP_HL_EXCLUDES = "HighlightsLayerExcludes";
        private Lookup.Result<HighlightsLayerFactory> factories = null;
        private LookupListener factoriesTracker = new LookupListener(){

            public void resultChanged(LookupEvent ev) {
                Highlighting.this.rebuildAllContainers();
            }
        };
        private Lookup.Result<FontColorSettings> settings = null;
        private LookupListener settingsTracker = new LookupListener(){

            public void resultChanged(LookupEvent ev) {
                Highlighting.this.rebuildAllContainers();
            }
        };
        private final JTextComponent pane;
        private HighlightsLayerFilter paneFilter;
        private Document lastKnownDocument = null;
        private MimePath[] lastKnownMimePaths = null;
        private final WeakHashMap<HighlightsLayerFilter, WeakReference<CompoundHighlightsContainer>> containers = new WeakHashMap();

        public Highlighting(JTextComponent pane) {
            this.pane = pane;
            this.paneFilter = new RegExpFilter(pane.getClientProperty(PROP_HL_INCLUDES), pane.getClientProperty(PROP_HL_EXCLUDES));
            this.pane.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)pane));
            this.rebuildAll();
        }

        public synchronized HighlightsContainer getContainer(HighlightsLayerFilter filter) {
            CompoundHighlightsContainer container;
            WeakReference<CompoundHighlightsContainer> ref = this.containers.get(filter);
            CompoundHighlightsContainer compoundHighlightsContainer = container = ref == null ? null : (CompoundHighlightsContainer)ref.get();
            if (container == null) {
                container = new CompoundHighlightsContainer();
                this.rebuildContainer(filter, container);
                this.containers.put(filter, new WeakReference<CompoundHighlightsContainer>(container));
            }
            return container;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName() == null || PROP_DOCUMENT.equals(evt.getPropertyName())) {
                this.rebuildAll();
            }
            if (PROP_HL_INCLUDES.equals(evt.getPropertyName()) || PROP_HL_EXCLUDES.equals(evt.getPropertyName())) {
                Highlighting highlighting = this;
                synchronized (highlighting) {
                    this.paneFilter = new RegExpFilter(this.pane.getClientProperty(PROP_HL_INCLUDES), this.pane.getClientProperty(PROP_HL_EXCLUDES));
                    this.rebuildAllContainers();
                }
            }
        }

        private MimePath[] getAllDocumentMimePath() {
            Document doc = this.pane.getDocument();
            Object propMimeType = doc.getProperty(PROP_MIME_TYPE);
            String mainMimeType = propMimeType != null ? propMimeType.toString() : this.pane.getUI().getEditorKit(this.pane).getContentType();
            return new MimePath[]{MimePath.parse((String)mainMimeType)};
        }

        private synchronized void rebuildAll() {
            Object[] mimePaths = this.getAllDocumentMimePath();
            if (!Utilities.compareObjects((Object)this.lastKnownDocument, (Object)this.pane.getDocument()) || !Arrays.equals(this.lastKnownMimePaths, mimePaths)) {
                if (this.factories != null) {
                    this.factories.removeLookupListener(this.factoriesTracker);
                }
                if (this.settings != null) {
                    this.settings.removeLookupListener(this.settingsTracker);
                }
                if (mimePaths != null) {
                    ArrayList<Lookup> lookups = new ArrayList<Lookup>();
                    for (Object mimePath : mimePaths) {
                        lookups.add(MimeLookup.getLookup((MimePath)mimePath));
                    }
                    ProxyLookup lookup = new ProxyLookup(lookups.toArray(new Lookup[lookups.size()]));
                    this.factories = lookup.lookup(new Lookup.Template(HighlightsLayerFactory.class));
                    this.settings = lookup.lookup(new Lookup.Template(FontColorSettings.class));
                } else {
                    this.factories = null;
                    this.settings = null;
                }
                if (this.factories != null) {
                    this.factories.addLookupListener(this.factoriesTracker);
                    this.factories.allItems();
                }
                if (this.settings != null) {
                    this.settings.addLookupListener(this.settingsTracker);
                    this.settings.allItems();
                }
                this.lastKnownDocument = this.pane.getDocument();
                this.lastKnownMimePaths = mimePaths;
                this.rebuildAllContainers();
            }
        }

        private synchronized void resetAllContainers() {
            for (HighlightsLayerFilter filter : this.containers.keySet()) {
                WeakReference<CompoundHighlightsContainer> ref = this.containers.get(filter);
                CompoundHighlightsContainer container = ref == null ? null : (CompoundHighlightsContainer)ref.get();
                if (container == null) continue;
                container.resetCache();
            }
        }

        private synchronized void rebuildAllContainers() {
            for (HighlightsLayerFilter filter : this.containers.keySet()) {
                WeakReference<CompoundHighlightsContainer> ref = this.containers.get(filter);
                CompoundHighlightsContainer container = ref == null ? null : (CompoundHighlightsContainer)ref.get();
                if (container == null) continue;
                this.rebuildContainer(filter, container);
            }
        }

        private synchronized void rebuildContainer(HighlightsLayerFilter filter, CompoundHighlightsContainer container) {
            if (this.factories != null) {
                List<? extends HighlightsLayer> sortedLayers;
                Document doc = this.pane.getDocument();
                Collection all = this.factories.allInstances();
                HashMap<String, HighlightsLayer> layers = new HashMap<String, HighlightsLayer>();
                HighlightsLayerFactory.Context context = HighlightingSpiPackageAccessor.get().createFactoryContext(doc, this.pane);
                for (HighlightsLayerFactory factory : all) {
                    HighlightsLayer[] factoryLayers = factory.createLayers(context);
                    if (factoryLayers == null) continue;
                    for (HighlightsLayer layer : factoryLayers) {
                        HighlightsLayerAccessor layerAccessor = HighlightingSpiPackageAccessor.get().getHighlightsLayerAccessor(layer);
                        String layerTypeId = layerAccessor.getLayerTypeId();
                        if (layers.containsKey(layerTypeId)) continue;
                        layers.put(layerTypeId, layer);
                    }
                }
                try {
                    sortedLayers = HighlightingSpiPackageAccessor.get().sort(layers.values());
                }
                catch (TopologicalSortException tse) {
                    List<? extends HighlightsLayer> sl;
                    ErrorManager.getDefault().notify((Throwable)tse);
                    sortedLayers = sl = tse.partialSort();
                }
                sortedLayers = this.paneFilter.filterLayers(Collections.unmodifiableList(sortedLayers));
                sortedLayers = filter.filterLayers(Collections.unmodifiableList(sortedLayers));
                ArrayList<HighlightsContainer> hcs = new ArrayList<HighlightsContainer>();
                for (HighlightsLayer highlightsLayer : sortedLayers) {
                    HighlightsLayerAccessor layerAccessor = HighlightingSpiPackageAccessor.get().getHighlightsLayerAccessor(highlightsLayer);
                    hcs.add(layerAccessor.getContainer());
                }
                if (LOG.isLoggable(Level.FINE)) {
                    Highlighting.logLayers(doc, this.lastKnownMimePaths, sortedLayers);
                }
                container.setLayers(doc, hcs.toArray(new HighlightsContainer[hcs.size()]));
            } else {
                container.setLayers(null, null);
            }
        }

        private static void logLayers(Document doc, MimePath[] mimePaths, List<? extends HighlightsLayer> layers) {
            StringBuilder sb = new StringBuilder();
            sb.append("HighlighsLayers {\n");
            sb.append(" * document : ");
            sb.append(doc.toString());
            sb.append("\n");
            sb.append(" * mime paths : \n");
            for (MimePath mimePath : mimePaths) {
                sb.append("    ");
                sb.append(mimePath.getPath());
                sb.append("\n");
            }
            sb.append(" * layers : \n");
            for (HighlightsLayer highlightsLayer : layers) {
                HighlightsLayerAccessor layerAccessor = HighlightingSpiPackageAccessor.get().getHighlightsLayerAccessor(highlightsLayer);
                sb.append("    ");
                sb.append(layerAccessor.getLayerTypeId());
                sb.append("\n");
            }
            sb.append("}\n");
            LOG.fine(sb.toString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class RegExpFilter
    implements HighlightsLayerFilter {
        private final List<Pattern> includes;
        private final List<Pattern> excludes;

        public RegExpFilter(Object includes, Object excludes) {
            this.includes = RegExpFilter.buildPatterns(includes);
            this.excludes = RegExpFilter.buildPatterns(excludes);
        }

        @Override
        public List<? extends HighlightsLayer> filterLayers(List<? extends HighlightsLayer> layers) {
            List<? extends HighlightsLayer> includedLayers = this.includes.isEmpty() ? layers : RegExpFilter.filter(layers, this.includes, true);
            List<? extends HighlightsLayer> filteredLayers = this.excludes.isEmpty() ? includedLayers : RegExpFilter.filter(includedLayers, this.excludes, false);
            return filteredLayers;
        }

        private static List<? extends HighlightsLayer> filter(List<? extends HighlightsLayer> layers, List<Pattern> patterns, boolean includeMatches) {
            ArrayList<HighlightsLayer> filtered = new ArrayList<HighlightsLayer>();
            for (HighlightsLayer highlightsLayer : layers) {
                HighlightsLayerAccessor layerAccessor = HighlightingSpiPackageAccessor.get().getHighlightsLayerAccessor(highlightsLayer);
                for (Pattern pattern : patterns) {
                    boolean matches = pattern.matcher(layerAccessor.getLayerTypeId()).matches();
                    if (matches && includeMatches) {
                        filtered.add(highlightsLayer);
                    }
                    if (matches || includeMatches) continue;
                    filtered.add(highlightsLayer);
                }
            }
            return filtered;
        }

        private static List<Pattern> buildPatterns(Object expressions) {
            ArrayList<Pattern> patterns = new ArrayList<Pattern>();
            if (expressions instanceof String) {
                try {
                    patterns.add(Pattern.compile((String)expressions));
                }
                catch (PatternSyntaxException e) {
                    LOG.log(Level.WARNING, "Ignoring invalid regexp for the HighlightsLayer filtering.", e);
                }
            } else if (expressions instanceof String[]) {
                for (String expression : (String[])expressions) {
                    try {
                        patterns.add(Pattern.compile(expression));
                    }
                    catch (PatternSyntaxException e) {
                        LOG.log(Level.WARNING, "Ignoring invalid regexp for the HighlightsLayer filtering.", e);
                    }
                }
            }
            return patterns;
        }
    }
}

