/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.lib2.highlighting;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;
import java.util.logging.Logger;
import javax.swing.text.AttributeSet;
import org.netbeans.api.editor.settings.AttributesUtilities;
import org.netbeans.spi.editor.highlighting.HighlightsChangeEvent;
import org.netbeans.spi.editor.highlighting.HighlightsChangeListener;
import org.netbeans.spi.editor.highlighting.HighlightsContainer;
import org.netbeans.spi.editor.highlighting.HighlightsSequence;
import org.netbeans.spi.editor.highlighting.support.AbstractHighlightsContainer;

public final class ProxyHighlightsContainer
extends AbstractHighlightsContainer {
    private static final Logger LOG = Logger.getLogger(ProxyHighlightsContainer.class.getName());
    private HighlightsContainer[] layers;
    private long version = 0L;
    private final String LOCK = new String("ProxyHighlightsContainer.LOCK");
    private final LayerListener listener = new LayerListener(this);

    public ProxyHighlightsContainer() {
        this(null);
    }

    public ProxyHighlightsContainer(HighlightsContainer[] layers) {
        this.setLayers(layers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HighlightsSequence getHighlights(int startOffset, int endOffset) {
        assert (0 <= startOffset) : "offsets must be greater than or equal to zero";
        assert (startOffset <= endOffset) : "startOffset must be less than or equal to endOffset; startOffset = " + startOffset + " endOffset = " + endOffset;
        String string = this.LOCK;
        synchronized (string) {
            if (this.layers == null || this.layers.length == 0 || startOffset == endOffset) {
                return HighlightsSequence.EMPTY;
            }
            HighlightsSequence[] seq = new HighlightsSequence[this.layers.length];
            for (int i = 0; i < this.layers.length; ++i) {
                seq[i] = this.layers[this.layers.length - i - 1].getHighlights(startOffset, endOffset);
            }
            return new ProxySeq(this.version, seq, startOffset, endOffset);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HighlightsContainer[] getLayers() {
        String string = this.LOCK;
        synchronized (string) {
            return this.layers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLayers(HighlightsContainer[] layers) {
        String string = this.LOCK;
        synchronized (string) {
            int i;
            if (this.layers != null) {
                for (i = 0; i < this.layers.length; ++i) {
                    this.layers[i].removeHighlightsChangeListener(this.listener);
                }
            }
            this.layers = layers;
            ++this.version;
            if (this.layers != null) {
                for (i = 0; i < this.layers.length; ++i) {
                    this.layers[i].addHighlightsChangeListener(this.listener);
                }
            }
        }
        this.fireHighlightsChange(0, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void layerChanged(HighlightsContainer layer, int changeStartOffset, int changeEndOffset) {
        String string = this.LOCK;
        synchronized (string) {
            ++this.version;
        }
        this.fireHighlightsChange(changeStartOffset, changeEndOffset);
    }

    private static final class LayerListener
    implements HighlightsChangeListener {
        private WeakReference<ProxyHighlightsContainer> ref;

        public LayerListener(ProxyHighlightsContainer container) {
            this.ref = new WeakReference<ProxyHighlightsContainer>(container);
        }

        public void highlightChanged(HighlightsChangeEvent event) {
            ProxyHighlightsContainer container = (ProxyHighlightsContainer)this.ref.get();
            if (container != null) {
                container.layerChanged((HighlightsContainer)event.getSource(), event.getStartOffset(), event.getEndOffset());
            }
        }
    }

    private final class ProxySeq
    implements HighlightsSequence {
        private Sequence2Marks[] marks;
        private int index1 = -1;
        private int index2 = -1;
        private AttributeSet compositeAttributes = null;
        private long version;

        public ProxySeq(long version, HighlightsSequence[] seq, int startOffset, int endOffset) {
            this.version = version;
            this.marks = new Sequence2Marks[seq.length];
            for (int i = 0; i < seq.length; ++i) {
                this.marks[i] = new Sequence2Marks(seq[i], startOffset, endOffset);
                this.marks[i].moveNext();
            }
            this.index2 = this.findLowest();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean moveNext() {
            String string = ProxyHighlightsContainer.this.LOCK;
            synchronized (string) {
                this.checkVersion();
                do {
                    this.index1 = this.index2;
                    if (this.index2 != -1) {
                        this.marks[this.index2].moveNext();
                        this.index2 = this.findLowest();
                    }
                    if (this.index1 == -1 || this.index2 == -1) break;
                    this.compositeAttributes = this.findAttributes();
                } while (this.compositeAttributes == null);
                return this.index1 != -1 && this.index2 != -1;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getStartOffset() {
            String string = ProxyHighlightsContainer.this.LOCK;
            synchronized (string) {
                this.checkVersion();
                if (this.index1 == -1 || this.index2 == -1) {
                    throw new NoSuchElementException();
                }
                return this.marks[this.index1].getPreviousMarkOffset();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getEndOffset() {
            String string = ProxyHighlightsContainer.this.LOCK;
            synchronized (string) {
                this.checkVersion();
                if (this.index1 == -1 || this.index2 == -1) {
                    throw new NoSuchElementException();
                }
                return this.marks[this.index2].getMarkOffset();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public AttributeSet getAttributes() {
            String string = ProxyHighlightsContainer.this.LOCK;
            synchronized (string) {
                this.checkVersion();
                if (this.index1 == -1 || this.index2 == -1) {
                    throw new NoSuchElementException();
                }
                return this.compositeAttributes;
            }
        }

        private int findLowest() {
            int lowest = Integer.MAX_VALUE;
            int idx = -1;
            for (int i = 0; i < this.marks.length; ++i) {
                int offset;
                if (this.marks[i].isFinished() || (offset = this.marks[i].getMarkOffset()) >= lowest) continue;
                lowest = offset;
                idx = i;
            }
            return idx;
        }

        private AttributeSet findAttributes() {
            ArrayList<AttributeSet> list = new ArrayList<AttributeSet>();
            for (int i = 0; i < this.marks.length; ++i) {
                if (this.marks[i].getPreviousMarkAttributes() == null) continue;
                list.add(this.marks[i].getPreviousMarkAttributes());
            }
            if (!list.isEmpty()) {
                return AttributesUtilities.createComposite((AttributeSet[])list.toArray(new AttributeSet[list.size()]));
            }
            return null;
        }

        private void checkVersion() {
            if (this.version != ProxyHighlightsContainer.this.version) {
                throw new ConcurrentModificationException();
            }
        }
    }

    static final class Sequence2Marks {
        private HighlightsSequence seq;
        private int startOffset;
        private int endOffset;
        private boolean hasNext = false;
        private boolean useStartOffset = true;
        private boolean finished = true;
        private int lastEndOffset = -1;
        private int previousMarkOffset = -1;
        private AttributeSet previousMarkAttributes = null;

        public Sequence2Marks(HighlightsSequence seq, int startOffset, int endOffset) {
            this.seq = seq;
            this.startOffset = startOffset;
            this.endOffset = endOffset;
        }

        public boolean isFinished() {
            return this.finished;
        }

        public boolean moveNext() {
            if (!this.useStartOffset || this.hasNext) {
                this.previousMarkOffset = this.getMarkOffset();
                this.previousMarkAttributes = this.getMarkAttributes();
            }
            if (this.useStartOffset) {
                while ((this.hasNext = this.seq.moveNext()) && this.seq.getEndOffset() <= this.startOffset) {
                }
                if (this.hasNext && this.seq.getStartOffset() > this.endOffset) {
                    this.hasNext = false;
                }
                if (this.hasNext) {
                    if (this.lastEndOffset != -1 && this.lastEndOffset < this.seq.getStartOffset()) {
                        this.useStartOffset = false;
                    } else {
                        this.lastEndOffset = this.seq.getEndOffset();
                    }
                } else if (this.lastEndOffset != -1) {
                    this.useStartOffset = false;
                }
            } else {
                if (this.hasNext) {
                    this.lastEndOffset = this.seq.getEndOffset();
                }
                this.useStartOffset = true;
            }
            this.finished = this.useStartOffset && !this.hasNext;
            return !this.finished;
        }

        public int getMarkOffset() {
            if (this.finished) {
                throw new NoSuchElementException();
            }
            return this.useStartOffset ? Math.max(this.startOffset, this.seq.getStartOffset()) : Math.min(this.endOffset, this.lastEndOffset);
        }

        public AttributeSet getMarkAttributes() {
            if (this.finished) {
                throw new NoSuchElementException();
            }
            return this.useStartOffset ? this.seq.getAttributes() : null;
        }

        public int getPreviousMarkOffset() {
            return this.previousMarkOffset;
        }

        public AttributeSet getPreviousMarkAttributes() {
            return this.previousMarkAttributes;
        }
    }
}

