/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.lib2.highlighting;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.SimpleAttributeSet;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.modules.editor.lib2.search.EditorFindSupport;
import org.netbeans.spi.editor.highlighting.HighlightsChangeEvent;
import org.netbeans.spi.editor.highlighting.HighlightsChangeListener;
import org.netbeans.spi.editor.highlighting.HighlightsSequence;
import org.netbeans.spi.editor.highlighting.support.AbstractHighlightsContainer;
import org.netbeans.spi.editor.highlighting.support.OffsetsBag;
import org.openide.util.WeakListeners;

public class TextSearchHighlighting
extends AbstractHighlightsContainer
implements PropertyChangeListener,
HighlightsChangeListener {
    private static final Logger LOG = Logger.getLogger(TextSearchHighlighting.class.getName());
    public static final String LAYER_TYPE_ID = "org.netbeans.modules.editor.lib2.highlighting.TextSearchHighlighting";
    private final MimePath mimePath;
    private final JTextComponent component;
    private final Document document;
    private final OffsetsBag bag;

    public TextSearchHighlighting(JTextComponent component) {
        EditorKit kit = component.getUI().getEditorKit(component);
        String mimeType = kit == null ? null : kit.getContentType();
        this.mimePath = mimeType == null ? MimePath.EMPTY : MimePath.parse((String)mimeType);
        this.component = component;
        this.document = component.getDocument();
        this.bag = new OffsetsBag(this.document);
        this.bag.addHighlightsChangeListener(this);
        EditorFindSupport.getInstance().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)EditorFindSupport.getInstance()));
        this.fillInTheBag();
    }

    public HighlightsSequence getHighlights(int startOffset, int endOffset) {
        return this.bag.getHighlights(startOffset, endOffset);
    }

    public void highlightChanged(HighlightsChangeEvent event) {
        this.fireHighlightsChange(event.getStartOffset(), event.getEndOffset());
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName() == null || "find-what".equals(evt.getPropertyName()) || "find-highlight-search".equals(evt.getPropertyName())) {
            this.fillInTheBag();
        }
    }

    private void fillInTheBag() {
        this.document.render(new Runnable(){

            public void run() {
                OffsetsBag newBag = new OffsetsBag(TextSearchHighlighting.this.document);
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("TSH: filling the bag; enabled = " + TextSearchHighlighting.this.isEnabled());
                }
                if (TextSearchHighlighting.this.isEnabled()) {
                    try {
                        int[] blocks = EditorFindSupport.getInstance().getBlocks(new int[]{-1, -1}, TextSearchHighlighting.this.document, 0, TextSearchHighlighting.this.document.getLength());
                        assert (blocks.length % 2 == 0) : "Wrong number of block offsets";
                        AttributeSet attribs = TextSearchHighlighting.this.getAttribs();
                        for (int i = 0; i < blocks.length / 2; ++i) {
                            newBag.addHighlight(blocks[2 * i], blocks[2 * i + 1], attribs);
                        }
                    }
                    catch (BadLocationException e) {
                        LOG.log(Level.WARNING, e.getMessage(), e);
                    }
                }
                TextSearchHighlighting.this.bag.setHighlights(newBag);
            }
        });
    }

    private boolean isEnabled() {
        Object prop = EditorFindSupport.getInstance().getFindProperty("find-highlight-search");
        return prop instanceof Boolean && (Boolean)prop != false;
    }

    private AttributeSet getAttribs() {
        FontColorSettings fcs = (FontColorSettings)MimeLookup.getLookup((MimePath)this.mimePath).lookup(FontColorSettings.class);
        AttributeSet attribs = fcs.getFontColors("highlight-search");
        return attribs == null ? SimpleAttributeSet.EMPTY : attribs;
    }
}

