/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.lib2.search;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.netbeans.modules.editor.lib2.ComponentUtils;
import org.netbeans.modules.editor.lib2.DialogSupport;
import org.netbeans.modules.editor.lib2.DocUtils;
import org.netbeans.modules.editor.lib2.DocumentsRegistry;
import org.netbeans.modules.editor.lib2.KeyEventBlocker;
import org.netbeans.modules.editor.lib2.highlighting.BlockHighlighting;
import org.netbeans.modules.editor.lib2.search.EditorFindDialogPanel;
import org.netbeans.modules.editor.lib2.search.EditorFindSupport;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditorFindDialogSupport
extends WindowAdapter
implements ActionListener {
    private static final Logger LOG = Logger.getLogger(EditorFindDialogSupport.class.getName());
    private static Object dialogLock = new Object();
    private static boolean isReplaceDialog = false;
    private static JButton[] findButtons;
    private static JButton[] findDialogButtons;
    private static JButton[] replaceDialogButtons;
    private static FindPanel findPanel;
    private static Dialog findDialog;
    private int caretPosition;
    private static EditorFindDialogSupport singleton;
    private static PropertyChangeListener historyChangeListener;
    private boolean findPerformed = false;
    private static int xPos;
    private static int yPos;
    private static boolean dialogInvokedViaKeystroke;

    public static EditorFindDialogSupport getInstance() {
        if (singleton == null) {
            singleton = new EditorFindDialogSupport();
        }
        return singleton;
    }

    private void createFindButtons() {
        if (findButtons == null) {
            ResourceBundle bundle = NbBundle.getBundle(EditorFindDialogSupport.class);
            findButtons = new JButton[]{new JButton(bundle.getString("find-button-find")), new JButton(bundle.getString("find-button-replace")), new JButton(bundle.getString("find-button-replace-all")), new JButton(bundle.getString("find-button-cancel"))};
            findButtons[0].setMnemonic(bundle.getString("find-button-find-mnemonic").charAt(0));
            findButtons[1].setMnemonic(bundle.getString("find-button-replace-mnemonic").charAt(0));
            findButtons[2].setMnemonic(bundle.getString("find-button-replace-all-mnemonic").charAt(0));
            findButtons[0].getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_find-button-find"));
            findButtons[1].getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_find-button-replace"));
            findButtons[2].getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_find-button-replace-all"));
            findButtons[3].getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_find-button-cancel"));
            findDialogButtons = new JButton[2];
            EditorFindDialogSupport.findDialogButtons[0] = findButtons[0];
            EditorFindDialogSupport.findDialogButtons[1] = findButtons[3];
            replaceDialogButtons = new JButton[4];
            EditorFindDialogSupport.replaceDialogButtons[0] = findButtons[0];
            EditorFindDialogSupport.replaceDialogButtons[1] = findButtons[1];
            EditorFindDialogSupport.replaceDialogButtons[2] = findButtons[2];
            EditorFindDialogSupport.replaceDialogButtons[3] = findButtons[3];
        }
    }

    private void createFindPanel() {
        if (findPanel == null) {
            findPanel = new FindPanel();
        }
    }

    private Dialog createFindDialog(JPanel findPanel, JButton[] buttons, ActionListener l) {
        Dialog d = DialogSupport.getInstance().createDialog(isReplaceDialog ? NbBundle.getBundle(EditorFindDialogSupport.class).getString("replace-title") : NbBundle.getBundle(EditorFindDialogSupport.class).getString("find-title"), findPanel, false, buttons, true, 0, isReplaceDialog ? 3 : 1, l);
        return d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showFindDialogImpl(boolean isReplace, KeyEventBlocker blocker) {
        dialogInvokedViaKeystroke = true;
        Object object = dialogLock;
        synchronized (object) {
            if (findDialog != null && isReplaceDialog != isReplace) {
                xPos = EditorFindDialogSupport.findDialog.getLocation().x;
                yPos = EditorFindDialogSupport.findDialog.getLocation().y;
                findDialog.dispose();
                findDialog = null;
            }
            if (findDialog == null) {
                isReplaceDialog = isReplace;
                this.createFindButtons();
                this.createFindPanel();
                findPanel.changeVisibility(isReplace);
                findDialog = this.createFindDialog(findPanel, isReplace ? replaceDialogButtons : findDialogButtons, this);
                findDialog.addWindowListener(this);
                ((JDialog)findDialog).getRootPane().setFocusable(false);
                if (xPos > Integer.MIN_VALUE) {
                    findDialog.setLocation(xPos, yPos);
                }
            }
        }
        findDialog.pack();
        findPanel.init(isReplace, blocker);
        findDialog.setVisible(true);
        findPanel.showNotify();
        this.updateCaretPosition();
    }

    private void updateCaretPosition() {
        JTextComponent c = DocumentsRegistry.getMostActiveComponent();
        if (c != null) {
            this.caretPosition = c.getCaret().getDot();
        }
    }

    @Override
    public void windowActivated(WindowEvent evt) {
        this.findPerformed = false;
        this.createFindPanel();
        EditorFindDialogSupport.findPanel.initBlockSearch();
        this.updateCaretPosition();
    }

    @Override
    public void windowDeactivated(WindowEvent evt) {
        Map<String, Object> findProps = findPanel.getFindProps();
        JTextComponent c = DocumentsRegistry.getMostActiveComponent();
        if (c != null) {
            boolean blockSearch = this.getBooleanProp("find-block-search", findProps);
            if (blockSearch && !this.findPerformed) {
                int bsEnd;
                Integer bsStartInt = (Integer)findProps.get("find-block-search-start");
                int bsStart = bsStartInt == null ? -1 : bsStartInt;
                Position pos = (Position)findProps.get("find-block-search-end");
                int n = bsEnd = pos != null ? pos.getOffset() : -1;
                if (bsStart >= 0 && bsEnd > 0) {
                    c.select(bsStart, bsEnd);
                }
            } else {
                int[] block;
                BlockHighlighting layer = EditorFindSupport.getInstance().findLayer(c, "org.netbeans.modules.editor.lib2.highlighting.BlockHighlighting/INC_SEARCH");
                if (layer != null && (block = layer.gethighlightedBlock()) != null) {
                    c.select(block[0], block[1]);
                }
            }
        }
        EditorFindSupport.getInstance().incSearchReset();
        findPanel.resetBlockSearch();
        KeyEventBlocker blocker = EditorFindDialogSupport.findPanel.getBlocker();
        if (blocker != null) {
            blocker.stopBlocking(false);
        }
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.hideDialog();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void windowClosed(WindowEvent e) {
        Object object = dialogLock;
        synchronized (object) {
            if (findDialog != null) {
                xPos = EditorFindDialogSupport.findDialog.getLocation().x;
                yPos = EditorFindDialogSupport.findDialog.getLocation().y;
            }
        }
        Map<String, Object> findProps = findPanel.getFindProps();
        EditorFindSupport.getInstance().incSearchReset();
        findPanel.resetBlockSearch();
        EditorFindSupport.getInstance().setBlockSearchHighlight(0, 0);
        findProps.put("find-block-search", Boolean.FALSE);
        findProps.put("find-block-search-start", new Integer(0));
        findProps.put("find-block-search-end", null);
        EditorFindSupport.getInstance().putFindProperties(findProps);
        KeyEventBlocker blocker = EditorFindDialogSupport.findPanel.getBlocker();
        if (blocker != null) {
            blocker.stopBlocking(false);
        }
        ComponentUtils.returnFocus();
    }

    public void showFindDialog(KeyEventBlocker blocker) {
        this.showFindDialogImpl(false, blocker);
    }

    public void showReplaceDialog(KeyEventBlocker blocker) {
        this.showFindDialogImpl(true, blocker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hideDialog() {
        Object object = dialogLock;
        synchronized (object) {
            if (findDialog != null) {
                xPos = EditorFindDialogSupport.findDialog.getLocation().x;
                yPos = EditorFindDialogSupport.findDialog.getLocation().y;
                findDialog.dispose();
            }
            findDialog = null;
        }
    }

    private Vector<String> getHistoryVector() {
        List<EditorFindSupport.SPW> histList = EditorFindSupport.getInstance().getHistory();
        if (histList == null) {
            histList = new ArrayList<EditorFindSupport.SPW>();
        }
        boolean isRegExpChecked = (Boolean)findPanel.getFindProps().get("find-reg-exp");
        Vector<String> vec = new Vector<String>();
        for (int i = 0; i < histList.size(); ++i) {
            EditorFindSupport.SPW spw = histList.get(i);
            String searchExpression = spw.getSearchExpression();
            if (isRegExpChecked != spw.isRegExp() || vec.contains(searchExpression)) continue;
            vec.add(searchExpression);
        }
        return vec;
    }

    private boolean getBooleanProp(String propName, Map map) {
        Boolean b = (Boolean)map.get(propName);
        return b != null ? b : false;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (findButtons == null) {
            return;
        }
        Object src = evt.getSource();
        EditorFindSupport fSup = EditorFindSupport.getInstance();
        Map<String, Object> findPanelMap = findPanel.getFindProps();
        EditorFindSupport.SPW spw = new EditorFindSupport.SPW((String)findPanelMap.get("find-what"), this.getBooleanProp("find-whole-words", findPanelMap), this.getBooleanProp("find-match-case", findPanelMap), this.getBooleanProp("find-reg-exp", findPanelMap));
        if (src == findButtons[0]) {
            fSup.addToHistory(spw);
            fSup.putFindProperties(findPanelMap);
            fSup.find(null, false);
            this.updateCaretPosition();
            this.findPerformed = true;
        } else if (src == findButtons[1]) {
            block11: {
                fSup.addToHistory(spw);
                findPanel.updateReplaceHistory();
                fSup.putFindProperties(findPanelMap);
                try {
                    if (fSup.replace(null, false)) {
                        fSup.find(null, false);
                    }
                }
                catch (BadLocationException e) {
                    if (ComponentUtils.isGuardedException(e)) break block11;
                    LOG.log(Level.WARNING, e.getMessage(), e);
                }
            }
            this.updateCaretPosition();
            this.findPerformed = true;
        } else if (src == findButtons[2]) {
            fSup.addToHistory(spw);
            findPanel.updateReplaceHistory();
            fSup.putFindProperties(findPanelMap);
            fSup.replaceAll(null);
            this.findPerformed = true;
        } else if (src == findButtons[3]) {
            this.hideDialog();
        }
    }

    private int getBlockEndOffset() {
        Position pos = (Position)EditorFindSupport.getInstance().getFindProperties().get("find-block-search-end");
        return pos != null ? pos.getOffset() : -1;
    }

    static {
        findDialog = null;
        singleton = null;
        xPos = Integer.MIN_VALUE;
        yPos = Integer.MIN_VALUE;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FindPanel
    extends EditorFindDialogPanel
    implements ItemListener,
    KeyListener,
    ActionListener,
    FocusListener {
        private Map<String, Object> findProps = Collections.synchronizedMap(new HashMap(20));
        private Map<Object, String> objToProps = Collections.synchronizedMap(new HashMap(20));
        private DefaultComboBoxModel findHistory = new DefaultComboBoxModel();
        private DefaultComboBoxModel replaceHistory = new DefaultComboBoxModel();
        private KeyEventBlocker blocker;
        private int blockSearchStartPos = 0;
        private int blockSearchEndPos = 0;

        FindPanel() {
            this.objToProps.put(this.findWhat, "find-what");
            this.objToProps.put(this.replaceWith, "find-replace-with");
            this.objToProps.put(this.highlightSearch, "find-highlight-search");
            this.objToProps.put(this.incSearch, "find-inc-search");
            this.objToProps.put(this.matchCase, "find-match-case");
            this.objToProps.put(this.wholeWords, "find-whole-words");
            this.objToProps.put(this.regExp, "find-reg-exp");
            this.objToProps.put(this.bwdSearch, "find-backward-search");
            this.objToProps.put(this.wrapSearch, "find-wrap-search");
            this.objToProps.put(this.blockSearch, "find-block-search");
            this.findProps.putAll(EditorFindSupport.getInstance().getFindProperties());
            this.revertMap();
            this.findWhat.setModel(this.findHistory);
            this.findWhat.getEditor().setItem(this.getProperty(this.findWhat));
            this.replaceWith.setModel(this.replaceHistory);
            this.replaceWith.getEditor().setItem(this.getProperty(this.replaceWith));
            this.highlightSearch.setSelected(this.getBooleanProperty(this.highlightSearch));
            this.incSearch.setSelected(this.getBooleanProperty(this.incSearch));
            this.matchCase.setSelected(this.getBooleanProperty(this.matchCase));
            this.wholeWords.setSelected(this.getBooleanProperty(this.wholeWords));
            this.regExp.setSelected(this.getBooleanProperty(this.regExp));
            this.bwdSearch.setSelected(this.getBooleanProperty(this.bwdSearch));
            this.wrapSearch.setSelected(this.getBooleanProperty(this.wrapSearch));
            this.findWhat.getEditor().getEditorComponent().addKeyListener(this);
            this.findWhat.addActionListener(this);
            this.replaceWith.getEditor().getEditorComponent().addKeyListener(this);
            this.replaceWith.addActionListener(this);
            this.highlightSearch.addItemListener(this);
            this.incSearch.addItemListener(this);
            this.matchCase.addItemListener(this);
            this.wholeWords.addItemListener(this);
            this.regExp.addItemListener(this);
            this.bwdSearch.addItemListener(this);
            this.wrapSearch.addItemListener(this);
            this.blockSearch.addItemListener(this);
            historyChangeListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt == null || !"find-history-changed-prop".equals(evt.getPropertyName())) {
                        return;
                    }
                    FindPanel.this.updateFindHistory();
                }
            };
            EditorFindSupport.getInstance().addPropertyChangeListener(historyChangeListener);
        }

        protected Map<String, Object> getFindProps() {
            return this.findProps;
        }

        private KeyEventBlocker getBlocker() {
            return this.blocker;
        }

        private void putProperty(Object component, Object value) {
            String prop = this.objToProps.get(component);
            if (prop != null) {
                this.findProps.put(prop, value);
            }
        }

        private Object getProperty(Object component) {
            String prop = this.objToProps.get(component);
            return prop != null ? this.findProps.get(prop) : null;
        }

        private boolean getBooleanProperty(Object component) {
            Object prop = this.getProperty(component);
            return prop != null ? (Boolean)prop : false;
        }

        protected void changeVisibility(boolean v) {
            this.replaceWith.setVisible(v);
            this.replaceWithLabel.setVisible(v);
        }

        public void resetBlockSearch() {
            this.blockSearch.setSelected(false);
            this.blockSearch.setEnabled(false);
            this.findProps.put("find-block-search", Boolean.FALSE);
            this.findProps.put("find-block-search-start", new Integer(0));
            this.findProps.put("find-block-search-end", null);
            this.blockSearchStartPos = 0;
            this.blockSearchEndPos = 0;
            EditorFindSupport.getInstance().setBlockSearchHighlight(0, 0);
            EditorFindSupport.getInstance().putFindProperties(this.findProps);
        }

        private void initBlockSearch() {
            JTextComponent c = DocumentsRegistry.getMostActiveComponent();
            String selText = null;
            int startSelection = 0;
            int endSelection = 0;
            boolean blockSearchVisible = false;
            if (c != null) {
                startSelection = c.getSelectionStart();
                endSelection = c.getSelectionEnd();
                Document doc = c.getDocument();
                try {
                    int startLine = DocUtils.getLineOffset(doc, startSelection);
                    int endLine = DocUtils.getLineOffset(doc, endSelection);
                    if (endLine > startLine) {
                        blockSearchVisible = true;
                    }
                }
                catch (BadLocationException ble) {
                    // empty catch block
                }
                EditorFindDialogSupport.this.caretPosition = this.bwdSearch.isSelected() ? c.getSelectionEnd() : c.getSelectionStart();
                if (!blockSearchVisible && dialogInvokedViaKeystroke) {
                    dialogInvokedViaKeystroke = false;
                    selText = c.getSelectedText();
                    if (selText != null) {
                        int n = selText.indexOf(10);
                        if (n >= 0) {
                            selText = selText.substring(0, n);
                        }
                        this.findWhat.getEditor().setItem(selText);
                        this.changeFindWhat(true);
                    }
                }
                this.blockSearchStartPos = blockSearchVisible ? startSelection : 0;
                this.blockSearchEndPos = blockSearchVisible ? endSelection : 0;
                try {
                    this.blockSearch.setEnabled(blockSearchVisible);
                    this.blockSearch.setSelected(blockSearchVisible);
                    this.findProps.put("find-block-search", blockSearchVisible);
                    this.findProps.put("find-block-search-start", new Integer(this.blockSearchStartPos));
                    int be = EditorFindDialogSupport.this.getBlockEndOffset();
                    if (be < 0) {
                        this.findProps.put("find-block-search-end", doc.createPosition(this.blockSearchEndPos));
                    } else {
                        this.blockSearchEndPos = be;
                    }
                    EditorFindSupport.getInstance().setBlockSearchHighlight(this.blockSearchStartPos, this.blockSearchEndPos);
                }
                catch (BadLocationException ble) {
                    this.blockSearch.setSelected(false);
                    this.findProps.put("find-block-search", Boolean.FALSE);
                    this.findProps.put("find-block-search-start", null);
                }
            }
        }

        protected void init(boolean isReplace, KeyEventBlocker blocker) {
            this.blocker = blocker;
            this.findHistory.setSelectedItem(null);
            this.replaceHistory.setSelectedItem(null);
            this.findWhat.getEditor().getEditorComponent().addFocusListener(this);
            if (isReplace) {
                this.replaceWith.getEditor().getEditorComponent().addFocusListener(this);
            }
            this.findProps.putAll(EditorFindSupport.getInstance().getFindProperties());
            this.revertMap();
            this.highlightSearch.setSelected(this.getBooleanProperty(this.highlightSearch));
            this.incSearch.setSelected(this.getBooleanProperty(this.incSearch));
            this.matchCase.setSelected(this.getBooleanProperty(this.matchCase));
            this.wholeWords.setSelected(this.getBooleanProperty(this.wholeWords));
            boolean regExpValue = this.getBooleanProperty(this.regExp);
            this.regExp.setSelected(regExpValue);
            this.wholeWords.setEnabled(!regExpValue);
            this.incSearch.setEnabled(!regExpValue);
            this.bwdSearch.setSelected(this.getBooleanProperty(this.bwdSearch));
            this.wrapSearch.setSelected(this.getBooleanProperty(this.wrapSearch));
            this.findHistory = new DefaultComboBoxModel(EditorFindDialogSupport.this.getHistoryVector());
            this.findWhat.setModel(this.findHistory);
        }

        protected void showNotify() {
            boolean focused = this.findWhat.getEditor().getEditorComponent().requestFocusInWindow();
            if (!focused) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        FindPanel.this.findWhat.getEditor().getEditorComponent().requestFocusInWindow();
                    }
                });
            }
        }

        private void updateHistory(JComboBox c, DefaultComboBoxModel history) {
            Object item = c.getEditor().getItem();
            if (item != null && !item.equals("")) {
                history.removeElement(item);
                history.insertElementAt(item, 0);
                history.setSelectedItem(null);
            }
            c.getEditor().setItem(item);
        }

        protected void updateFindHistory() {
            Object obj = this.findWhat.getEditor().getItem();
            this.findHistory = new DefaultComboBoxModel(EditorFindDialogSupport.this.getHistoryVector());
            this.findWhat.setModel(this.findHistory);
            if (obj != null) {
                this.findWhat.getEditor().setItem(obj);
            }
        }

        protected void updateReplaceHistory() {
            this.updateHistory(this.replaceWith, this.replaceHistory);
        }

        private void revertMap() {
            Object prop = this.findProps.get("revert-map");
            if (!(prop instanceof Map)) {
                return;
            }
            Map revertMap = (Map)prop;
            for (String key : revertMap.keySet()) {
                boolean value;
                Object obj = this.findProps.get(key);
                boolean bl = value = obj != null ? (Boolean)obj : false;
                if (value != (Boolean)revertMap.get(key)) {
                    // empty if block
                }
                this.findProps.put(key, value ? Boolean.FALSE : Boolean.TRUE);
            }
            this.findProps.put("revert-map", null);
        }

        private void changeFindWhat(boolean performIncSearch) {
            Object old = this.getProperty(this.findWhat);
            Object cur = this.findWhat.getEditor().getItem();
            if (old == null && cur != null && !cur.equals("") || old != null && !old.equals(cur)) {
                this.putProperty(this.findWhat, cur);
                if (performIncSearch) {
                    EditorFindDialogSupport.this.findPerformed = EditorFindSupport.getInstance().incSearch(this.getFindProps(), EditorFindDialogSupport.this.caretPosition);
                }
            }
        }

        private void changeReplaceWith() {
            Object old = this.getProperty(this.replaceWith);
            Object cur = this.replaceWith.getEditor().getItem();
            if (old == null && cur != null && !cur.equals("") || old != null && !old.equals(cur)) {
                this.putProperty(this.replaceWith, cur);
            }
        }

        private void postChangeCombos(final boolean performIncSearch) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    FindPanel.this.changeFindWhat(performIncSearch);
                    FindPanel.this.changeReplaceWith();
                }
            });
        }

        @Override
        public void keyPressed(KeyEvent evt) {
            if (evt.getKeyChar() == '\n') {
                evt.consume();
            }
        }

        @Override
        public void keyReleased(KeyEvent evt) {
            if (evt.getKeyChar() == '\n') {
                evt.consume();
            } else if (evt.getKeyCode() == 155) {
                this.postChangeCombos(true);
            }
        }

        @Override
        public void keyTyped(KeyEvent evt) {
            if (evt.getKeyChar() == '\n') {
                findButtons[0].doClick(20);
                evt.consume();
                ((JComboBox)((JTextField)evt.getSource()).getParent()).hidePopup();
            } else {
                this.postChangeCombos(true);
            }
        }

        @Override
        public void itemStateChanged(ItemEvent evt) {
            JTextComponent c;
            boolean value;
            Boolean val;
            Boolean bl = val = evt.getStateChange() == 1 ? Boolean.TRUE : Boolean.FALSE;
            if (evt.getItem() == this.bwdSearch && this.blockSearch.isEnabled() && this.blockSearch.isSelected()) {
                value = val;
                c = DocumentsRegistry.getMostActiveComponent();
                if (c != null) {
                    c.getCaret().setDot(value ? this.blockSearchEndPos : this.blockSearchStartPos);
                    EditorFindDialogSupport.this.updateCaretPosition();
                }
            }
            if (evt.getItem() == this.regExp) {
                value = val == false;
                this.incSearch.setEnabled(value);
                this.wholeWords.setEnabled(value);
            }
            if (evt.getItem() == this.blockSearch) {
                value = val;
                if (value) {
                    if (this.blockSearchStartPos <= 0 && this.blockSearchEndPos <= 0) {
                        this.initBlockSearch();
                    } else {
                        c = DocumentsRegistry.getMostActiveComponent();
                        if (c != null) {
                            c.getCaret().setDot(this.bwdSearch.isSelected() ? this.blockSearchEndPos : this.blockSearchStartPos);
                            EditorFindDialogSupport.this.updateCaretPosition();
                        }
                    }
                    EditorFindSupport.getInstance().setBlockSearchHighlight(this.blockSearchStartPos, this.blockSearchEndPos);
                } else {
                    EditorFindSupport.getInstance().putFindProperty("find-block-search", Boolean.FALSE);
                    EditorFindSupport.getInstance().setBlockSearchHighlight(0, 0);
                }
            }
            this.putProperty(evt.getSource(), val);
            if (evt.getItem() == this.regExp) {
                this.updateFindHistory();
            }
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            this.postChangeCombos(false);
        }

        @Override
        public void focusGained(FocusEvent e) {
            if (e.getSource() instanceof JTextField) {
                ((JTextField)e.getSource()).selectAll();
                if (this.blocker != null) {
                    this.blocker.stopBlocking();
                }
            }
            ((JComponent)e.getSource()).removeFocusListener(this);
        }

        @Override
        public void focusLost(FocusEvent e) {
        }
    }
}

