/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.editor.highlighting;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Logger;
import org.netbeans.spi.editor.highlighting.HighlightsLayer;
import org.openide.util.TopologicalSortException;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ZOrder {
    private static final Logger LOG = Logger.getLogger(ZOrder.class.getName());
    private static final Collection<String> EMPTY = new HashSet<String>();
    private static final String TOP_RACK_MARKER = "org-netbeans-spi-editor-highlighting-ZOrder-TOP-RACK";
    private static final String SHOW_OFF_RACK_MARKER = "org-netbeans-spi-editor-highlighting-ZOrder-SHOW-OFF-RACK";
    private static final String DEFAULT_RACK_MARKER = "org-netbeans-spi-editor-highlighting-ZOrder-DEFAULT-RACK";
    private static final String CARET_RACK_MARKER = "org-netbeans-spi-editor-highlighting-ZOrder-CARET-RACK";
    private static final String SYNTAX_RACK_MARKER = "org-netbeans-spi-editor-highlighting-ZOrder-SYNTAX-RACK";
    public static final ZOrder TOP_RACK = ZOrder.above("org-netbeans-spi-editor-highlighting-ZOrder-TOP-RACK");
    public static final ZOrder SHOW_OFF_RACK = new ZOrder(Collections.singleton("org-netbeans-spi-editor-highlighting-ZOrder-TOP-RACK"), Collections.singleton("org-netbeans-spi-editor-highlighting-ZOrder-SHOW-OFF-RACK"));
    public static final ZOrder DEFAULT_RACK = new ZOrder(Collections.singleton("org-netbeans-spi-editor-highlighting-ZOrder-SHOW-OFF-RACK"), Collections.singleton("org-netbeans-spi-editor-highlighting-ZOrder-DEFAULT-RACK"));
    public static final ZOrder CARET_RACK = new ZOrder(Collections.singleton("org-netbeans-spi-editor-highlighting-ZOrder-DEFAULT-RACK"), Collections.singleton("org-netbeans-spi-editor-highlighting-ZOrder-CARET-RACK"));
    public static final ZOrder SYNTAX_RACK = new ZOrder(Collections.singleton("org-netbeans-spi-editor-highlighting-ZOrder-CARET-RACK"), Collections.singleton("org-netbeans-spi-editor-highlighting-ZOrder-SYNTAX-RACK"));
    public static final ZOrder BOTTOM_RACK = ZOrder.below("org-netbeans-spi-editor-highlighting-ZOrder-SYNTAX-RACK");
    final Collection<String> layersAbove;
    final Collection<String> layersBelow;

    public static ZOrder above(String ... layerIds) {
        return new ZOrder(null, Arrays.asList(layerIds));
    }

    public static ZOrder below(String ... layerIds) {
        return new ZOrder(Arrays.asList(layerIds), null);
    }

    static HighlightsLayer[] sort(HighlightsLayer[] layers) throws TopologicalSortException {
        List<? extends HighlightsLayer> list = ZOrder.sort(Arrays.asList(layers));
        return list.toArray(new HighlightsLayer[list.size()]);
    }

    static List<? extends HighlightsLayer> sort(Collection<? extends HighlightsLayer> layers) throws TopologicalSortException {
        HashMap<String, HighlightsLayer> id2layer = new HashMap<String, HighlightsLayer>();
        HashSet<String> vertices = new HashSet<String>();
        HashMap edges = new HashMap();
        vertices.add(TOP_RACK_MARKER);
        vertices.add(SHOW_OFF_RACK_MARKER);
        vertices.add(DEFAULT_RACK_MARKER);
        vertices.add(CARET_RACK_MARKER);
        vertices.add(SYNTAX_RACK_MARKER);
        edges.put(SYNTAX_RACK_MARKER, new ArrayList<String>(Collections.singleton(CARET_RACK_MARKER)));
        edges.put(CARET_RACK_MARKER, new ArrayList<String>(Collections.singleton(DEFAULT_RACK_MARKER)));
        edges.put(DEFAULT_RACK_MARKER, new ArrayList<String>(Collections.singleton(SHOW_OFF_RACK_MARKER)));
        edges.put(SHOW_OFF_RACK_MARKER, new ArrayList<String>(Collections.singleton(TOP_RACK_MARKER)));
        for (HighlightsLayer highlightsLayer : layers) {
            id2layer.put(highlightsLayer.getLayerTypeId(), highlightsLayer);
            for (String belowLayerId : highlightsLayer.getZOrder().layersBelow) {
                vertices.add(belowLayerId);
                ArrayList<String> verticeEdges = (ArrayList<String>)edges.get(belowLayerId);
                if (verticeEdges == null) {
                    verticeEdges = new ArrayList<String>();
                    edges.put(belowLayerId, verticeEdges);
                }
                verticeEdges.add(highlightsLayer.getLayerTypeId());
                LOG.finest(belowLayerId + " < " + highlightsLayer.getLayerTypeId());
            }
            vertices.add(highlightsLayer.getLayerTypeId());
            ArrayList<String> verticeEdges = (ArrayList<String>)edges.get(highlightsLayer.getLayerTypeId());
            if (verticeEdges == null) {
                verticeEdges = new ArrayList<String>();
                edges.put(highlightsLayer.getLayerTypeId(), verticeEdges);
            }
            for (String aboveLayerId : highlightsLayer.getZOrder().layersAbove) {
                verticeEdges.add(aboveLayerId);
                LOG.finest(highlightsLayer.getLayerTypeId() + " < " + aboveLayerId);
            }
        }
        List sortedLayerIds = Utilities.topologicalSort(vertices, edges);
        ArrayList<HighlightsLayer> arrayList = new ArrayList<HighlightsLayer>();
        LOG.finest("Sorted layer Ids: ");
        for (String layerId : sortedLayerIds) {
            LOG.finest("    " + layerId);
            HighlightsLayer layer = (HighlightsLayer)id2layer.get(layerId);
            if (layer == null) continue;
            arrayList.add(layer);
        }
        LOG.finest("End of Sorted layer Ids: -----------------------");
        return arrayList;
    }

    private ZOrder(Collection<String> aboveLayers, Collection<String> belowLayers) {
        this.layersAbove = aboveLayers == null ? EMPTY : aboveLayers;
        this.layersBelow = belowLayers == null ? EMPTY : belowLayers;
    }

    public ZOrder aboveLayers(String ... layerIds) {
        HashSet<String> newLayersAbove = new HashSet<String>(this.layersAbove);
        HashSet<String> newLayersBelow = new HashSet<String>(this.layersBelow.size() + layerIds.length);
        newLayersBelow.addAll(this.layersBelow);
        newLayersBelow.addAll(Arrays.asList(layerIds));
        return new ZOrder(newLayersAbove, newLayersBelow);
    }

    public ZOrder belowLayers(String ... layerIds) {
        HashSet<String> newLayersBelow = new HashSet<String>(this.layersBelow);
        HashSet<String> newLayersAbove = new HashSet<String>(this.layersAbove.size() + layerIds.length);
        newLayersAbove.addAll(this.layersAbove);
        newLayersAbove.addAll(Arrays.asList(layerIds));
        return new ZOrder(newLayersAbove, newLayersBelow);
    }
}

