/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.projectint;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FileObjectIterator
implements Iterator<FileObject> {
    private ArrayList<FileObject> roots = new ArrayList(50);
    private Iterator<FileObject> rootsIterator;
    private Iterator<FileObject> editedFilesIterator;
    private Enumeration<? extends FileObject> rootChildrenEnum;

    void addRoot(FileObject folder) {
        assert (folder.isFolder());
        this.roots.add(folder);
    }

    @Override
    public boolean hasNext() {
        if (null == this.rootsIterator) {
            this.collectEditedFiles();
            this.rootsIterator = this.roots.iterator();
            return this.rootsIterator.hasNext();
        }
        return null != this.rootChildrenEnum && this.rootChildrenEnum.hasMoreElements() || this.rootsIterator.hasNext() || this.editedFilesIterator.hasNext();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public FileObject next() {
        if (this.editedFilesIterator.hasNext()) {
            return this.editedFilesIterator.next();
        }
        FileObject result = null;
        if (null != this.rootChildrenEnum) {
            if (this.rootChildrenEnum.hasMoreElements()) return this.rootChildrenEnum.nextElement();
        }
        if (!this.rootsIterator.hasNext()) throw new NoSuchElementException();
        result = this.rootsIterator.next();
        this.rootChildrenEnum = result.getChildren(true);
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private void collectEditedFiles() {
        ArrayList comps = new ArrayList(TopComponent.getRegistry().getOpened());
        HashSet<FileObject> collectedFiles = new HashSet<FileObject>(comps.size());
        for (TopComponent tc : comps) {
            FileObject fo;
            DataObject dob;
            if (!WindowManager.getDefault().isEditorTopComponent(tc) || null == (dob = (DataObject)tc.getLookup().lookup(DataObject.class)) || null == (fo = dob.getPrimaryFile()) || !this.isUnderRoots(fo)) continue;
            collectedFiles.add(fo);
        }
        this.editedFilesIterator = collectedFiles.iterator();
    }

    private boolean isUnderRoots(FileObject fo) {
        for (FileObject root : this.roots) {
            if (!FileUtil.isParentOf((FileObject)root, (FileObject)fo)) continue;
            return true;
        }
        return false;
    }
}

