/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.projectint;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.tasklist.projectint.MainProjectIterator;
import org.netbeans.spi.project.SubprojectProvider;
import org.netbeans.spi.tasklist.TaskScanningScope;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MainProjectScanningScope
extends TaskScanningScope
implements PropertyChangeListener {
    private TaskScanningScope.Callback callback;
    private InstanceContent lookupContent = new InstanceContent();
    private Lookup lookup;
    private Project currentProject;

    private MainProjectScanningScope(String displayName, String description, Image icon) {
        super(displayName, description, icon, true);
    }

    public static MainProjectScanningScope create() {
        return new MainProjectScanningScope(NbBundle.getBundle(MainProjectScanningScope.class).getString("LBL_MainProjectScope"), NbBundle.getBundle(MainProjectScanningScope.class).getString("HINT_MainProjectScope"), Utilities.loadImage((String)"org/netbeans/modules/tasklist/projectint/main_project_scope.png"));
    }

    public Iterator<FileObject> iterator() {
        return new MainProjectIterator();
    }

    public boolean isInScope(FileObject resource) {
        if (null == resource || null == this.currentProject) {
            return false;
        }
        Project owner = FileOwnerQuery.getOwner((FileObject)resource);
        if (null == owner) {
            return false;
        }
        if (owner.equals(this.currentProject)) {
            return true;
        }
        Project[] projects = OpenProjects.getDefault().getOpenProjects();
        for (int i = 0; i < projects.length; ++i) {
            SubprojectProvider subProjectProvider;
            if (projects[i].equals(this.currentProject) || null == (subProjectProvider = (SubprojectProvider)projects[i].getLookup().lookup(SubprojectProvider.class)) || !subProjectProvider.getSubprojects().contains(this.currentProject) || !projects[i].equals(owner)) continue;
            return true;
        }
        return false;
    }

    public Lookup getLookup() {
        if (null == this.lookup) {
            this.lookup = new AbstractLookup((AbstractLookup.Content)this.lookupContent);
        }
        return this.lookup;
    }

    public void attach(TaskScanningScope.Callback newCallback) {
        if (null != newCallback && null == this.callback) {
            OpenProjects.getDefault().addPropertyChangeListener((PropertyChangeListener)this);
            this.setLookupContent(OpenProjects.getDefault().getMainProject());
        } else if (null == newCallback && null != this.callback) {
            OpenProjects.getDefault().removePropertyChangeListener((PropertyChangeListener)this);
            this.setLookupContent(null);
        }
        this.callback = newCallback;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if ("MainProject".equals(e.getPropertyName()) && null != this.callback) {
            this.setLookupContent(OpenProjects.getDefault().getMainProject());
            this.callback.refresh();
        }
    }

    private void setLookupContent(Project newProject) {
        if (null != this.currentProject) {
            this.lookupContent.remove((Object)this.currentProject);
        }
        if (null != newProject) {
            this.lookupContent.add((Object)newProject);
        }
        this.currentProject = newProject;
    }
}

