/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.masterfs;

import java.awt.Image;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.netbeans.modules.masterfs.MasterFileSystem;
import org.netbeans.modules.masterfs.MountTable;
import org.netbeans.modules.masterfs.providers.AutoMountProvider;
import org.netbeans.modules.masterfs.providers.FileSystemProvider;
import org.openide.filesystems.FileSystem;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

public class ProviderCall {
    private static Map providerMap;
    private static Lookup.Result preventsLookupResultFromGC;

    static void init() {
        ProviderCall.getProviderMap();
    }

    static FileSystem createFileSystem(String resName) {
        FileSystem retVal = null;
        AutoMountProvider ap = ProviderCall.getMountAble(resName);
        if (ap != null) {
            try {
                retVal = ap.createFileSystem(resName);
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
            catch (PropertyVetoException e) {
                e.printStackTrace();
                return null;
            }
        }
        return retVal;
    }

    static boolean isMountAble(String resName) {
        return ProviderCall.getMountAble(resName) != null;
    }

    static Image getIcon(String resName, int iconType) {
        Image icon = null;
        AutoMountProvider aProvider = ProviderCall.getMountAble(resName);
        if (aProvider != null) {
            icon = aProvider.getIcon(resName, iconType);
        }
        return icon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static AutoMountProvider getMountAble(String resName) {
        HashMap providerMapCopy;
        Map map = ProviderCall.getProviderMap();
        synchronized (map) {
            providerMapCopy = new HashMap(ProviderCall.getProviderMap());
        }
        Iterator it = providerMapCopy.values().iterator();
        while (it.hasNext()) {
            boolean retVal;
            AutoMountProvider aProvider = (AutoMountProvider)it.next();
            if (aProvider == null || !(retVal = aProvider.isRootOfFileSystem(resName))) continue;
            return aProvider;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map getProviderMap() {
        Class clazz = MasterFileSystem.class;
        synchronized (clazz) {
            if (providerMap == null) {
                Lookup.Result providerResult;
                providerMap = Collections.synchronizedMap(new HashMap());
                preventsLookupResultFromGC = providerResult = Lookup.getDefault().lookup(new Lookup.Template(FileSystemProvider.class));
                ProviderCall.initFileSystemProviders(providerResult);
                providerResult.addLookupListener(new LookupListener(){

                    public void resultChanged(LookupEvent ev) {
                        ProviderCall.initFileSystemProviders(providerResult);
                    }
                });
            }
        }
        return providerMap;
    }

    private static void initFileSystemProviders(Lookup.Result result) {
        HashSet newProviders = new HashSet(result.allInstances());
        HashMap<FileSystemProvider, AutoMountProvider> upToDateMap = new HashMap<FileSystemProvider, AutoMountProvider>(newProviders.size());
        Iterator it = newProviders.iterator();
        while (it.hasNext()) {
            FileSystemProvider provider = (FileSystemProvider)it.next();
            AutoMountProvider aProvider = (AutoMountProvider)ProviderCall.getProviderMap().get(provider);
            if (aProvider == null && !ProviderCall.getProviderMap().keySet().contains(provider)) {
                MountTable.getDefault();
                aProvider = provider.initialize(MountTable.mountSupport);
            }
            upToDateMap.put(provider, aProvider);
        }
        ProviderCall.getProviderMap().clear();
        ProviderCall.getProviderMap().putAll(upToDateMap);
    }
}

