/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.masterfs.filebasedfs.children;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.masterfs.filebasedfs.children.ChildrenCache;
import org.netbeans.modules.masterfs.filebasedfs.naming.FileName;
import org.netbeans.modules.masterfs.filebasedfs.naming.FileNaming;
import org.netbeans.modules.masterfs.filebasedfs.naming.NamingFactory;
import org.netbeans.modules.masterfs.filebasedfs.utils.FileInfo;
import org.netbeans.modules.masterfs.providers.ProvidedExtensions;

public final class ChildrenSupport {
    static final int NO_CHILDREN_CACHED = 0;
    static final int SOME_CHILDREN_CACHED = 1;
    static final int ALL_CHILDREN_CACHED = 2;
    private Set notExistingChildren;
    private Set existingChildren;
    private int status = 0;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Set getCachedChildren() {
        return this.getExisting(false);
    }

    public synchronized Set getChildren(FileNaming folderName, boolean rescan) {
        if (rescan || !this.isStatus(2)) {
            this.rescanChildren(folderName);
            this.setStatus(2);
        }
        return this.getExisting(false);
    }

    public synchronized FileNaming getChild(String childName, FileNaming folderName, boolean rescan) {
        FileNaming retval = null;
        if (rescan || this.isStatus(0)) {
            retval = this.rescanChild(folderName, childName);
        } else if (this.isStatus(1)) {
            retval = this.lookupChildInCache(folderName, childName, true);
            if (retval == null && this.lookupChildInCache(folderName, childName, false) == null) {
                retval = this.rescanChild(folderName, childName);
            }
        } else if (this.isStatus(2)) {
            retval = this.lookupChildInCache(folderName, childName, true);
        }
        this.setStatus(1);
        return retval;
    }

    public synchronized void removeChild(FileNaming folderName, FileNaming childName) {
        if (!$assertionsDisabled && childName == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !childName.getParent().equals(folderName)) {
            throw new AssertionError();
        }
        this.getExisting().remove(childName);
        this.getNotExisting().add(childName);
    }

    private synchronized void addChild(FileNaming folderName, FileNaming childName) {
        if (!$assertionsDisabled && childName == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !childName.getParent().equals(folderName)) {
            throw new AssertionError();
        }
        this.getExisting().add(childName);
        this.getNotExisting().remove(childName);
    }

    public synchronized Map refresh(FileNaming folderName) {
        Map<FileNaming, Integer> retVal = new HashMap();
        HashSet e = new HashSet(this.getExisting(false));
        HashSet nE = new HashSet(this.getNotExisting(false));
        if (this.isStatus(1)) {
            HashSet existingToCheck = new HashSet(e);
            Iterator itExisting = existingToCheck.iterator();
            while (itExisting.hasNext()) {
                FileNaming fnToCheck = (FileNaming)itExisting.next();
                FileNaming fnRescanned = this.rescanChild(folderName, fnToCheck.getName());
                if (fnRescanned == null) {
                    retVal.put(fnToCheck, ChildrenCache.REMOVED_CHILD);
                    continue;
                }
                if (!$assertionsDisabled && !fnToCheck.equals(fnRescanned)) {
                    throw new AssertionError();
                }
            }
            HashSet notExistingToCheck = new HashSet(nE);
            Iterator itNotExisting = notExistingToCheck.iterator();
            while (itNotExisting.hasNext()) {
                FileNaming fnToCheck = (FileNaming)itNotExisting.next();
                if (!$assertionsDisabled && fnToCheck == null) {
                    throw new AssertionError();
                }
                FileNaming fnRescanned = this.rescanChild(folderName, fnToCheck.getName());
                if (fnRescanned == null) continue;
                retVal.put(fnToCheck, ChildrenCache.ADDED_CHILD);
            }
        } else if (this.isStatus(2)) {
            retVal = this.rescanChildren(folderName);
        }
        return retVal;
    }

    public String toString() {
        return this.getExisting(false).toString();
    }

    boolean isStatus(int status) {
        return this.status == status;
    }

    private void setStatus(int status) {
        if (this.status < status) {
            this.status = status;
        }
    }

    private FileNaming rescanChild(FileNaming folderName, String childName) {
        FileNaming retval;
        File folder = folderName.getFile();
        File child = new File(folder, childName);
        FileInfo fInfo = new FileInfo(child);
        FileNaming fileNaming = retval = fInfo.isConvertibleToFileObject() ? NamingFactory.fromFile(folderName, child) : null;
        if (retval != null) {
            this.addChild(folderName, retval);
        } else {
            FileName fChild = new FileName(folderName, child){

                public boolean isDirectory() {
                    return false;
                }

                public boolean isFile() {
                    return false;
                }
            };
            this.removeChild(folderName, fChild);
        }
        return retval;
    }

    private Map rescanChildren(FileNaming folderName) {
        HashMap<FileNaming, Integer> retval = new HashMap<FileNaming, Integer>();
        LinkedHashSet<FileNaming> newChildren = new LinkedHashSet<FileNaming>();
        File folder = folderName.getFile();
        if (!$assertionsDisabled && !folderName.getFile().getAbsolutePath().equals(folderName.toString())) {
            throw new AssertionError();
        }
        File[] childs = folder.listFiles();
        if (childs != null) {
            for (int i = 0; i < childs.length; ++i) {
                FileInfo fInfo = new FileInfo(childs[i]);
                if (!fInfo.isConvertibleToFileObject()) continue;
                FileNaming child = NamingFactory.fromFile(folderName, childs[i]);
                if (!$assertionsDisabled && child.getParent() != folderName) {
                    throw new AssertionError();
                }
                newChildren.add(child);
            }
        }
        HashSet deleted = new HashSet(this.getExisting(false));
        deleted.removeAll(newChildren);
        Iterator itRem = deleted.iterator();
        while (itRem.hasNext()) {
            FileNaming fnRem = (FileNaming)itRem.next();
            this.removeChild(folderName, fnRem);
            retval.put(fnRem, ChildrenCache.REMOVED_CHILD);
        }
        HashSet added = new HashSet(newChildren);
        added.removeAll(this.getExisting(false));
        Iterator itAdd = added.iterator();
        while (itAdd.hasNext()) {
            FileNaming fnAdd = (FileNaming)itAdd.next();
            this.addChild(folderName, fnAdd);
            retval.put(fnAdd, ChildrenCache.ADDED_CHILD);
        }
        return retval;
    }

    private FileNaming lookupChildInCache(FileNaming folder, String childName, boolean lookupExisting) {
        Set cache;
        File f = new File(folder.getFile(), childName);
        Integer id = NamingFactory.createID(f);
        class FakeNaming
        implements FileNaming {
            public FileNaming lastEqual;
            static final /* synthetic */ boolean $assertionsDisabled;
            private final /* synthetic */ String val$childName;
            private final /* synthetic */ FileNaming val$folder;
            private final /* synthetic */ File val$f;
            private final /* synthetic */ Integer val$id;

            FakeNaming(String string, FileNaming fileNaming, File file, Integer n) {
                this.val$childName = string;
                this.val$folder = fileNaming;
                this.val$f = file;
                this.val$id = n;
            }

            public String getName() {
                return this.val$childName;
            }

            public FileNaming getParent() {
                return this.val$folder;
            }

            public boolean isRoot() {
                return false;
            }

            public File getFile() {
                return this.val$f;
            }

            public Integer getId() {
                return this.val$id;
            }

            public boolean rename(String name) {
                throw new IllegalStateException();
            }

            public boolean rename(String name, ProvidedExtensions.IOHandler h) {
                throw new IllegalStateException();
            }

            public boolean equals(Object obj) {
                if (this.hashCode() == obj.hashCode()) {
                    if (!$assertionsDisabled && this.lastEqual != null) {
                        throw new AssertionError((Object)"Just one can be there");
                    }
                    if (obj instanceof FileNaming) {
                        this.lastEqual = (FileNaming)obj;
                    }
                    return true;
                }
                return false;
            }

            public int hashCode() {
                return this.val$id;
            }

            public Integer getId(boolean recompute) {
                return this.val$id;
            }

            public boolean isFile() {
                return this.getFile().isFile();
            }

            public boolean isDirectory() {
                return !this.isFile();
            }

            static {
                $assertionsDisabled = !(class$org$netbeans$modules$masterfs$filebasedfs$children$ChildrenSupport == null ? (class$org$netbeans$modules$masterfs$filebasedfs$children$ChildrenSupport = ChildrenSupport.class$("org.netbeans.modules.masterfs.filebasedfs.children.ChildrenSupport")) : class$org$netbeans$modules$masterfs$filebasedfs$children$ChildrenSupport).desiredAssertionStatus();
            }
        }
        FakeNaming fake = new FakeNaming(childName, folder, f, id);
        Set set = cache = lookupExisting ? this.getExisting(false) : this.getNotExisting(false);
        if (cache.contains(fake)) {
            if (!$assertionsDisabled && fake.lastEqual == null) {
                throw new AssertionError((Object)"If cache contains the object, we set lastEqual");
            }
            return fake.lastEqual;
        }
        return null;
    }

    private synchronized Set getExisting() {
        return this.getExisting(true);
    }

    private synchronized Set getExisting(boolean init) {
        if (init && this.existingChildren == null) {
            this.existingChildren = new HashSet();
        }
        return this.existingChildren != null ? this.existingChildren : new HashSet();
    }

    private synchronized Set getNotExisting() {
        return this.getNotExisting(true);
    }

    private synchronized Set getNotExisting(boolean init) {
        if (init && this.notExistingChildren == null) {
            this.notExistingChildren = new HashSet();
        }
        return this.notExistingChildren != null ? this.notExistingChildren : new HashSet();
    }

    static {
        $assertionsDisabled = !ChildrenSupport.class.desiredAssertionStatus();
    }
}

