/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.masterfs.filebasedfs.fileobjects;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Enumeration;
import org.netbeans.modules.masterfs.filebasedfs.Statistics;
import org.netbeans.modules.masterfs.filebasedfs.children.ChildrenCache;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.BaseFileObj;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.FolderObj;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.MutualExclusionSupport;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.WriteLock;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.WriteLockFactory;
import org.netbeans.modules.masterfs.filebasedfs.naming.FileNaming;
import org.netbeans.modules.masterfs.filebasedfs.utils.FSException;
import org.netbeans.modules.masterfs.filebasedfs.utils.FileInfo;
import org.netbeans.modules.masterfs.providers.ProvidedExtensions;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.util.Enumerations;
import org.openide.util.Mutex;

public class FileObj
extends BaseFileObj {
    static final long serialVersionUID = -1133540210876356809L;
    private long lastModified = -1L;
    private boolean realLastModifiedCached;
    static final /* synthetic */ boolean $assertionsDisabled;

    FileObj(File file, FileNaming name) {
        super(file, name);
        this.setLastModified(System.currentTimeMillis());
    }

    public OutputStream getOutputStream(FileLock lock) throws IOException {
        return this.getOutputStream(lock, null, null);
    }

    public OutputStream getOutputStream(FileLock lock, ProvidedExtensions extensions, FileObject mfo) throws IOException {
        final File f = this.getFileName().getFile();
        if (extensions != null) {
            extensions.beforeChange(mfo);
        }
        final MutualExclusionSupport.Closeable closable = MutualExclusionSupport.getDefault().addResource((Object)this, false);
        FileOutputStream retVal = null;
        try {
            retVal = new FileOutputStream(f){

                public void close() throws IOException {
                    if (!closable.isClosed()) {
                        super.close();
                        closable.close();
                        FileObj.this.setLastModified(f.lastModified());
                        FileObj.this.fireFileChangedEvent(false);
                    }
                }
            };
        }
        catch (FileNotFoundException e) {
            if (closable != null) {
                closable.close();
            }
            FileNotFoundException fex = e;
            if (!f.exists()) {
                fex = (FileNotFoundException)new FileNotFoundException(e.getLocalizedMessage()).initCause(e);
            } else if (!f.canWrite()) {
                fex = (FileNotFoundException)new FileNotFoundException(e.getLocalizedMessage()).initCause(e);
            } else if (f.getParentFile() == null) {
                fex = (FileNotFoundException)new FileNotFoundException(e.getLocalizedMessage()).initCause(e);
            } else if (!f.getParentFile().exists()) {
                fex = (FileNotFoundException)new FileNotFoundException(e.getLocalizedMessage()).initCause(e);
            }
            FSException.annotateException(fex);
            throw fex;
        }
        return retVal;
    }

    public InputStream getInputStream() throws FileNotFoundException {
        FileInputStream inputStream;
        File f = this.getFileName().getFile();
        MutualExclusionSupport.Closeable closeableReference = null;
        try {
            MutualExclusionSupport.Closeable closable;
            closeableReference = closable = MutualExclusionSupport.getDefault().addResource((Object)this, true);
            inputStream = new FileInputStream(f){

                public void close() throws IOException {
                    super.close();
                    closable.close();
                }
            };
        }
        catch (IOException e) {
            if (closeableReference != null) {
                closeableReference.close();
            }
            FileNotFoundException fex = null;
            fex = !f.exists() ? (FileNotFoundException)new FileNotFoundException(e.getLocalizedMessage()).initCause(e) : (!f.canRead() ? (FileNotFoundException)new FileNotFoundException(e.getLocalizedMessage()).initCause(e) : (f.getParentFile() == null ? (FileNotFoundException)new FileNotFoundException(e.getLocalizedMessage()).initCause(e) : (!f.getParentFile().exists() ? (FileNotFoundException)new FileNotFoundException(e.getLocalizedMessage()).initCause(e) : (new FileInfo(f).isUnixSpecialFile() ? (FileNotFoundException)new FileNotFoundException(e.toString()).initCause(e) : (FileNotFoundException)new FileNotFoundException(e.toString()).initCause(e)))));
            FSException.annotateException(fex);
            throw fex;
        }
        if (!$assertionsDisabled && inputStream == null) {
            throw new AssertionError();
        }
        return inputStream;
    }

    public final Date lastModified() {
        File f = this.getFileName().getFile();
        return new Date(f.lastModified());
    }

    private final void setLastModified(long lastModified) {
        if (this.lastModified != -1L && !this.realLastModifiedCached) {
            this.realLastModifiedCached = true;
        }
        this.lastModified = lastModified;
    }

    public final FileObject createFolder(String name) throws IOException {
        throw new IOException(this.getPath());
    }

    public final FileObject createData(String name, String ext) throws IOException {
        throw new IOException(this.getPath());
    }

    public final FileObject[] getChildren() {
        return new FileObject[0];
    }

    public final FileObject getFileObject(String name, String ext) {
        return null;
    }

    public boolean isValid() {
        return this.lastModified != 0L;
    }

    protected void setValid(boolean valid) {
        if (valid) {
            if (!$assertionsDisabled && !this.isValid()) {
                throw new AssertionError((Object)this.toString());
            }
        } else {
            this.lastModified = 0L;
        }
    }

    public final boolean isFolder() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(boolean expected, boolean fire) {
        Statistics.StopWatch stopWatch = Statistics.getStopWatch(Statistics.REFRESH_FILE);
        stopWatch.start();
        if (this.isValid()) {
            boolean validityFlag;
            boolean isModified;
            long oldLastModified = this.lastModified;
            boolean isReal = this.realLastModifiedCached;
            this.setLastModified(this.getFileName().getFile().lastModified());
            boolean bl = isReal ? oldLastModified != this.lastModified : (isModified = oldLastModified < this.lastModified);
            if (fire && oldLastModified != -1L && this.lastModified != -1L && this.lastModified != 0L && isModified) {
                this.fireFileChangedEvent(expected);
            }
            if (!(validityFlag = this.getFileName().getFile().exists())) {
                FolderObj parent = this.getExistingParent();
                if (parent != null) {
                    Mutex.Privileged mutexPrivileged;
                    ChildrenCache childrenCache = parent.getChildrenCache();
                    Mutex.Privileged privileged = mutexPrivileged = childrenCache != null ? childrenCache.getMutexPrivileged() : null;
                    if (mutexPrivileged != null) {
                        mutexPrivileged.enterWriteAccess();
                    }
                    try {
                        childrenCache.getChild(this.getFileName().getFile().getName(), true);
                    }
                    finally {
                        if (mutexPrivileged != null) {
                            mutexPrivileged.exitWriteAccess();
                        }
                    }
                }
                this.setValid(false);
                if (fire) {
                    this.fireFileDeletedEvent(expected);
                }
            }
        }
        stopWatch.stop();
    }

    public final void refresh(boolean expected) {
        this.refresh(expected, true);
    }

    public final Enumeration getChildren(boolean rec) {
        return Enumerations.empty();
    }

    public final Enumeration getFolders(boolean rec) {
        return Enumerations.empty();
    }

    public final Enumeration getData(boolean rec) {
        return Enumerations.empty();
    }

    public final FileLock lock() throws IOException {
        File me = this.getFileName().getFile();
        try {
            boolean lightWeightLock = false;
            FolderObj bfo = this.getExistingParent();
            if (bfo instanceof FolderObj) {
                lightWeightLock = bfo.isLightWeightLockRequired();
            }
            return WriteLockFactory.tryLock(me, lightWeightLock);
        }
        catch (FileNotFoundException ex) {
            FileNotFoundException fex = ex;
            if (!me.exists()) {
                fex = (FileNotFoundException)new FileNotFoundException(ex.getLocalizedMessage()).initCause(ex);
            } else if (!me.canRead()) {
                fex = (FileNotFoundException)new FileNotFoundException(ex.getLocalizedMessage()).initCause(ex);
            } else if (!me.canWrite()) {
                fex = (FileNotFoundException)new FileNotFoundException(ex.getLocalizedMessage()).initCause(ex);
            } else if (me.getParentFile() == null) {
                fex = (FileNotFoundException)new FileNotFoundException(ex.getLocalizedMessage()).initCause(ex);
            } else if (!me.getParentFile().exists()) {
                fex = (FileNotFoundException)new FileNotFoundException(ex.getLocalizedMessage()).initCause(ex);
            }
            FSException.annotateException(fex);
            throw fex;
        }
    }

    final boolean checkLock(FileLock lock) throws IOException {
        File f = this.getFileName().getFile();
        return lock instanceof WriteLock && ((WriteLock)lock).isValid(f);
    }

    public void rename(FileLock lock, String name, String ext, ProvidedExtensions.IOHandler handler) throws IOException {
        super.rename(lock, name, ext, handler);
        this.setLastModified(this.getFileName().getFile().lastModified());
    }

    static {
        $assertionsDisabled = !FileObj.class.desiredAssertionStatus();
    }
}

