/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.masterfs.filebasedfs.fileobjects;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Enumeration;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.BaseFileObj;
import org.netbeans.modules.masterfs.filebasedfs.utils.FSException;
import org.netbeans.modules.masterfs.filebasedfs.utils.FileInfo;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.util.Utilities;

public final class RootObj
extends FileObject {
    private BaseFileObj realRoot = null;

    public RootObj(BaseFileObj realRoot) {
        this.realRoot = realRoot;
    }

    public final String getName() {
        return "";
    }

    public final String getExt() {
        return "";
    }

    public final FileSystem getFileSystem() throws FileStateInvalidException {
        return this.getRealRoot().getFileSystem();
    }

    public final FileObject getParent() {
        return null;
    }

    public final boolean isFolder() {
        return true;
    }

    public final boolean isData() {
        return !this.isFolder();
    }

    public final Date lastModified() {
        return new Date(0L);
    }

    public final boolean isRoot() {
        return true;
    }

    public final boolean isValid() {
        return true;
    }

    public final void rename(FileLock lock, String name, String ext) throws IOException {
        FSException.io("EXC_CannotRenameRoot", this.getFileSystem().getDisplayName());
    }

    public final void delete(FileLock lock) throws IOException {
        FSException.io("EXC_CannotDeleteRoot", this.getFileSystem().getDisplayName());
    }

    public final Object getAttribute(String attrName) {
        return null;
    }

    public final void setAttribute(String attrName, Object value) throws IOException {
        throw new IOException(this.getPath());
    }

    public final Enumeration getAttributes() {
        return new Enumeration(){

            public boolean hasMoreElements() {
                return false;
            }

            public Object nextElement() {
                return null;
            }
        };
    }

    public final void addFileChangeListener(FileChangeListener fcl) {
    }

    public final void removeFileChangeListener(FileChangeListener fcl) {
    }

    public final long getSize() {
        return 0L;
    }

    public final InputStream getInputStream() throws FileNotFoundException {
        throw new FileNotFoundException(this.getPath());
    }

    public final OutputStream getOutputStream(FileLock lock) throws IOException {
        throw new FileNotFoundException(this.getPath());
    }

    public final FileLock lock() throws IOException {
        FSException.io("EXC_CannotLockRoot");
        return null;
    }

    public final void setImportant(boolean b) {
    }

    public final FileObject[] getChildren() {
        return new FileObject[]{this.getRealRoot()};
    }

    public final FileObject getFileObject(String name, String ext) {
        BaseFileObj retVal = null;
        if (name.equals(this.getRealRoot().getName())) {
            String ext2 = this.getRealRoot().getExt();
            retVal = ext == null || ext.length() == 0 ? (ext2 == null || ext2.length() == 0 ? this.getRealRoot() : null) : (ext.equals(ext2) ? this.getRealRoot() : null);
        }
        return retVal;
    }

    public final FileObject getFileObject(String relativePath) {
        BaseFileObj retVal;
        FileInfo fInfo = new FileInfo(this.getRealRoot().getFileName().getFile());
        if (!Utilities.isWindows() || fInfo.isUNCFolder()) {
            retVal = this.getRealRoot();
            if (fInfo.isUNCFolder() && relativePath.startsWith("//") || relativePath.startsWith("\\\\")) {
                relativePath = relativePath.substring(2);
            }
            retVal = retVal.getFileObject(relativePath);
        } else {
            retVal = super.getFileObject(relativePath);
        }
        return retVal;
    }

    public final FileObject createFolder(String name) throws IOException {
        throw new IOException(this.getPath());
    }

    public final FileObject createData(String name, String ext) throws IOException {
        throw new IOException(this.getPath());
    }

    public final boolean isReadOnly() {
        return true;
    }

    public final BaseFileObj getRealRoot() {
        return this.realRoot;
    }

    public String toString() {
        String retVal;
        try {
            FileSystem fileSystem = this.getFileSystem();
            retVal = fileSystem.getDisplayName();
        }
        catch (FileStateInvalidException e) {
            retVal = super.toString();
        }
        return retVal;
    }
}

