/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.masterfs.filebasedfs.naming;

import java.io.File;
import java.io.IOException;
import org.netbeans.modules.masterfs.filebasedfs.naming.FileNaming;
import org.netbeans.modules.masterfs.filebasedfs.naming.FolderName;
import org.netbeans.modules.masterfs.filebasedfs.naming.NamingFactory;
import org.netbeans.modules.masterfs.providers.ProvidedExtensions;
import org.openide.util.Exceptions;

public class FileName
implements FileNaming {
    private String name;
    private final FileNaming parent;
    private Integer id;

    protected FileName(FileNaming parent, File file) {
        this.parent = parent;
        this.name = FileName.parseName(file);
        this.id = NamingFactory.createID(file);
    }

    private static String parseName(File file) {
        return file.getParentFile() == null ? file.getPath() : file.getName();
    }

    public boolean rename(String name, ProvidedExtensions.IOHandler handler) {
        boolean retVal = false;
        File f = this.getFile();
        if (f.exists()) {
            File newFile = new File(f.getParentFile(), name);
            if (handler != null) {
                try {
                    handler.handle();
                    retVal = true;
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            } else {
                retVal = f.renameTo(newFile);
            }
            if (retVal) {
                this.name = name;
                Integer iid = NamingFactory.createID(newFile);
                if (!iid.equals(this.id)) {
                    this.id = iid;
                }
            }
        }
        FolderName.freeCaches();
        return retVal;
    }

    public final boolean rename(String name) {
        return this.rename(name, null);
    }

    public final boolean isRoot() {
        return this.getParent() == null;
    }

    public File getFile() {
        FileNaming parent = this.getParent();
        return parent != null ? new File(parent.getFile(), this.getName()) : new File(this.getName());
    }

    public final String getName() {
        return this.name;
    }

    public FileNaming getParent() {
        return this.parent;
    }

    public final Integer getId() {
        return this.getId(false);
    }

    public Integer getId(boolean recompute) {
        if (recompute) {
            this.id = NamingFactory.createID(this.getFile());
        }
        return this.id;
    }

    public final boolean equals(Object obj) {
        return obj instanceof FileNaming && obj.hashCode() == this.hashCode();
    }

    public final String toString() {
        return this.getFile().getAbsolutePath();
    }

    public final int hashCode() {
        return this.id;
    }

    public boolean isFile() {
        return true;
    }

    public boolean isDirectory() {
        return !this.isFile();
    }
}

