/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.masterfs.filebasedfs.naming;

import java.io.File;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.netbeans.modules.masterfs.filebasedfs.naming.FileName;
import org.netbeans.modules.masterfs.filebasedfs.naming.FileNaming;
import org.netbeans.modules.masterfs.filebasedfs.naming.FolderName;
import org.netbeans.modules.masterfs.filebasedfs.naming.UNCName;
import org.netbeans.modules.masterfs.filebasedfs.utils.FileInfo;
import org.netbeans.modules.masterfs.providers.ProvidedExtensions;

public final class NamingFactory {
    private static final Map nameMap;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static synchronized FileNaming fromFile(File file) {
        LinkedList<File> list = new LinkedList<File>();
        for (File current = file; current != null; current = current.getParentFile()) {
            list.addFirst(current);
        }
        FileNaming fileName = null;
        for (int i = 0; i < list.size(); ++i) {
            fileName = NamingFactory.registerInstanceOfFileNaming(fileName, (File)list.get(i));
        }
        return fileName;
    }

    public static synchronized int getSize() {
        return nameMap.size();
    }

    public static synchronized FileNaming fromFile(FileNaming parentFn, File file) {
        return NamingFactory.registerInstanceOfFileNaming(parentFn, file);
    }

    public static synchronized void checkCaseSensitivity(FileNaming childName, File f) {
        if (!childName.getFile().getName().equals(f.getName())) {
            boolean isCaseSensitive;
            boolean bl = isCaseSensitive = !new File(f, "a").equals(new File(f, "A"));
            if (!isCaseSensitive) {
                NamingFactory.rename(childName, f.getName());
            }
        }
    }

    private static synchronized FileNaming[] rename(FileNaming fNaming, String newName) {
        return NamingFactory.rename(fNaming, newName, null);
    }

    public static synchronized FileNaming[] rename(FileNaming fNaming, String newName, ProvidedExtensions.IOHandler handler) {
        ArrayList<FileNaming> all = new ArrayList<FileNaming>();
        boolean retVal = false;
        NamingFactory.remove(fNaming, null);
        retVal = fNaming.rename(newName, handler);
        all.add(fNaming);
        NamingFactory.registerInstanceOfFileNaming(fNaming.getParent(), fNaming.getFile(), fNaming);
        NamingFactory.renameChildren(all);
        return retVal ? all.toArray(new FileNaming[all.size()]) : null;
    }

    private static void renameChildren(ArrayList all) {
        Integer id;
        Map.Entry entry;
        HashMap<Integer, FileNaming> toRename = new HashMap<Integer, FileNaming>();
        Iterator iterator = nameMap.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            id = (Integer)entry.getKey();
            ArrayList list = new ArrayList();
            Object value = entry.getValue();
            if (value instanceof Reference) {
                list.add(value);
            } else if (value instanceof List) {
                list.addAll((List)value);
            }
            for (int i = 0; i < list.size(); ++i) {
                boolean isRenamed;
                FileNaming fN = (FileNaming)((Reference)list.get(i)).get();
                if (fN == null) continue;
                Integer computedId = NamingFactory.createID(fN.getFile());
                boolean bl = isRenamed = !computedId.equals(id);
                if (!isRenamed) continue;
                toRename.put(id, fN);
            }
        }
        iterator = toRename.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            id = (Integer)entry.getKey();
            FileNaming fN = (FileNaming)entry.getValue();
            all.add(fN);
            NamingFactory.remove(fN, id);
            fN.getId(true);
            NamingFactory.registerInstanceOfFileNaming(fN.getParent(), fN.getFile(), fN);
        }
    }

    private static void remove(FileNaming fNaming, Integer id) {
        Object value = nameMap.get(id = id != null ? id : fNaming.getId());
        if (value instanceof List) {
            Reference ref = NamingFactory.getReference((List)value, fNaming.getFile());
            if (ref != null) {
                ((List)value).remove(ref);
            }
        } else {
            nameMap.remove(id);
        }
    }

    public static Integer createID(File file) {
        return new Integer(file.hashCode());
    }

    private static FileNaming registerInstanceOfFileNaming(FileNaming parentName, File file) {
        return NamingFactory.registerInstanceOfFileNaming(parentName, file, null);
    }

    private static FileNaming registerInstanceOfFileNaming(FileNaming parentName, File file, FileNaming newValue) {
        FileNaming retVal;
        FileNaming cachedElement;
        Object value = nameMap.get(new Integer(file.hashCode()));
        Reference ref = (Reference)(value instanceof Reference ? value : null);
        ref = ref == null && value instanceof List ? NamingFactory.getReference((List)value, file) : ref;
        FileNaming fileNaming = cachedElement = ref != null ? (FileNaming)ref.get() : null;
        if (cachedElement != null && cachedElement.getFile().compareTo(file) == 0) {
            retVal = cachedElement;
        } else {
            retVal = newValue == null ? NamingFactory.createFileNaming(file, parentName) : newValue;
            WeakReference<FileNaming> refRetVal = new WeakReference<FileNaming>(retVal);
            boolean isList = value instanceof List;
            if (cachedElement != null || isList) {
                if (isList) {
                    ((List)value).add(refRetVal);
                } else {
                    ArrayList<WeakReference<FileNaming>> l = new ArrayList<WeakReference<FileNaming>>();
                    l.add(refRetVal);
                    nameMap.put(retVal.getId(), l);
                }
            } else {
                Reference r = nameMap.put(retVal.getId(), refRetVal);
                if (!$assertionsDisabled && r != null && r.get() != null) {
                    throw new AssertionError();
                }
            }
        }
        if (!$assertionsDisabled && retVal == null) {
            throw new AssertionError();
        }
        return retVal;
    }

    private static Reference getReference(List list, File f) {
        Reference retVal = null;
        for (int i = 0; retVal == null && i < list.size(); ++i) {
            FileNaming cachedElement;
            Reference ref = (Reference)list.get(i);
            FileNaming fileNaming = cachedElement = ref != null ? (FileNaming)ref.get() : null;
            if (cachedElement == null || cachedElement.getFile().compareTo(f) != 0) continue;
            retVal = ref;
        }
        return retVal;
    }

    private static FileNaming createFileNaming(File f, FileNaming parentName) {
        FileName retVal = null;
        FileInfo fInfo = new FileInfo(f);
        if (f.isFile()) {
            retVal = new FileName(parentName, f);
        } else if (f.isDirectory()) {
            retVal = new FolderName(parentName, f);
        } else if (fInfo.isUNCFolder()) {
            retVal = new UNCName(parentName, f);
        }
        if (retVal == null) {
            retVal = new FileName(parentName, f){

                public boolean isDirectory() {
                    return false;
                }

                public boolean isFile() {
                    return false;
                }
            };
        }
        if (!$assertionsDisabled && retVal == null) {
            throw new AssertionError((Object)(f.getAbsolutePath() + " isDirectory: " + f.isDirectory() + " isFile: " + f.isFile() + " exists: " + f.exists()));
        }
        return retVal;
    }

    static {
        $assertionsDisabled = !NamingFactory.class.desiredAssertionStatus();
        nameMap = new WeakHashMap();
    }
}

