/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.projectint;

import java.util.Iterator;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.tasklist.projectint.EmptyIterator;
import org.netbeans.modules.tasklist.projectint.FileObjectIterator;
import org.netbeans.spi.project.SubprojectProvider;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MainProjectIterator
implements Iterator<FileObject> {
    private Iterator<FileObject> iterator;

    @Override
    public boolean hasNext() {
        this.initialize();
        return this.iterator.hasNext();
    }

    @Override
    public FileObject next() {
        this.initialize();
        return this.iterator.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private void initialize() {
        if (null == this.iterator) {
            this.iterator = this.createIterator();
        }
    }

    protected Iterator<FileObject> createIterator() {
        Project mainProject = OpenProjects.getDefault().getMainProject();
        if (null == mainProject) {
            return new EmptyIterator();
        }
        FileObjectIterator it = new FileObjectIterator();
        this.addProject(mainProject, it);
        this.addDependantProjects(mainProject, it);
        return it;
    }

    private void addDependantProjects(Project mainProject, FileObjectIterator iterator) {
        Project[] projects = OpenProjects.getDefault().getOpenProjects();
        for (int i = 0; i < projects.length; ++i) {
            SubprojectProvider subProjectProvider;
            if (projects[i].equals(mainProject) || null == (subProjectProvider = (SubprojectProvider)projects[i].getLookup().lookup(SubprojectProvider.class)) || !subProjectProvider.getSubprojects().contains(mainProject)) continue;
            this.addProject(projects[i], iterator);
        }
    }

    private void addProject(Project p, FileObjectIterator it) {
        SourceGroup[] groups;
        Sources sources = ProjectUtils.getSources((Project)p);
        for (SourceGroup group : groups = sources.getSourceGroups("generic")) {
            FileObject rootFolder = group.getRootFolder();
            it.addRoot(rootFolder);
        }
    }
}

