/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.projectint;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.tasklist.projectint.MainProjectScanningScope;
import org.netbeans.modules.tasklist.projectint.OpenedProjectsIterator;
import org.netbeans.spi.tasklist.TaskScanningScope;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenedProjectsScanningScope
extends TaskScanningScope
implements PropertyChangeListener {
    private TaskScanningScope.Callback callback;
    private InstanceContent lookupContent = new InstanceContent();
    private Lookup lookup;
    private Project[] currentProjects;

    private OpenedProjectsScanningScope(String displayName, String description, Image icon) {
        super(displayName, description, icon);
    }

    public static OpenedProjectsScanningScope create() {
        return new OpenedProjectsScanningScope(NbBundle.getBundle(MainProjectScanningScope.class).getString("LBL_OpenedProjectsScope"), NbBundle.getBundle(MainProjectScanningScope.class).getString("HINT_OpenedProjectsScope"), Utilities.loadImage((String)"org/netbeans/modules/tasklist/projectint/opened_projects_scope.png"));
    }

    public Iterator<FileObject> iterator() {
        return new OpenedProjectsIterator();
    }

    public boolean isInScope(FileObject resource) {
        if (null == resource || null == this.currentProjects) {
            return false;
        }
        for (Project p : this.currentProjects) {
            SourceGroup[] groups;
            Sources sources = ProjectUtils.getSources((Project)p);
            for (SourceGroup group : groups = sources.getSourceGroups("generic")) {
                FileObject rootFolder = group.getRootFolder();
                if (!FileUtil.isParentOf((FileObject)rootFolder, (FileObject)resource) && !rootFolder.equals(resource)) continue;
                return true;
            }
        }
        return false;
    }

    public Lookup getLookup() {
        if (null == this.lookup) {
            this.lookup = new AbstractLookup((AbstractLookup.Content)this.lookupContent);
        }
        return this.lookup;
    }

    public void attach(TaskScanningScope.Callback newCallback) {
        if (null != newCallback && null == this.callback) {
            OpenProjects.getDefault().addPropertyChangeListener((PropertyChangeListener)this);
            this.setLookupContent(OpenProjects.getDefault().getOpenProjects());
        } else if (null == newCallback && null != this.callback) {
            OpenProjects.getDefault().removePropertyChangeListener((PropertyChangeListener)this);
            this.setLookupContent(null);
        }
        this.callback = newCallback;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if ("openProjects".equals(e.getPropertyName()) && null != this.callback) {
            this.setLookupContent(OpenProjects.getDefault().getOpenProjects());
            this.callback.refresh();
        }
    }

    private void setLookupContent(Project[] newProjects) {
        if (null != this.currentProjects) {
            for (Project p : this.currentProjects) {
                this.lookupContent.remove((Object)p);
            }
        }
        if (null != newProjects) {
            for (Project p : newProjects) {
                this.lookupContent.add((Object)p);
            }
        }
        this.currentProjects = newProjects;
    }
}

