/*
 * Decompiled with CFR 0.152.
 */
package org.openide.text;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.LinkedList;
import java.util.List;
import org.openide.text.Annotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Annotatable {
    public static final String PROP_ANNOTATION_COUNT = "annotationCount";
    public static final String PROP_DELETED = "deleted";
    public static final String PROP_TEXT = "text";
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private int annotationCount = 0;
    private List<Annotation> attachedAnnotations = new LinkedList<Annotation>();
    private boolean deleted = false;

    protected void addAnnotation(Annotation anno) {
        ++this.annotationCount;
        this.attachedAnnotations.add(anno);
        this.propertyChangeSupport.firePropertyChange(PROP_ANNOTATION_COUNT, this.annotationCount - 1, this.annotationCount);
    }

    protected void removeAnnotation(Annotation anno) {
        --this.annotationCount;
        this.attachedAnnotations.remove(anno);
        this.propertyChangeSupport.firePropertyChange(PROP_ANNOTATION_COUNT, this.annotationCount + 1, this.annotationCount);
    }

    List<? extends Annotation> getAnnotations() {
        return this.attachedAnnotations;
    }

    public final void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.addPropertyChangeListener(l);
    }

    public final void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.removePropertyChangeListener(l);
    }

    protected final void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    public final boolean isDeleted() {
        return this.deleted;
    }

    public abstract String getText();

    void setDeleted(boolean deleted) {
        if (this.deleted != deleted) {
            this.deleted = deleted;
            this.propertyChangeSupport.firePropertyChange(PROP_DELETED, !deleted, deleted);
        }
    }

    public final int getAnnotationCount() {
        return this.annotationCount;
    }
}

