/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.Prefs;
import ij.gui.GenericDialog;
import ij.io.OpenDialog;
import ij.plugin.PlugIn;
import ij.plugin.PlugInExecuter;
import ij.plugin.frame.Editor;
import java.awt.Font;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Locale;

public class Compiler
implements PlugIn,
FilenameFilter {
    private static ByteArrayOutputStream output;
    private static String dir;
    private static String name;
    private static Editor errors;
    private static boolean generateDebuggingInfo;

    public void run(String arg) {
        IJ.register(Compiler.class);
        if (arg.equals("edit")) {
            this.edit();
        } else {
            this.compileAndRun(arg);
        }
    }

    void edit() {
        Editor ed;
        if (this.open("", "Open macro or plugin") && (ed = (Editor)IJ.runPlugIn("ij.plugin.frame.Editor", "")) != null) {
            ed.open(dir, name);
        }
    }

    void compileAndRun(String path) {
        if (!this.isJavac()) {
            return;
        }
        if (IJ.altKeyDown()) {
            IJ.setKeyUp(18);
            GenericDialog gd = new GenericDialog("Compile and Run");
            gd.addCheckbox("Generate Debugging Info (javac -g)", generateDebuggingInfo);
            gd.showDialog();
            if (gd.wasCanceled()) {
                return;
            }
            generateDebuggingInfo = gd.getNextBoolean();
        }
        if (!this.open(path, "Compile and Run Plugin...")) {
            return;
        }
        if (name.endsWith(".class")) {
            this.runPlugin(name.substring(0, name.length() - 1));
        } else if (this.compile(dir + name)) {
            this.runPlugin(name);
        }
    }

    boolean isJavac() {
        return true;
    }

    boolean compile(String path) {
        IJ.showStatus("compiling: " + path);
        String classpath = System.getProperty("java.class.path");
        File f = new File(path);
        if (f != null) {
            classpath = classpath + File.pathSeparator + f.getParent();
        }
        output.reset();
        if (generateDebuggingInfo) {
            String[] arguments = new String[]{"-g", "-deprecation", "-classpath", classpath, path};
        } else {
            String[] arguments = new String[]{"-deprecation", "-classpath", classpath, path};
        }
        String s = output.toString();
        return true;
    }

    boolean areErrors(String s) {
        boolean errors;
        boolean bl = errors = s != null && s.length() > 0;
        if (errors && s.startsWith("Note: sun.tools.javac") && s.indexOf("error") == -1) {
            errors = false;
        }
        return errors;
    }

    void showErrors(String s) {
        if (errors == null || !errors.isVisible()) {
            errors = (Editor)IJ.runPlugIn("ij.plugin.frame.Editor", "");
            errors.setFont(new Font("Monospaced", 0, 12));
        }
        if (errors != null) {
            errors.display("Errors", s);
        }
        IJ.showStatus("done (errors)");
    }

    boolean open(String path, String msg) {
        boolean okay;
        String fileName;
        String directory;
        if (path.equals("")) {
            String lcName;
            if (dir == null) {
                dir = Prefs.getHomeDir();
            }
            OpenDialog od = new OpenDialog(msg, dir, name);
            directory = od.getDirectory();
            fileName = od.getFileName();
            okay = fileName != null;
            String string = lcName = okay ? fileName.toLowerCase(Locale.US) : null;
            if (okay) {
                if (msg.startsWith("Compile")) {
                    if (!lcName.endsWith(".java") && !lcName.endsWith(".class")) {
                        IJ.error("File name must end with \".java\" or \".class\".");
                        okay = false;
                    }
                } else if (!(lcName.endsWith(".java") || lcName.endsWith(".txt") || lcName.endsWith(".ijm"))) {
                    IJ.error("File name must end with \".java\" or \".txt\".");
                    okay = false;
                }
            }
        } else {
            int i = path.lastIndexOf(47);
            if (i == -1) {
                i = path.lastIndexOf(92);
            }
            if (i > 0) {
                directory = path.substring(0, i + 1);
                fileName = path.substring(i + 1);
            } else {
                directory = "";
                fileName = path;
            }
            okay = true;
        }
        if (okay) {
            name = fileName;
            dir = directory;
            Editor.setDefaultDirectory(dir);
        }
        return okay;
    }

    public boolean accept(File dir, String name) {
        return name.endsWith(".java") || name.endsWith(".macro") || name.endsWith(".txt");
    }

    void runPlugin(String name) {
        name = name.substring(0, name.length() - 5);
        new PlugInExecuter(name);
    }
}

