/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.io.FileInfo;
import ij.plugin.PlugIn;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;

public class FITS_Writer
implements PlugIn {
    ImagePlus imp;

    public void run(String path) {
        this.imp = IJ.getImage();
        ImageProcessor ip = this.imp.getProcessor();
        int bitDepth = this.imp.getBitDepth();
        if (bitDepth == 8 || bitDepth == 24) {
            IJ.error("16 or 32 bit image required");
            return;
        }
        File f = new File(path);
        String directory = f.getParent() + File.separator;
        String name = f.getName();
        if (f.exists()) {
            f.delete();
        }
        int numImages = this.imp.getImageStackSize();
        int numBytes = 0;
        if (this.imp.getType() == 1) {
            numBytes = 2;
        } else if (this.imp.getType() == 2) {
            numBytes = 4;
        }
        int fillerLength = 2880 - numBytes * this.imp.getWidth() * this.imp.getHeight() % 2880;
        this.createHeader(path);
        this.writeData(path, ip.getPixels());
        char[] endFiller = new char[fillerLength];
        this.appendFile(endFiller, path);
    }

    void createHeader(String path) {
        int numCards = 5;
        String bitperpix = "";
        if (this.imp.getType() == 1) {
            bitperpix = "                  16";
        } else if (this.imp.getType() == 2) {
            bitperpix = "                 -32";
        } else if (this.imp.getType() == 0) {
            bitperpix = "                   8";
        }
        this.appendFile(this.writeCard("SIMPLE", "                   T", ""), path);
        this.appendFile(this.writeCard("BITPIX", bitperpix, ""), path);
        this.appendFile(this.writeCard("NAXIS", "                   2", ""), path);
        this.appendFile(this.writeCard("NAXIS1", "                 " + this.imp.getWidth(), "image width"), path);
        this.appendFile(this.writeCard("NAXIS2", "                 " + this.imp.getHeight(), "image height"), path);
        int fillerSize = 2880 - (numCards * 80 + 3) % 2880;
        char[] end = new char[]{'E', 'N', 'D'};
        char[] filler = new char[fillerSize];
        for (int i = 0; i < fillerSize; ++i) {
            filler[i] = 32;
        }
        this.appendFile(end, path);
        this.appendFile(filler, path);
    }

    char[] writeCard(String title, String value, String comment) {
        char[] card = new char[80];
        for (int i = 0; i < 80; ++i) {
            card[i] = 32;
        }
        this.s2ch(title, card, 0);
        card[8] = 61;
        this.s2ch(value, card, 10);
        card[31] = 47;
        this.s2ch(comment, card, 32);
        return card;
    }

    void s2ch(String str, char[] ch, int offset) {
        int j = 0;
        for (int i = offset; i < str.length() + offset; ++i) {
            ch[i] = str.charAt(j++);
        }
    }

    void appendFile(char[] line, String path) {
        try {
            FileWriter output = new FileWriter(path, true);
            output.write(line);
            output.close();
        }
        catch (IOException e) {
            IJ.showStatus("Error writing file!");
            return;
        }
    }

    void writeData(String path, Object data) {
        int w = this.imp.getWidth();
        int h = this.imp.getHeight();
        FileInfo fi = this.imp.getFileInfo();
        if (this.imp.getType() == 1) {
            short[] pixels = (short[])data;
            ShortProcessor ip = new ShortProcessor(w, h, pixels, null);
            ((ImageProcessor)ip).flipVertical();
            try {
                DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(path, true)));
                for (int i = 0; i < pixels.length; ++i) {
                    dos.writeShort(pixels[i]);
                }
                dos.close();
            }
            catch (IOException e) {
                IJ.write("Error writing file!");
                return;
            }
            ((ImageProcessor)ip).flipVertical();
        } else if (this.imp.getType() == 2) {
            float[] pixels = (float[])data;
            FloatProcessor ip = new FloatProcessor(w, h, pixels, null);
            ((ImageProcessor)ip).flipVertical();
            try {
                DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(path, true)));
                for (int i = 0; i < pixels.length; ++i) {
                    dos.writeFloat(pixels[i]);
                }
                dos.close();
            }
            catch (IOException e) {
                IJ.write("Error writing file!");
                return;
            }
            ((ImageProcessor)ip).flipVertical();
        }
    }
}

