/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.Undo;
import ij.gui.GenericDialog;
import ij.gui.Roi;
import ij.io.OpenDialog;
import ij.io.SaveDialog;
import ij.plugin.TextReader;
import ij.plugin.filter.PlugInFilter;
import ij.plugin.frame.Recorder;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.awt.Button;
import java.awt.FlowLayout;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.StringTokenizer;

public class Convolver
implements PlugInFilter,
ActionListener {
    static final int BYTE = 0;
    static final int SHORT = 1;
    static final int FLOAT = 2;
    static final int RGB = 3;
    ImagePlus imp;
    int kw;
    int kh;
    int slice = 1;
    boolean canceled;
    float[] kernel;
    boolean isLineRoi;
    Button open;
    Button save;
    GenericDialog gd;
    boolean normalize = true;
    int nSlices;
    static String kernelText = "-1 -1 -1 -1 -1\n-1 -1 -1 -1 -1\n-1 -1 24 -1 -1\n-1 -1 -1 -1 -1\n-1 -1 -1 -1 -1\n";
    static boolean normalizeFlag = true;

    public int setup(String arg, ImagePlus imp) {
        IJ.register(Convolver.class);
        this.imp = imp;
        this.canceled = false;
        if (imp == null) {
            IJ.noImage();
            return 4096;
        }
        IJ.resetEscape();
        Roi roi = imp.getRoi();
        this.isLineRoi = roi != null && roi.isLine();
        this.kernel = this.getKernel();
        if (this.kernel == null) {
            return 4096;
        }
        if ((this.kw & 1) == 0) {
            IJ.error("Convolver", "The kernel must be square and have an\nodd width. This kernel is " + this.kw + "x" + this.kh + ".");
            return 4096;
        }
        this.nSlices = imp.getStackSize();
        int flags = IJ.setupDialog(imp, 31);
        if ((flags & 0x1000) != 0) {
            return 4096;
        }
        IJ.showStatus("Convolve: " + this.kw + "x" + this.kh + " kernel");
        imp.startTiming();
        return flags;
    }

    public void run(ImageProcessor ip) {
        if (this.canceled) {
            return;
        }
        if (this.isLineRoi) {
            ip.resetRoi();
        }
        this.convolve(ip, this.kernel, this.kw, this.kh);
        if (this.slice > 1) {
            IJ.showStatus("Convolve: " + this.slice + "/" + this.nSlices);
        }
        if (this.slice == this.nSlices) {
            ip.resetMinAndMax();
        }
        ++this.slice;
        if (this.canceled) {
            Undo.undo();
        }
    }

    float[] getKernel() {
        this.gd = new GenericDialog("Convolver...", IJ.getInstance());
        this.gd.addTextAreas(kernelText, null, 10, 30);
        this.gd.addPanel(this.makeButtonPanel(this.gd));
        this.gd.addCheckbox("Normalize Kernel", normalizeFlag);
        this.gd.showDialog();
        if (this.gd.wasCanceled()) {
            this.canceled = true;
            return null;
        }
        kernelText = this.gd.getNextText();
        this.normalize = normalizeFlag = this.gd.getNextBoolean();
        StringTokenizer st = new StringTokenizer(kernelText);
        int n = st.countTokens();
        this.kh = this.kw = (int)Math.sqrt(n);
        n = this.kw * this.kh;
        float[] k = new float[n];
        for (int i = 0; i < n; ++i) {
            k[i] = (float)this.getNum(st);
        }
        return k;
    }

    Panel makeButtonPanel(GenericDialog gd) {
        Panel buttons = new Panel();
        buttons.setLayout(new FlowLayout(1, 5, 0));
        this.open = new Button("Open...");
        this.open.addActionListener(this);
        buttons.add(this.open);
        this.save = new Button("Save...");
        this.save.addActionListener(this);
        buttons.add(this.save);
        return buttons;
    }

    double getNum(StringTokenizer st) {
        Double d;
        String token = st.nextToken();
        try {
            d = new Double(token);
        }
        catch (NumberFormatException e) {
            d = null;
        }
        if (d != null) {
            return d;
        }
        return 0.0;
    }

    public boolean convolve(ImageProcessor ip, float[] kernel, int kw, int kh) {
        if (this.canceled) {
            return false;
        }
        if ((kw & 1) != 1 || (kh & 1) != 1) {
            throw new IllegalArgumentException("Kernel width or height not odd");
        }
        int type = ip instanceof ByteProcessor ? 0 : (ip instanceof ShortProcessor ? 1 : (ip instanceof FloatProcessor ? 2 : 3));
        if (type == 3) {
            this.convolveRGB(ip, kernel, kw, kh);
            return !this.canceled;
        }
        ip.setCalibrationTable(null);
        ImageProcessor ip2 = ip.convertToFloat();
        ip2.setMask(ip.getMask());
        ip2.setRoi(ip.getRoi());
        if (kw == 1 || kh == 1) {
            this.convolveFloat1D(ip2, kernel, kw, kh);
        } else {
            this.convolveFloat(ip2, kernel, kw, kh);
        }
        switch (type) {
            case 0: {
                ip2 = ip2.convertToByte(false);
                if (this.nSlices > 1) {
                    byte[] pixels = (byte[])ip.getPixels();
                    byte[] pixels2 = (byte[])ip2.getPixels();
                    System.arraycopy(pixels2, 0, pixels, 0, pixels.length);
                    break;
                }
                ip.setPixels(ip2.getPixels());
                break;
            }
            case 1: {
                ip2 = ip2.convertToShort(false);
                if (this.nSlices > 1) {
                    short[] pixels16 = (short[])ip.getPixels();
                    short[] pixels16b = (short[])ip2.getPixels();
                    System.arraycopy(pixels16b, 0, pixels16, 0, pixels16.length);
                    break;
                }
                ip.setPixels(ip2.getPixels());
                break;
            }
        }
        return !this.canceled;
    }

    public void setNormalize(boolean normalizeKernel) {
        this.normalize = normalizeKernel;
    }

    public void convolveRGB(ImageProcessor ip, float[] kernel, int kw, int kh) {
        int width = ip.getWidth();
        int height = ip.getHeight();
        Rectangle roi = ip.getRoi();
        ImageProcessor mask = ip.getMask();
        int size = width * height;
        if (this.slice == 1) {
            IJ.showStatus("Convolve (red)");
        }
        byte[] r = new byte[size];
        byte[] g = new byte[size];
        byte[] b = new byte[size];
        ((ColorProcessor)ip).getRGB(r, g, b);
        ByteProcessor rip = new ByteProcessor(width, height, r, null);
        ByteProcessor gip = new ByteProcessor(width, height, g, null);
        ByteProcessor bip = new ByteProcessor(width, height, b, null);
        Rectangle rect = ip.getRoi();
        ImageProcessor ip2 = rip.convertToFloat();
        ip2.setMask(mask);
        ip2.setRoi(roi);
        this.convolveFloat(ip2, kernel, kw, kh);
        ImageProcessor r2 = ip2.convertToByte(false);
        if (this.slice == 1) {
            IJ.showStatus("Convolve (green)");
        }
        ip2 = gip.convertToFloat();
        ip2.setMask(mask);
        ip2.setRoi(roi);
        this.convolveFloat(ip2, kernel, kw, kh);
        ImageProcessor g2 = ip2.convertToByte(false);
        ip2 = bip.convertToFloat();
        ip2.setMask(mask);
        ip2.setRoi(roi);
        if (this.slice == 1) {
            IJ.showStatus("Convolve (blue)");
        }
        this.convolveFloat(ip2, kernel, kw, kh);
        ImageProcessor b2 = ip2.convertToByte(false);
        ((ColorProcessor)ip).setRGB((byte[])r2.getPixels(), (byte[])g2.getPixels(), (byte[])b2.getPixels());
    }

    public boolean convolveFloat(ImageProcessor ip, float[] kernel, int kw, int kh) {
        boolean nonRectRoi;
        if (this.canceled) {
            return false;
        }
        int width = ip.getWidth();
        int height = ip.getHeight();
        Rectangle r = ip.getRoi();
        boolean bl = nonRectRoi = ip.getMask() != null;
        if (nonRectRoi) {
            ip.snapshot();
        }
        int x1 = r.x;
        int y1 = r.y;
        int x2 = x1 + r.width;
        int y2 = y1 + r.height;
        int uc = kw / 2;
        int vc = kh / 2;
        float[] pixels = (float[])ip.getPixels();
        float[] pixels2 = (float[])ip.getPixelsCopy();
        double scale = this.getScale(kernel);
        int progress = Math.max((y2 - y1) / 25, 1);
        int xedge = width - uc;
        int yedge = height - vc;
        for (int y = y1; y < y2; ++y) {
            if (y % progress == 0) {
                IJ.showProgress((double)y / (double)height);
                if (IJ.escapePressed()) {
                    this.canceled = true;
                    IJ.beep();
                    IJ.showProgress(1.0);
                    return false;
                }
            }
            for (int x = x1; x < x2; ++x) {
                double sum = 0.0;
                int i = 0;
                boolean edgePixel = y < vc || y >= yedge || x < uc || x >= xedge;
                for (int v = -vc; v <= vc; ++v) {
                    int offset = x + (y + v) * width;
                    for (int u = -uc; u <= uc; ++u) {
                        if (edgePixel) {
                            sum += (double)(this.getPixel(x + u, y + v, pixels2, width, height) * kernel[i++]);
                            continue;
                        }
                        sum += (double)(pixels2[offset + u] * kernel[i++]);
                    }
                }
                pixels[x + y * width] = (float)(sum * scale);
            }
        }
        if (nonRectRoi) {
            ip.reset(ip.getMask());
        }
        IJ.showProgress(1.0);
        return true;
    }

    void convolveFloat1D(ImageProcessor ip, float[] kernel, int kw, int kh) {
        int width = ip.getWidth();
        int height = ip.getHeight();
        Rectangle r = ip.getRoi();
        int x1 = r.x;
        int y1 = r.y;
        int x2 = x1 + r.width;
        int y2 = y1 + r.height;
        int uc = kw / 2;
        int vc = kh / 2;
        float[] pixels = (float[])ip.getPixels();
        float[] pixels2 = (float[])ip.getPixelsCopy();
        double scale = this.getScale(kernel);
        boolean vertical = kw == 1;
        int xedge = width - uc;
        int yedge = height - vc;
        for (int y = y1; y < y2; ++y) {
            for (int x = x1; x < x2; ++x) {
                int offset;
                boolean edgePixel;
                double sum = 0.0;
                int i = 0;
                if (vertical) {
                    edgePixel = y < vc || y >= yedge;
                    offset = x + (y - vc) * width;
                    for (int v = -vc; v <= vc; ++v) {
                        sum = edgePixel ? (sum += (double)(this.getPixel(x + uc, y + v, pixels2, width, height) * kernel[i++])) : (sum += (double)(pixels2[offset + uc] * kernel[i++]));
                        offset += width;
                    }
                } else {
                    edgePixel = x < uc || x >= xedge;
                    offset = x + (y - vc) * width;
                    for (int u = -uc; u <= uc; ++u) {
                        if (edgePixel) {
                            sum += (double)(this.getPixel(x + u, y + vc, pixels2, width, height) * kernel[i++]);
                            continue;
                        }
                        sum += (double)(pixels2[offset + u] * kernel[i++]);
                    }
                }
                pixels[x + y * width] = (float)(sum * scale);
            }
        }
    }

    double getScale(float[] kernel) {
        double scale = 1.0;
        if (this.normalize) {
            double sum = 0.0;
            for (int i = 0; i < kernel.length; ++i) {
                sum += (double)kernel[i];
            }
            if (sum != 0.0) {
                scale = (float)(1.0 / sum);
            }
        }
        return scale;
    }

    private float getPixel(int x, int y, float[] pixels, int width, int height) {
        if (x <= 0) {
            x = 0;
        }
        if (x >= width) {
            x = width - 1;
        }
        if (y <= 0) {
            y = 0;
        }
        if (y >= height) {
            y = height - 1;
        }
        return pixels[x + y * width];
    }

    void save() {
        TextArea ta1 = this.gd.getTextArea1();
        ta1.selectAll();
        String text = ta1.getText();
        ta1.select(0, 0);
        if (text == null || text.length() == 0) {
            return;
        }
        text = text + "\n";
        SaveDialog sd = new SaveDialog("Save as Text...", "kernel", ".txt");
        String name = sd.getFileName();
        if (name == null) {
            return;
        }
        String directory = sd.getDirectory();
        PrintWriter pw = null;
        try {
            FileOutputStream fos = new FileOutputStream(directory + name);
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            pw = new PrintWriter(bos);
        }
        catch (IOException e) {
            IJ.error("" + e);
            return;
        }
        IJ.wait(250);
        pw.print(text);
        pw.close();
    }

    void open() {
        double v;
        int x;
        int y;
        OpenDialog od = new OpenDialog("Open Calibration...", "");
        String directory = od.getDirectory();
        String name = od.getFileName();
        if (name == null) {
            return;
        }
        TextReader tr = new TextReader();
        String path = directory + name;
        ImageProcessor ip = tr.open(path);
        if (ip == null) {
            return;
        }
        int width = ip.getWidth();
        int height = ip.getHeight();
        if ((width & 1) != 1 || width != height) {
            IJ.error("Convolver", "Kernel must be square and have an odd width");
            return;
        }
        StringBuffer sb = new StringBuffer();
        boolean integers = true;
        for (y = 0; y < height; ++y) {
            for (x = 0; x < width; ++x) {
                v = ip.getPixelValue(x, y);
                if ((double)((int)v) == v) continue;
                integers = false;
            }
        }
        for (y = 0; y < height; ++y) {
            for (x = 0; x < width; ++x) {
                if (x != 0) {
                    sb.append(" ");
                }
                v = ip.getPixelValue(x, y);
                if (integers) {
                    sb.append(IJ.d2s(ip.getPixelValue(x, y), 0));
                    continue;
                }
                sb.append("" + ip.getPixelValue(x, y));
            }
            if (y == height - 1) continue;
            sb.append("\n");
        }
        this.gd.getTextArea1().setText(new String(sb));
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        Recorder.disablePathRecording();
        if (source == this.save) {
            this.save();
        } else if (source == this.open) {
            this.open();
        }
    }
}

