/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.masterfs;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.EventListenerList;
import org.netbeans.modules.masterfs.BasedOnResourcePath;
import org.netbeans.modules.masterfs.Cache;
import org.netbeans.modules.masterfs.Delegate;
import org.netbeans.modules.masterfs.InvalidDummy;
import org.netbeans.modules.masterfs.MasterFileSystem;
import org.netbeans.modules.masterfs.MountTable;
import org.netbeans.modules.masterfs.ProviderCall;
import org.netbeans.modules.masterfs.ResourcePath;
import org.netbeans.modules.masterfs.SpecialDelegates;
import org.netbeans.modules.masterfs.SyncSection;
import org.netbeans.modules.masterfs.Utils;
import org.netbeans.modules.masterfs.filebasedfs.FileBasedFileSystem;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.BaseFileObj;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.FileObj;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.FolderObj;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.ReplaceForSerialization;
import org.netbeans.modules.masterfs.filebasedfs.utils.FileInfo;
import org.netbeans.modules.masterfs.providers.ProvidedExtensions;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.Enumerations;
import org.openide.util.Exceptions;
import org.openide.util.Utilities;

final class MasterFileObject
extends BasedOnResourcePath {
    static final long serialVersionUID = -1244651324997356809L;
    private final transient Delegate delegate;
    private transient EventListenerList listeners;
    private static final FileSystem.AtomicAction referenceAction = new AtomicAction(null);
    private transient boolean isFolder;
    static /* synthetic */ Class class$org$netbeans$modules$masterfs$MasterFileObject;
    static /* synthetic */ Class class$org$netbeans$modules$masterfs$MasterFileObject$AtomicAction;

    MasterFileObject(ResourcePath resourceName, FileObject deleg) {
        super(resourceName);
        File f;
        this.isFolder = deleg != null ? deleg.isFolder() : ((f = resourceName.getFile()) != null ? f.isDirectory() : true);
        this.delegate = new Delegate(deleg, new FileChangeListenerImpl(), (FileChangeListener)new FileChangeListenerForVersioning(), this);
        this.delegate.set(deleg);
    }

    public Date lastModified() {
        FileObject deleg = this.getValidOrInvalid(this.getDelegate().getPrefered());
        return deleg.lastModified();
    }

    public boolean isValid() {
        File f;
        FileObject deleg = this.getValidOrInvalid(this.getDelegate().getPrefered());
        File file = f = deleg.isVirtual() ? null : this.getResource().getFile();
        return f != null ? deleg.isValid() && f.exists() : deleg.isValid();
    }

    public Object getAttribute(String attrName) {
        FileObject secDeleg;
        File file;
        if (attrName.equals("FileSystem.rootPath")) {
            return "";
        }
        if (attrName.equals("java.io.File") && (file = this.getResource().getFile()) != null && file.exists()) {
            return file;
        }
        FileObject deleg = this.getValidOrInvalid(this.getDelegate().getPrefered());
        Object attribute = deleg.getAttribute(attrName);
        if (attribute == null && (secDeleg = this.getDelegate().get()) != null && secDeleg.isValid() && secDeleg.isRoot()) {
            attribute = secDeleg.getAttribute(attrName);
        }
        return attribute;
    }

    public void setAttribute(String attrName, Object value) throws IOException {
        FileObject deleg = this.getValidOrInvalid(this.getDelegate().getPrefered());
        deleg.setAttribute(attrName, value);
    }

    public Enumeration getAttributes() {
        FileObject deleg = this.getValidOrInvalid(this.getDelegate().getPrefered());
        return deleg.getAttributes();
    }

    public long getSize() {
        FileObject deleg = this.getValidOrInvalid(this.getDelegate().getPrefered());
        return deleg.getSize();
    }

    public InputStream getInputStream() throws FileNotFoundException {
        FileObject deleg = this.getValidOrInvalid(this.getDelegate().getPrefered());
        return deleg.getInputStream();
    }

    public OutputStream getOutputStream(FileLock lock) throws IOException {
        FileObject deleg = this.getValidOrInvalid(this.getDelegate().getPrefered());
        FileLock lck = deleg.isValid() ? Delegate.getLockForDelegate(lock, deleg) : null;
        return deleg instanceof FileObj ? ((FileObj)deleg).getOutputStream(lck, MasterFileObject.getExtensions(), this) : deleg.getOutputStream(lck);
    }

    public FileLock lock() throws IOException {
        return this.getDelegate().lock();
    }

    public void setImportant(boolean b) {
        FileObject deleg = this.getValidOrInvalid(this.getDelegate().get());
        deleg.setImportant(b);
    }

    public boolean isReadOnly() {
        FileObject deleg = this.getValidOrInvalid(this.getDelegate().getPrefered());
        return deleg.isReadOnly();
    }

    public String getMIMEType() {
        FileObject deleg = this.getValidOrInvalid(this.getDelegate().get());
        return deleg.getMIMEType();
    }

    public boolean existsExt(String ext) {
        FileObject deleg = this.getValidOrInvalid(this.getDelegate().getPrefered());
        return deleg.existsExt(ext);
    }

    public boolean isData() {
        return !this.isFolder();
    }

    public boolean isFolder() {
        return this.isFolder;
    }

    public boolean isVirtual() {
        FileObject deleg = this.getValidOrInvalid(this.getDelegate().get());
        return deleg.isVirtual();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFileChangeListener(FileChangeListener fcl) {
        MasterFileObject masterFileObject = this;
        synchronized (masterFileObject) {
            if (this.listeners == null) {
                this.listeners = new EventListenerList();
            }
            this.listeners.add(FileChangeListener.class, fcl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFileChangeListener(FileChangeListener fcl) {
        MasterFileObject masterFileObject = this;
        synchronized (masterFileObject) {
            if (this.listeners != null) {
                this.listeners.remove(FileChangeListener.class, fcl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileObject[] getChildren() {
        this.enterCriticalSection();
        try {
            FileObject deleg = this.getValidOrInvalid(this.getDelegate().get());
            FileObject[] fileObjectArray = this.transformChildren(deleg.getChildren());
            return fileObjectArray;
        }
        finally {
            this.finishCriticalSection();
        }
    }

    public FileObject getFileObject(String name, String ext) {
        FileObject child;
        FileObject deleg;
        ResourcePath parentResource = this.getResource();
        ResourcePath childResourcePath = parentResource.getChild(name, ext);
        MasterFileObject retVal = null;
        if (childResourcePath != null && parentResource.equals(childResourcePath.getParent()) && (retVal = !((deleg = this.getValidOrInvalid(this.getDelegate().get())) instanceof SpecialDelegates.WinRootVirtual) ? ((child = deleg.getFileObject(name, ext)) != null ? this.transformChild(child) : null) : MasterFileObject.getCache().getOrCreate(childResourcePath)) == null) {
            File f = childResourcePath.getFile();
            boolean canRefresh = true;
            if ((Utilities.isWindows() || Utilities.getOperatingSystem() == 2048) && childResourcePath.getParent().isRoot()) {
                boolean bl = canRefresh = SpecialDelegates.checkValidWindowsDrive(f) != null;
            }
            if (canRefresh && f != null && f.exists()) {
                FileObject child2;
                this.refresh();
                retVal = !(deleg instanceof SpecialDelegates.WinRootVirtual) ? ((child2 = deleg.getFileObject(name, ext)) != null ? this.transformChild(child2) : null) : MasterFileObject.getCache().getOrCreate(childResourcePath);
            }
        }
        return retVal;
    }

    public Enumeration getChildren(boolean rec) {
        Enumeration my = Enumerations.array((Object[])this.getChildren());
        if (!rec) {
            return my;
        }
        return Enumerations.queue((Enumeration)my, (Enumerations.Processor)this.getChildsEnum());
    }

    public Enumeration getFolders(boolean rec) {
        return Enumerations.filter((Enumeration)this.getChildren(rec), (Enumerations.Processor)new AcceptFolders(true));
    }

    public Enumeration getData(boolean rec) {
        return Enumerations.filter((Enumeration)this.getChildren(rec), (Enumerations.Processor)new AcceptFolders(false));
    }

    public FileSystem getFileSystem() throws FileStateInvalidException {
        return MasterFileSystem.getDefault();
    }

    public FileObject createFolder(String name) throws IOException {
        if (name.indexOf(92) != -1 || name.indexOf(47) != -1) {
            throw new IllegalArgumentException(name);
        }
        MasterFileSystem.StatusImpl status = (MasterFileSystem.StatusImpl)MasterFileSystem.getDefault().getStatus();
        ProvidedExtensions extensions = status.getExtensions();
        extensions.beforeCreate(this, name, true);
        FileObject newFolder = null;
        try {
            newFolder = new AtomicAction(this).createFolder(name);
            return newFolder;
        }
        catch (IOException iex) {
            extensions.createFailure(this, name, true);
            throw iex;
        }
    }

    public FileObject createData(String name) throws IOException {
        if (name.indexOf(92) != -1 || name.indexOf(47) != -1) {
            throw new IllegalArgumentException(name);
        }
        MasterFileSystem.StatusImpl status = (MasterFileSystem.StatusImpl)MasterFileSystem.getDefault().getStatus();
        ProvidedExtensions extensions = status.getExtensions();
        extensions.beforeCreate(this, name, false);
        FileObject newFile = null;
        try {
            newFile = new AtomicAction(this).createData(name);
            return newFile;
        }
        catch (IOException iex) {
            extensions.createFailure(this, name, false);
            throw iex;
        }
    }

    public FileObject createData(String name, String ext) throws IOException {
        if (name.indexOf(92) != -1 || name.indexOf(47) != -1) {
            throw new IllegalArgumentException(name);
        }
        MasterFileSystem.StatusImpl status = (MasterFileSystem.StatusImpl)MasterFileSystem.getDefault().getStatus();
        ProvidedExtensions extensions = status.getExtensions();
        extensions.beforeCreate(this, FileInfo.composeName(name, ext), false);
        FileObject newFile = null;
        try {
            newFile = new AtomicAction(this).createData(name, ext);
            return newFile;
        }
        catch (IOException iex) {
            extensions.createFailure(this, FileInfo.composeName(name, ext), false);
            throw iex;
        }
    }

    public FileObject copy(FileObject target, String name, String ext) throws IOException {
        return new AtomicAction(this).copy(target, name, ext);
    }

    public void delete(FileLock lock) throws IOException {
        FileObject deleg;
        if ((this.getDelegate().hasMountAbleFlag() || MountTable.getDefault().getMountedFileSystem(this.getResource().getNormalizedPath()) != null) && (deleg = this.getDelegate().get()) != null && deleg.isRoot()) {
            MountTable.getDefault().unmount(this.getDelegateFileSystem());
        }
        MasterFileSystem.StatusImpl status = (MasterFileSystem.StatusImpl)MasterFileSystem.getDefault().getStatus();
        ProvidedExtensions extensions = status.getExtensions();
        extensions.beforeDelete(this);
        IOException toThrow = null;
        try {
            new AtomicAction(this).delete(lock);
        }
        catch (IOException iex) {
            toThrow = iex;
            throw iex;
        }
        finally {
            if (toThrow == null) {
                extensions.deleteSuccess(this);
            } else {
                extensions.deleteFailure(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileObject move(FileLock lock, FileObject target, String name, String ext) throws IOException {
        this.enterExclusiveCriticalSection();
        try {
            if (this.getParent().equals(target)) {
                this.rename(lock, name, ext);
                MasterFileObject masterFileObject = this;
                return masterFileObject;
            }
            FileObject fileObject = new AtomicAction(this).move(lock, target, name, ext);
            return fileObject;
        }
        finally {
            this.finishExclusiveCriticalSection();
        }
    }

    private FileObject superMove(FileLock lock, FileObject target, String name, String ext) throws IOException {
        return super.move(lock, target, name, ext);
    }

    public void refresh(boolean expected) {
        try {
            if (expected) {
                new AtomicAction(this).refreshExpected();
            } else {
                new AtomicAction(this).refresh();
            }
        }
        catch (IOException e) {
            Exceptions.printStackTrace((Throwable)e);
        }
    }

    public FileObject getParent() {
        MasterFileObject retVal = null;
        ResourcePath parentRes = this.getResource().getParent();
        if (parentRes != null) {
            parentRes = parentRes.getParent() == null ? ResourcePath.getRoot() : parentRes;
            retVal = Cache.getDefault().getOrCreate(parentRes);
            if (retVal == null) {
                retVal = Cache.getDefault().getValidOrInvalid(parentRes);
            }
        }
        return retVal;
    }

    public void rename(FileLock lock, String name, String ext) throws IOException {
        FileObject deleg = null;
        ProvidedExtensions.IOHandler renameHandler = this.getRenameHandler(name, ext);
        this.enterCriticalSection();
        try {
            deleg = this.getValidOrInvalid(this.getDelegate().get());
            if (this.isReadOnly()) {
                Utils.throwIOException("EXC_CannotRename", new Object[]{this.getPath(), MasterFileObject.getHFs().getDisplayName()});
            }
            ResourcePath oldResName = this.getResource();
            this.setResource(oldResName.getParent().getChild(name, ext));
            Cache.getDefault().replace(oldResName.getNormalizedPath(), this);
            if (this.isRoot() || !deleg.isRoot()) {
                try {
                    FileLock lck = Delegate.getLockForDelegate(lock, deleg);
                    if (renameHandler == null) {
                        deleg.rename(lck, name, ext);
                    } else {
                        ((BaseFileObj)deleg).rename(lck, name, ext, renameHandler);
                    }
                    MountTable.getDefault();
                    MountTable.renameCachedFileObjects(oldResName.getNormalizedPath(), this.getResource().getNormalizedPath());
                    return;
                }
                catch (IOException iex) {
                    this.setResource(oldResName);
                    throw iex;
                }
            }
            throw new IOException("Not implemented yet");
        }
        finally {
            this.finishCriticalSection();
        }
    }

    private ProvidedExtensions.IOHandler getRenameHandler(String name, String ext) {
        ProvidedExtensions pe = ((MasterFileSystem.StatusImpl)MasterFileSystem.getDefault().getStatus()).getExtensions();
        File fileToRename = this.getResource().getFile();
        return pe.getRenameHandler(fileToRename, FileInfo.composeName(name, ext));
    }

    public final Object writeReplace() {
        return new Replace(this.getPath());
    }

    Delegate getDelegate() {
        return this.delegate;
    }

    private static MasterFileSystem getHFs() {
        return MasterFileSystem.getDefault();
    }

    private static Cache getCache() {
        return Cache.getDefault();
    }

    private MasterFileObject[] transformChildren(FileObject[] delegs) {
        ArrayList<FileObject> aList = new ArrayList<FileObject>(delegs.length);
        for (int i = 0; i < delegs.length; ++i) {
            FileObject hfo = this.transformChild(delegs[i]);
            if (hfo == null) continue;
            aList.add(hfo);
        }
        MasterFileObject[] retVal = new MasterFileObject[aList.size()];
        aList.toArray(retVal);
        return retVal;
    }

    private FileObject transformChild(FileObject deleg) {
        MasterFileObject hfo;
        if (deleg instanceof InvalidDummy) {
            InvalidDummy res = (InvalidDummy)deleg;
            hfo = MasterFileObject.getCache().getOrCreate(res.getResource());
        } else {
            ResourcePath res = this.getResource().getChild(deleg.getNameExt());
            hfo = MountTable.getDefault().getMountedFileSystem(res.getNormalizedPath()) != null ? MasterFileObject.getCache().getOrCreate(res, null) : MasterFileObject.getCache().getOrCreate(res, deleg);
        }
        return hfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryAutoMount() {
        SyncSection.getDefault().enterExclusiveSection();
        try {
            FileSystem fs;
            FileObject deleg = this.getDelegate().get();
            if (this.getDelegate().hasMountAbleFlag() && deleg != null && !deleg.isRoot() && (fs = ProviderCall.createFileSystem(this.getPath())) != null) {
                try {
                    MountTable.getDefault().mount(this.getPath(), fs);
                }
                catch (IOException iex) {
                    Exceptions.printStackTrace((Throwable)iex);
                }
            }
        }
        finally {
            SyncSection.getDefault().finishExclusiveSection();
        }
    }

    private MasterFileObject eventFileToMasterFileObject(FileEvent fe) {
        FileObject file = fe.getFile();
        if (file != null) {
            MasterFileObject file56995;
            MasterFileObject dFile = null;
            ResourcePath child = this.getResource().getChild(file.getNameExt());
            dFile = MasterFileObject.getCache().get(child);
            if (file.isVirtual() && !file.isValid() && dFile == null && (file56995 = MasterFileObject.getCache().getValidOrInvalid(child)) != null && file56995.isVirtual()) {
                dFile = file56995;
            }
            dFile = dFile != null ? dFile : MasterFileObject.getCache().getOrCreate(child);
            dFile = dFile != null ? dFile : MasterFileObject.getCache().getValidOrInvalid(child);
            dFile = dFile != null ? dFile : this;
            return dFile;
        }
        return this;
    }

    private Enumerations.Processor getChildsEnum() {
        return new Enumerations.Processor(){

            public Object process(Object o, Collection toAdd) {
                FileObject fo = (FileObject)o;
                if (fo != null) {
                    toAdd.addAll(Arrays.asList(fo.getChildren()));
                }
                return fo;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Enumeration getEnumOfListeners() {
        Object[] fcls;
        MasterFileObject masterFileObject = this;
        synchronized (masterFileObject) {
            if (this.listeners == null) {
                return Enumerations.empty();
            }
            fcls = this.listeners.getListenerList();
        }
        if (fcls == null || fcls.length == 0) {
            return Enumerations.empty();
        }
        class OnlyListeners
        implements Enumerations.Processor {
            OnlyListeners() {
            }

            public Object process(Object o, Collection toAdd) {
                if (o instanceof FileChangeListener) {
                    return o;
                }
                return null;
            }
        }
        return Enumerations.filter((Enumeration)Enumerations.array((Object[])fcls), (Enumerations.Processor)new OnlyListeners());
    }

    FileSystem getDelegateFileSystem() {
        FileObject deleg = this.getDelegate().get();
        try {
            return deleg != null ? deleg.getFileSystem() : null;
        }
        catch (FileStateInvalidException fsx) {
            Logger.getAnonymousLogger().log(Level.WARNING, null, fsx);
            return null;
        }
    }

    static void refreshAfterMount(FileObject newDelegate, FileObject oldDelegate, MasterFileObject hfo) {
        MasterFileObject parent;
        ResourcePath parentRes = hfo.getResource().getParent();
        MasterFileObject masterFileObject = parent = parentRes != null ? MasterFileObject.getCache().get(parentRes) : null;
        if (newDelegate != null) {
            boolean isRootFileSystem = false;
            try {
                isRootFileSystem = newDelegate.getFileSystem() instanceof FileBasedFileSystem;
            }
            catch (FileStateInvalidException fsx) {
                Logger.getAnonymousLogger().log(Level.WARNING, null, fsx);
            }
            if (newDelegate.isFolder() && !isRootFileSystem) {
                HashSet<FileObject> oldChildren = new HashSet<FileObject>(Arrays.asList(oldDelegate.getChildren()));
                HashSet<FileObject> newChildren = new HashSet<FileObject>(Arrays.asList(newDelegate.getChildren()));
                MasterFileObject.retainOnlyDifferent(oldChildren, newChildren);
                MasterFileObject.handleCreated(newChildren, hfo);
            }
        } else {
            MasterFileObject.handleDeleted(hfo, parent);
        }
    }

    private static void handleDeleted(MasterFileObject hfo, MasterFileObject parent) {
        hfo.fireFileDeletedEvent(hfo.getEnumOfListeners(), new FileEvent((FileObject)hfo));
        if (parent != null) {
            parent.fireFileDeletedEvent(parent.getEnumOfListeners(), new FileEvent((FileObject)parent, (FileObject)hfo));
        }
    }

    private static void handleChanged(MasterFileObject hfo, MasterFileObject parent) {
        hfo.fireFileChangedEvent(hfo.getEnumOfListeners(), new FileEvent((FileObject)hfo));
        if (parent != null) {
            parent.fireFileChangedEvent(parent.getEnumOfListeners(), new FileEvent((FileObject)parent, (FileObject)hfo));
        }
    }

    private static void handleCreated(Set newChildren, MasterFileObject hfo) {
        Iterator addIt = newChildren.iterator();
        while (addIt.hasNext()) {
            FileObject addDeleg = (FileObject)addIt.next();
            ResourcePath name = hfo.getResource().getChild(addDeleg.getNameExt());
            MasterFileObject addHfo = MasterFileObject.getCache().get(name);
            boolean resetDelg = false;
            if (addHfo == null) {
                addHfo = MasterFileObject.getCache().getOrCreate(name, addDeleg);
                resetDelg = true;
            }
            if (addHfo.isFolder()) {
                hfo.fireFileFolderCreatedEvent(hfo.getEnumOfListeners(), new FileEvent((FileObject)hfo, (FileObject)addHfo));
            } else {
                hfo.fireFileDataCreatedEvent(hfo.getEnumOfListeners(), new FileEvent((FileObject)hfo, (FileObject)addHfo));
            }
            if (!resetDelg) continue;
            addHfo.getDelegate().reset(addHfo.getResource());
        }
    }

    private static void retainOnlyDifferent(Set oldChildren, Set newChildren) {
        Iterator oldIt = oldChildren.iterator();
        Iterator newIt = newChildren.iterator();
        while (oldIt.hasNext() && newIt.hasNext()) {
            FileObject oldFo = (FileObject)oldIt.next();
            while (newIt.hasNext()) {
                FileObject newFo = (FileObject)newIt.next();
                if (!newFo.getNameExt().equals(oldFo.getNameExt())) continue;
                newIt.remove();
                oldIt.remove();
                break;
            }
            newIt = newChildren.iterator();
        }
    }

    private FileObject getValidOrInvalid(FileObject deleg) {
        return MasterFileObject.getValidOrInvalid(deleg, this);
    }

    private static FileObject getValidOrInvalid(FileObject deleg, MasterFileObject hfo) {
        if (deleg == null) {
            deleg = new InvalidDummy(hfo.getResource());
        }
        return deleg;
    }

    private void finishCriticalSection() {
        SyncSection.getDefault().finishSection();
    }

    private void enterCriticalSection() {
        SyncSection.getDefault().enterSection();
    }

    private void finishExclusiveCriticalSection() {
        SyncSection.getDefault().finishExclusiveSection();
    }

    private void enterExclusiveCriticalSection() {
        SyncSection.getDefault().enterExclusiveSection();
    }

    public boolean canWrite() {
        return !this.isReadOnly();
    }

    private static ProvidedExtensions.DeleteHandler getDeleteHandler(File f) {
        return MasterFileObject.getExtensions().getDeleteHandler(f);
    }

    private static ProvidedExtensions getExtensions() {
        return ((MasterFileSystem.StatusImpl)MasterFileSystem.getDefault().getStatus()).getExtensions();
    }

    private final class AcceptFolders
    implements Enumerations.Processor {
        private boolean folders;

        public AcceptFolders(boolean folders) {
            this.folders = folders;
        }

        public Object process(Object o, Collection nothing) {
            FileObject fo = (FileObject)o;
            if (this.folders) {
                return fo.isFolder() ? fo : null;
            }
            return fo.isData() ? fo : null;
        }
    }

    private static final class AtomicAction
    implements FileSystem.AtomicAction {
        private int operation;
        private final MasterFileObject hfoI;
        private String nameI;
        private String extI;
        private FileObject targetI;
        private FileLock fLockI;
        private FileObject retVal;
        private static final int CREATE_DATA_OP = 0;
        private static final int CREATE_FOLDER_OP = 1;
        private static final int CREATE_DATA_EXT_OP = 2;
        private static final int COPY_OP = 3;
        private static final int REFRESH_EXPECTED_OP = 4;
        private static final int REFRESH_OP = 5;
        private static final int DELETE_OP = 6;
        private static final int MOVE_OP = 7;
        static final /* synthetic */ boolean $assertionsDisabled;

        private AtomicAction(MasterFileObject hfo) {
            this.hfoI = hfo;
        }

        private FileObject createFolder(String name) throws IOException {
            this.init(name);
            this.operation = 1;
            MasterFileObject.getHFs().runAtomicAction(this);
            return this.retVal;
        }

        FileObject createData(String name) throws IOException {
            this.init(name);
            this.operation = 0;
            MasterFileObject.getHFs().runAtomicAction(this);
            return this.retVal;
        }

        FileObject createData(String name, String ext) throws IOException {
            this.init(name, ext);
            this.operation = 2;
            MasterFileObject.getHFs().runAtomicAction(this);
            return this.retVal;
        }

        FileObject copy(FileObject target, String name, String ext) throws IOException {
            this.init(target, name, ext);
            this.operation = 3;
            MasterFileObject.getHFs().runAtomicAction(this);
            return this.retVal;
        }

        void delete(FileLock fLock) throws IOException {
            this.init(fLock, null, null, null);
            this.operation = 6;
            MasterFileObject.getHFs().runAtomicAction(this);
        }

        FileObject move(FileLock lock, FileObject target, String name, String ext) throws IOException {
            this.init(lock, target, name, ext);
            this.operation = 7;
            MasterFileObject.getHFs().runAtomicAction(this);
            return this.retVal;
        }

        void refreshExpected() throws IOException {
            this.operation = 4;
            MasterFileObject.getHFs().runAtomicAction(this);
        }

        void refresh() throws IOException {
            this.operation = 5;
            MasterFileObject.getHFs().runAtomicAction(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() throws IOException {
            this.hfoI.enterCriticalSection();
            try {
                switch (this.operation) {
                    case 1: {
                        this.createFolder();
                        return;
                    }
                    case 0: {
                        this.createData();
                        return;
                    }
                    case 2: {
                        this.createDataExt();
                        return;
                    }
                    case 3: {
                        this.copy();
                        return;
                    }
                    case 4: {
                        this.iRefreshExpected();
                        return;
                    }
                    case 5: {
                        this.iRefresh();
                        return;
                    }
                    case 6: {
                        this.delete();
                        return;
                    }
                    case 7: {
                        this.move();
                        return;
                    }
                }
                return;
            }
            finally {
                this.hfoI.finishCriticalSection();
            }
        }

        private void init(FileLock fLock, FileObject target, String name, String ext) {
            this.init(target, name, ext);
            this.fLockI = fLock;
        }

        private void init(FileObject target, String name, String ext) {
            this.init(name, ext);
            this.targetI = target;
        }

        private void init(String name, String ext) {
            this.init(name);
            this.extI = ext;
        }

        private void init(String name) {
            this.nameI = name;
            this.retVal = null;
        }

        private void createFolder() throws IOException {
            FileObject deleg = MasterFileObject.getValidOrInvalid(this.hfoI.getDelegate().get(), this.hfoI);
            deleg.createFolder(this.nameI);
            this.retVal = MasterFileObject.getCache().getOrCreate(this.hfoI.getResource().getChild(this.nameI));
        }

        private void createData() throws IOException {
            FileObject deleg = MasterFileObject.getValidOrInvalid(this.hfoI.getDelegate().get(), this.hfoI);
            deleg.createData(this.nameI);
            this.retVal = MasterFileObject.getCache().getOrCreate(this.hfoI.getResource().getChild(this.nameI));
        }

        private void createDataExt() throws IOException {
            FileObject deleg = MasterFileObject.getValidOrInvalid(this.hfoI.getDelegate().get(), this.hfoI);
            deleg.createData(this.nameI, this.extI);
            this.retVal = MasterFileObject.getCache().getOrCreate(this.hfoI.getResource().getChild(this.nameI, this.extI));
        }

        private void copy() throws IOException {
            FileObject deleg = MasterFileObject.getValidOrInvalid(this.hfoI.getDelegate().getPrefered(), this.hfoI);
            this.retVal = deleg.copy(this.targetI, this.nameI, this.extI);
        }

        private void delete() throws IOException {
            FileObject deleg = MasterFileObject.getValidOrInvalid(this.hfoI.getDelegate().get(), this.hfoI);
            FileLock lck = Delegate.getLockForDelegate(this.fLockI, deleg);
            if (deleg instanceof BaseFileObj) {
                ((BaseFileObj)deleg).delete(lck, MasterFileObject.getDeleteHandler(((BaseFileObj)deleg).getFileName().getFile()));
            } else {
                deleg.delete(lck);
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        private void move() throws IOException {
            ProvidedExtensions.IOHandler moveHandler = this.getMoveHandler();
            if (moveHandler == null) {
                this.retVal = this.hfoI.superMove(this.fLockI, this.targetI, this.nameI, this.extI);
                return;
            }
            if (this.targetI instanceof MasterFileObject) {
                BaseFileObj deleg = (BaseFileObj)MasterFileObject.getValidOrInvalid(this.hfoI.getDelegate().get(), this.hfoI);
                FileLock lck = Delegate.getLockForDelegate(this.fLockI, deleg);
                MasterFileObject targetMfo = (MasterFileObject)this.targetI;
                FolderObj targetDeleg = (FolderObj)MasterFileObject.getValidOrInvalid(targetMfo.getDelegate().get(), targetMfo);
                deleg.move(lck, targetDeleg, this.nameI, this.extI, moveHandler);
                this.retVal = MasterFileObject.getCache().getOrCreate(targetMfo.getResource().getChild(this.nameI, this.extI));
                FileUtil.copyAttributes((FileObject)this.hfoI, (FileObject)this.retVal);
                return;
            }
            moveHandler.handle();
            this.hfoI.refresh(true);
            this.targetI.refresh(true);
            this.retVal = this.targetI.getFileObject(this.nameI, this.extI);
            if (!$assertionsDisabled && this.retVal == null) {
                throw new AssertionError();
            }
            FileUtil.copyAttributes((FileObject)this.hfoI, (FileObject)this.retVal);
        }

        private ProvidedExtensions.IOHandler getMoveHandler() {
            ProvidedExtensions pe = ((MasterFileSystem.StatusImpl)MasterFileSystem.getDefault().getStatus()).getExtensions();
            String fName = FileInfo.composeName(this.nameI, this.extI);
            File from = this.hfoI.getResource().getFile();
            File to = null;
            to = this.targetI instanceof MasterFileObject ? ((MasterFileObject)this.targetI).getResource().getChild(fName).getFile() : FileUtil.toFile((FileObject)this.targetI);
            return pe.getMoveHandler(from, to);
        }

        private void iRefreshExpected() {
            FileObject deleg = MasterFileObject.getValidOrInvalid(this.hfoI.getDelegate().get(), this.hfoI);
            if (deleg != null) {
                deleg.refresh(true);
            }
        }

        private void iRefresh() {
            FileObject deleg = MasterFileObject.getValidOrInvalid(this.hfoI.getDelegate().get(), this.hfoI);
            if (deleg != null) {
                deleg.refresh(false);
            }
        }

        public boolean equals(Object obj) {
            return obj instanceof AtomicAction;
        }

        public int hashCode() {
            return (class$org$netbeans$modules$masterfs$MasterFileObject$AtomicAction == null ? (class$org$netbeans$modules$masterfs$MasterFileObject$AtomicAction = MasterFileObject.class$("org.netbeans.modules.masterfs.MasterFileObject$AtomicAction")) : class$org$netbeans$modules$masterfs$MasterFileObject$AtomicAction).hashCode();
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$masterfs$MasterFileObject == null ? (class$org$netbeans$modules$masterfs$MasterFileObject = MasterFileObject.class$("org.netbeans.modules.masterfs.MasterFileObject")) : class$org$netbeans$modules$masterfs$MasterFileObject).desiredAssertionStatus();
        }
    }

    private final class FileChangeListenerForVersioning
    extends FileChangeAdapter {
        private FileChangeListenerForVersioning() {
        }

        public void fileDataCreated(FileEvent fe) {
            MasterFileSystem.StatusImpl status = (MasterFileSystem.StatusImpl)MasterFileSystem.getDefault().getStatus();
            ProvidedExtensions extensions = status.getExtensions();
            extensions.createSuccess(fe.getFile());
        }

        public void fileFolderCreated(FileEvent fe) {
            MasterFileSystem.StatusImpl status = (MasterFileSystem.StatusImpl)MasterFileSystem.getDefault().getStatus();
            ProvidedExtensions extensions = status.getExtensions();
            extensions.createSuccess(fe.getFile());
        }
    }

    private final class FileChangeListenerImpl
    implements FileChangeListener {
        private FileChangeListenerImpl() {
        }

        public void fileDataCreated(FileEvent fe) {
            MasterFileObject eventFile = MasterFileObject.this.eventFileToMasterFileObject(fe);
            FileEvent fe2Fire = new FileEvent((FileObject)MasterFileObject.this, (FileObject)eventFile, fe.isExpected());
            FileObject eventFileDelegate = eventFile.getDelegate().get();
            FileObject meDelegate = MasterFileObject.this.getDelegate().get();
            if (eventFileDelegate == fe.getFile() && meDelegate == fe.getSource()) {
                MasterFileObject.this.fireFileDataCreatedEvent(MasterFileObject.this.getEnumOfListeners(), fe2Fire);
            }
        }

        public void fileFolderCreated(FileEvent fe) {
            MasterFileObject eventFile = MasterFileObject.this.eventFileToMasterFileObject(fe);
            FileEvent fe2Fire = new FileEvent((FileObject)MasterFileObject.this, (FileObject)eventFile, fe.isExpected());
            FileObject eventFileDelegate = eventFile.getDelegate().get();
            FileObject meDelegate = MasterFileObject.this.getDelegate().get();
            if (eventFileDelegate == fe.getFile() && meDelegate == fe.getSource()) {
                MasterFileObject.this.fireFileFolderCreatedEvent(MasterFileObject.this.getEnumOfListeners(), fe2Fire);
            }
        }

        public void fileDeleted(FileEvent fe) {
            MasterFileObject eventFile = MasterFileObject.this.eventFileToMasterFileObject(fe);
            FileEvent fe2Fire = new FileEvent((FileObject)MasterFileObject.this, (FileObject)eventFile, fe.isExpected());
            FileObject eventFileDelegate = eventFile.getDelegate().get();
            FileObject meDelegate = MasterFileObject.this.getDelegate().get();
            if (eventFileDelegate == fe.getFile() && meDelegate == fe.getSource()) {
                MasterFileObject.this.fireFileDeletedEvent(MasterFileObject.this.getEnumOfListeners(), fe2Fire);
            }
        }

        public void fileChanged(FileEvent fe) {
            MasterFileObject eventFile = MasterFileObject.this.eventFileToMasterFileObject(fe);
            FileEvent fe2Fire = new FileEvent((FileObject)MasterFileObject.this, (FileObject)eventFile, fe.isExpected());
            FileObject eventFileDelegate = eventFile.getDelegate().get();
            FileObject meDelegate = MasterFileObject.this.getDelegate().get();
            if (eventFileDelegate == fe.getFile() && meDelegate == fe.getSource()) {
                MasterFileObject.this.fireFileChangedEvent(MasterFileObject.this.getEnumOfListeners(), fe2Fire);
            }
        }

        public void fileRenamed(FileRenameEvent fe) {
            String name = fe.getName();
            String ext = fe.getExt();
            MasterFileObject eventFile = MasterFileObject.this.eventFileToMasterFileObject((FileEvent)fe);
            FileRenameEvent fe2Fire = new FileRenameEvent((FileObject)MasterFileObject.this, (FileObject)eventFile, name, ext);
            FileObject eventFileDelegate = eventFile.getDelegate().get();
            FileObject meDelegate = MasterFileObject.this.getDelegate().get();
            if (eventFileDelegate == fe.getFile() && meDelegate == fe.getSource()) {
                MasterFileObject.this.fireFileRenamedEvent(MasterFileObject.this.getEnumOfListeners(), fe2Fire);
            }
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
            MasterFileObject eventFile = MasterFileObject.this.eventFileToMasterFileObject((FileEvent)fe);
            FileAttributeEvent fe2Fire = new FileAttributeEvent((FileObject)MasterFileObject.this, (FileObject)eventFile, fe.getName(), fe.getOldValue(), fe.getNewValue());
            FileObject eventFileDelegate = eventFile.getDelegate().get();
            FileObject meDelegate = MasterFileObject.this.getDelegate().get();
            if (eventFileDelegate == fe.getFile() && meDelegate == fe.getSource()) {
                MasterFileObject.this.fireFileAttributeChangedEvent(MasterFileObject.this.getEnumOfListeners(), fe2Fire);
            }
        }
    }

    public static final class Replace
    implements Serializable {
        static final long serialVersionUID = -8552332135435542113L;
        private final String path;

        public Replace(String path) {
            this.path = path;
        }

        public Object readResolve() {
            FileObject retVal;
            MasterFileSystem fs = MasterFileSystem.getDefault();
            FileObject fileObject = retVal = fs == null ? null : fs.findResource(this.path);
            if (retVal == null) {
                retVal = (FileObject)new ReplaceForSerialization(new File(this.path)).readResolve();
            }
            return retVal;
        }
    }
}

