/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.masterfs;

import java.io.File;
import java.util.Enumeration;
import java.util.StringTokenizer;
import org.netbeans.modules.masterfs.filebasedfs.utils.FileInfo;
import org.openide.util.Utilities;

final class ResourcePath {
    private final String resourcePath;
    private static final ResourcePath root;
    static final /* synthetic */ boolean $assertionsDisabled;

    ResourcePath(StringBuilder sb) {
        this.resourcePath = sb.toString();
    }

    ResourcePath(String resourcePath) {
        if (!$assertionsDisabled && resourcePath == null) {
            throw new AssertionError();
        }
        this.resourcePath = ResourcePath.getNormalizedPath(resourcePath);
        if (!($assertionsDisabled || this.resourcePath.length() > 0 && this.resourcePath.charAt(0) == '/')) {
            throw new AssertionError();
        }
    }

    static ResourcePath getRoot() {
        return root;
    }

    boolean isRoot() {
        return this.getParent() == null;
    }

    File getFile() {
        if (Utilities.isWindows() || Utilities.getOperatingSystem() == 2048) {
            File retVal = null;
            if (!this.isRoot()) {
                String filePath = this.resourcePath.substring(1).replace('/', File.separatorChar);
                if (this.getParent().isRoot() && !filePath.endsWith("/")) {
                    filePath = filePath + "/";
                }
                retVal = new File(filePath);
            }
            return retVal;
        }
        return new File(this.resourcePath);
    }

    final String getNormalizedPath() {
        return this.resourcePath;
    }

    Enumeration getElements() {
        StringTokenizer sTokens = new StringTokenizer(this.resourcePath, "/");
        return sTokens;
    }

    ResourcePath getChild(String nameExt) {
        ResourcePath retVal = null;
        StringBuilder sb = new StringBuilder(this.resourcePath);
        if (!this.resourcePath.endsWith("/")) {
            sb.append('/');
        }
        sb.append(nameExt);
        retVal = new ResourcePath(sb);
        return retVal;
    }

    ResourcePath getChild(String name, String ext) {
        StringBuilder sb = new StringBuilder(this.resourcePath);
        if (!this.resourcePath.endsWith("/")) {
            sb.append('/');
        }
        sb.append(name);
        if (ext != null && ext.length() != 0) {
            sb.append('.').append(ext);
        }
        return new ResourcePath(sb.toString());
    }

    ResourcePath getParent() {
        int idx = this.resourcePath.lastIndexOf(47);
        if (idx == 0 && this.resourcePath.length() == 1) {
            return null;
        }
        return new ResourcePath(idx <= 0 ? "/" : this.resourcePath.substring(0, idx));
    }

    String getExt() {
        return FileInfo.getExt(this.getNameExt());
    }

    String getName() {
        return FileInfo.getName(this.getNameExt());
    }

    String getNameExt() {
        int idx0 = this.resourcePath.lastIndexOf(47);
        if (!$assertionsDisabled && idx0 == -1) {
            throw new AssertionError((Object)this.resourcePath);
        }
        return this.resourcePath.substring(++idx0);
    }

    String getPath() {
        return this.resourcePath.substring(1);
    }

    static String getNormalizedPath(String resPath) {
        if (resPath == null) {
            return resPath;
        }
        if (!(resPath = resPath.replace('\\', '/')).startsWith("/")) {
            resPath = "/" + resPath;
        }
        if (resPath.endsWith("/") && resPath.length() != "/".length()) {
            resPath = resPath.substring(0, resPath.length() - 1);
        }
        return resPath;
    }

    public int hashCode() {
        return this.resourcePath.hashCode();
    }

    public boolean equals(Object obj) {
        String resPath = null;
        if (obj instanceof String) {
            resPath = (String)obj;
        } else if (obj instanceof ResourcePath) {
            resPath = ((ResourcePath)obj).getNormalizedPath();
        }
        return this.resourcePath.equals(resPath);
    }

    public String toString() {
        return this.getNormalizedPath();
    }

    static {
        $assertionsDisabled = !ResourcePath.class.desiredAssertionStatus();
        root = new ResourcePath("/");
    }
}

