/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.masterfs.filebasedfs.fileobjects;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.WeakHashMap;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.WriteLockFactory;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.WriteLockUtils;
import org.netbeans.modules.masterfs.filebasedfs.utils.FSException;
import org.openide.filesystems.FileAlreadyLockedException;
import org.openide.filesystems.FileLock;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class WriteLock
extends FileLock {
    static final Map allLocks;
    private File lockFile;
    static final /* synthetic */ boolean $assertionsDisabled;

    static WriteLock tryLock(File file) throws IOException {
        return WriteLock.getInstance(file, false);
    }

    static WriteLock tryNioLock(File file) throws IOException {
        return WriteLock.getInstance(file, true);
    }

    static WriteLock tryLightWeightLock(File file) throws IOException {
        return WriteLock.getLightWeightInstance(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void relock(File theOld, File theNew) {
        ArrayList<WriteLock> l = new ArrayList<WriteLock>();
        Set s = allLocks.keySet();
        Map map = allLocks;
        synchronized (map) {
            Iterator it = s.iterator();
            while (it.hasNext()) {
                Reference r;
                WriteLock wl;
                File f = (File)it.next();
                File nLockFile = null;
                String relPath = WriteLock.getRelativePath(theOld, f);
                if (relPath != null) {
                    nLockFile = new File(theNew, relPath);
                } else if (f.equals(WriteLockUtils.getAssociatedLockFile(theOld))) {
                    nLockFile = WriteLockUtils.getAssociatedLockFile(theNew);
                }
                if (nLockFile == null || (wl = (WriteLock)((Object)(r = (Reference)allLocks.get(f)).get())) == null) continue;
                it.remove();
                wl.lockFile = nLockFile;
                l.add(wl);
            }
        }
        Iterator it2 = l.iterator();
        while (it2.hasNext()) {
            WriteLock wl = (WriteLock)((Object)it2.next());
            allLocks.put(wl.lockFile, new WeakReference<WriteLock>(wl));
        }
    }

    private static String getRelativePath(File dir, File file) {
        File tempFile;
        Stack<String> stack = new Stack<String>();
        for (tempFile = file; tempFile != null && !tempFile.equals(dir); tempFile = tempFile.getParentFile()) {
            stack.push(tempFile.getName());
        }
        if (tempFile == null) {
            return null;
        }
        StringBuilder retval = new StringBuilder();
        while (!stack.isEmpty()) {
            retval.append((String)stack.pop());
            if (stack.isEmpty()) continue;
            retval.append("/");
        }
        return retval.toString();
    }

    private static WriteLock getLightWeightInstance(File file) throws IOException {
        File lckFile = WriteLockUtils.getAssociatedLockFile(file);
        boolean isAlreadyLocked = allLocks.keySet().contains(lckFile);
        if (isAlreadyLocked) {
            throw new FileAlreadyLockedException(NbBundle.getMessage((Class)WriteLock.class, (String)"EXC_FileAlreadyLocked", (Object)file.getAbsolutePath()));
        }
        return new WriteLock(lckFile);
    }

    private static WriteLock getInstance(File file, boolean nioLock) throws IOException {
        boolean isCreated = false;
        IOException toFire = null;
        File lckFile = WriteLockUtils.getAssociatedLockFile(file);
        if (!lckFile.exists()) {
            isCreated = true;
        }
        RandomAccessFile raf = WriteLock.getAccessToFile(lckFile);
        if (!$assertionsDisabled && !lckFile.exists()) {
            throw new AssertionError();
        }
        FileChannel channel = raf.getChannel();
        if (channel != null && channel.isOpen()) {
            try {
                String content = WriteLockUtils.getContentOfLckFile(lckFile, channel);
                if (content == null && (isCreated || lckFile.length() == 0L)) {
                    if (!$assertionsDisabled && lckFile.length() != 0L) {
                        throw new AssertionError();
                    }
                    content = WriteLockUtils.writeContentOfLckFile(lckFile, channel);
                }
                if (content != null && !allLocks.keySet().contains(new File(content))) {
                    if (channel != null && channel.isOpen() && !nioLock) {
                        channel.close();
                    }
                    return nioLock ? new NioLock(lckFile, channel, channel.tryLock()) : new WriteLock(lckFile);
                }
            }
            catch (IOException iex) {
                toFire = iex;
            }
        }
        if (channel != null && channel.isOpen()) {
            channel.close();
        }
        if (isCreated && lckFile.exists()) {
            lckFile.delete();
        }
        if (toFire == null) {
            toFire = lckFile.exists() ? new FileAlreadyLockedException(NbBundle.getMessage((Class)WriteLock.class, (String)"EXC_FileLockAlreadyExists", (Object)file.getAbsolutePath(), (Object)lckFile.getAbsolutePath())) : new FileAlreadyLockedException(NbBundle.getMessage((Class)WriteLock.class, (String)"EXC_FileAlreadyLocked", (Object)file.getAbsolutePath()));
        }
        FSException.annotateException(toFire);
        throw toFire;
    }

    private static RandomAccessFile getAccessToFile(File f) throws FileNotFoundException {
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(f, "rwd");
        }
        catch (FileNotFoundException e) {
            FileNotFoundException fex = e;
            if (!f.exists()) {
                fex = (FileNotFoundException)new FileNotFoundException(e.getLocalizedMessage()).initCause(e);
            } else if (!f.canRead()) {
                fex = (FileNotFoundException)new FileNotFoundException(e.getLocalizedMessage()).initCause(e);
            } else if (!f.canWrite()) {
                fex = (FileNotFoundException)new FileNotFoundException(e.getLocalizedMessage()).initCause(e);
            } else if (f.getParentFile() == null) {
                fex = (FileNotFoundException)new FileNotFoundException(e.getLocalizedMessage()).initCause(e);
            } else if (!f.getParentFile().exists()) {
                fex = (FileNotFoundException)new FileNotFoundException(e.getLocalizedMessage()).initCause(e);
            }
            throw fex;
        }
        return raf;
    }

    private WriteLock(File lockFile) {
        this.lockFile = lockFile;
        this.register();
    }

    public boolean isValid(File f) {
        boolean retVal = this.isValid();
        if (retVal) {
            File associatedLockFile = WriteLockUtils.getAssociatedLockFile(f);
            retVal = this.lockFile.equals(associatedLockFile);
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseLock() {
        Class clazz = WriteLockFactory.class;
        synchronized (clazz) {
            if (this.isValid()) {
                this.deregister();
                super.releaseLock();
                if (this.getLockFile().exists()) {
                    boolean bl = this.getLockFile().delete();
                }
            }
        }
    }

    private final void deregister() {
        allLocks.remove(this.getLockFile());
    }

    private final void register() {
        allLocks.put(this.getLockFile(), new WeakReference<WriteLock>(this));
    }

    final File getLockFile() {
        return this.lockFile;
    }

    public final String toString() {
        String name = this.getLockFile().getName();
        String newName = name.substring(".LCK".length(), name.length() - "~".length());
        return new File(this.getLockFile().getParentFile(), newName).getAbsolutePath();
    }

    static {
        $assertionsDisabled = !WriteLock.class.desiredAssertionStatus();
        allLocks = Collections.synchronizedMap(new WeakHashMap());
        Runtime.getRuntime().addShutdownHook(new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Set s = allLocks.keySet();
                Map map = allLocks;
                synchronized (map) {
                    Iterator it = s.iterator();
                    while (it.hasNext()) {
                        File f = (File)it.next();
                        if (!f.exists() || !WriteLockUtils.hasActiveLockFileSigns(f.getAbsolutePath())) continue;
                        f.delete();
                    }
                }
            }
        });
    }

    private static class NioLock
    extends WriteLock {
        private FileChannel channel;
        private java.nio.channels.FileLock nioLock;
        static final /* synthetic */ boolean $assertionsDisabled;

        NioLock(File lockFile, FileChannel channel, java.nio.channels.FileLock nioLock) {
            super(lockFile);
            if (!$assertionsDisabled && nioLock == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && !nioLock.isValid()) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && channel == null) {
                throw new AssertionError();
            }
            this.channel = channel;
            this.nioLock = nioLock;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void releaseLock() {
            Class clazz = class$org$netbeans$modules$masterfs$filebasedfs$fileobjects$WriteLockFactory == null ? (class$org$netbeans$modules$masterfs$filebasedfs$fileobjects$WriteLockFactory = WriteLock.class$("org.netbeans.modules.masterfs.filebasedfs.fileobjects.WriteLockFactory")) : class$org$netbeans$modules$masterfs$filebasedfs$fileobjects$WriteLockFactory;
            synchronized (clazz) {
                try {
                    if (this.nioLock.isValid()) {
                        this.nioLock.release();
                    }
                    if (this.channel.isOpen()) {
                        this.channel.close();
                    }
                }
                catch (IOException e) {
                    Exceptions.printStackTrace((Throwable)e);
                }
                super.releaseLock();
            }
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$masterfs$filebasedfs$fileobjects$WriteLock == null ? (class$org$netbeans$modules$masterfs$filebasedfs$fileobjects$WriteLock = WriteLock.class$("org.netbeans.modules.masterfs.filebasedfs.fileobjects.WriteLock")) : class$org$netbeans$modules$masterfs$filebasedfs$fileobjects$WriteLock).desiredAssertionStatus();
        }
    }
}

