/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.cookies.SaveCookie;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExitDialog
extends JPanel
implements ActionListener {
    static boolean SAVE_ALL_UNCONDITIONALLY = false;
    private static Object[] exitOptions;
    private static Dialog exitDialog;
    private static boolean result;
    JList list;
    DefaultListModel listModel;

    private ExitDialog(Set<DataObject> openedFiles) {
        this.setLayout(new BorderLayout());
        this.listModel = new DefaultListModel();
        Set<DataObject> set = ExitDialog.getModifiedFiles(openedFiles);
        if (!set.isEmpty()) {
            for (DataObject obj : set) {
                this.listModel.addElement(obj);
            }
            this.draw();
        }
    }

    private void draw() {
        this.list = new JList(this.listModel);
        this.list.setBorder(new EmptyBorder(2, 2, 2, 2));
        this.list.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                ExitDialog.this.updateSaveButton();
            }
        });
        if (!this.listModel.isEmpty()) {
            this.list.setSelectedIndex(0);
        } else {
            this.updateSaveButton();
        }
        JScrollPane scroll = new JScrollPane(this.list);
        scroll.setBorder(new CompoundBorder(new EmptyBorder(12, 12, 11, 0), scroll.getBorder()));
        this.add((Component)scroll, "Center");
        this.list.setCellRenderer(new ExitDlgListCellRenderer());
        this.list.getAccessibleContext().setAccessibleName(NbBundle.getBundle(ExitDialog.class).getString("ACSN_ListOfChangedFiles"));
        this.list.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(ExitDialog.class).getString("ACSD_ListOfChangedFiles"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(ExitDialog.class).getString("ACSD_ExitDialog"));
    }

    private void updateSaveButton() {
        ((JButton)exitOptions[0]).setEnabled(this.list.getSelectedIndex() != -1);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension prev = super.getPreferredSize();
        return new Dimension(Math.max(300, prev.width), Math.max(150, prev.height));
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (exitOptions[0].equals(evt.getSource())) {
            this.save(false);
        } else if (exitOptions[1].equals(evt.getSource())) {
            this.save(true);
        } else if (exitOptions[2].equals(evt.getSource())) {
            this.theEnd();
        } else if (NotifyDescriptor.CANCEL_OPTION.equals(evt.getSource())) {
            exitDialog.setVisible(false);
        }
    }

    private void save(boolean all) {
        Object[] array = all ? this.listModel.toArray() : this.list.getSelectedValues();
        int count = array == null ? 0 : array.length;
        int index = 0;
        for (int i = 0; i < count; ++i) {
            DataObject nextObject = (DataObject)array[i];
            index = this.listModel.indexOf(nextObject);
            this.save(nextObject);
        }
        if (this.listModel.isEmpty()) {
            this.theEnd();
        } else {
            if (index < 0) {
                index = 0;
            } else if (index > this.listModel.size() - 1) {
                index = this.listModel.size() - 1;
            }
            this.list.setSelectedIndex(index);
        }
    }

    private void save(DataObject dataObject) {
        try {
            SaveCookie sc = (SaveCookie)dataObject.getCookie(SaveCookie.class);
            if (sc != null) {
                sc.save();
            }
            this.listModel.removeElement(dataObject);
        }
        catch (IOException exc) {
            ErrorManager em = ErrorManager.getDefault();
            Throwable t = em.annotate((Throwable)exc, NbBundle.getBundle(ExitDialog.class).getString("EXC_Save"));
            em.notify(4096, t);
        }
    }

    public static void doSave(DataObject dataObject) {
        try {
            SaveCookie sc = (SaveCookie)dataObject.getCookie(SaveCookie.class);
            if (sc != null) {
                sc.save();
            }
        }
        catch (IOException exc) {
            ErrorManager em = ErrorManager.getDefault();
            Throwable t = em.annotate((Throwable)exc, NbBundle.getBundle(ExitDialog.class).getString("EXC_Save"));
            em.notify(4096, t);
        }
    }

    private void theEnd() {
        for (int i = this.listModel.size() - 1; i >= 0; --i) {
            DataObject obj = (DataObject)this.listModel.getElementAt(i);
            obj.setModified(false);
        }
        result = true;
        exitDialog.setVisible(false);
        exitDialog.dispose();
    }

    public static boolean showDialog(Set<DataObject> openedFiles) {
        return ExitDialog.innerShowDialog(ExitDialog.getModifiedFiles(openedFiles));
    }

    private static Set<DataObject> getModifiedFiles(Set<DataObject> openedFiles) {
        HashSet<DataObject> set = new HashSet<DataObject>(openedFiles.size());
        for (DataObject obj : openedFiles) {
            if (!obj.isModified()) continue;
            set.add(obj);
        }
        return set;
    }

    private static boolean innerShowDialog(Set<DataObject> openedFiles) {
        if (!openedFiles.isEmpty()) {
            if (SAVE_ALL_UNCONDITIONALLY) {
                for (DataObject d : openedFiles) {
                    ExitDialog.doSave(d);
                }
                return true;
            }
            exitDialog = null;
            if (exitDialog == null) {
                ResourceBundle bundle = NbBundle.getBundle(ExitDialog.class);
                JButton buttonSave = new JButton();
                buttonSave.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_Save"));
                JButton buttonSaveAll = new JButton();
                buttonSaveAll.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_SaveAll"));
                JButton buttonDiscardAll = new JButton();
                buttonDiscardAll.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_DiscardAll"));
                Mnemonics.setLocalizedText((AbstractButton)buttonSave, (String)bundle.getString("CTL_Save"));
                Mnemonics.setLocalizedText((AbstractButton)buttonSaveAll, (String)bundle.getString("CTL_SaveAll"));
                Mnemonics.setLocalizedText((AbstractButton)buttonDiscardAll, (String)bundle.getString("CTL_DiscardAll"));
                exitOptions = new Object[]{buttonSave, buttonSaveAll, buttonDiscardAll};
                ExitDialog exitComponent = null;
                exitComponent = new ExitDialog(openedFiles);
                DialogDescriptor exitDlgDescriptor = new DialogDescriptor((Object)exitComponent, bundle.getString("CTL_ExitTitle"), true, exitOptions, NotifyDescriptor.CANCEL_OPTION, 1, null, (ActionListener)exitComponent);
                exitDlgDescriptor.setAdditionalOptions(new Object[]{NotifyDescriptor.CANCEL_OPTION});
                exitDialog = DialogDisplayer.getDefault().createDialog(exitDlgDescriptor);
            }
            result = false;
            exitDialog.setVisible(true);
            return result;
        }
        return true;
    }

    static {
        result = false;
    }

    private class ExitDlgListCellRenderer
    extends JLabel
    implements ListCellRenderer {
        protected Border hasFocusBorder;
        protected Border noFocusBorder;

        public ExitDlgListCellRenderer() {
            this.setOpaque(true);
            this.setBorder(this.noFocusBorder);
            this.hasFocusBorder = new LineBorder(UIManager.getColor("List.focusCellHighlight"));
            this.noFocusBorder = new EmptyBorder(1, 1, 1, 1);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            final DataObject obj = (DataObject)value;
            if (!obj.isValid()) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ExitDialog.this.listModel.removeElement(obj);
                    }
                });
                this.setText("");
                return this;
            }
            Node node = obj.getNodeDelegate();
            ImageIcon icon = new ImageIcon(node.getIcon(1));
            super.setIcon(icon);
            this.setText(node.getDisplayName());
            if (isSelected) {
                this.setBackground(UIManager.getColor("List.selectionBackground"));
                this.setForeground(UIManager.getColor("List.selectionForeground"));
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setBorder(cellHasFocus ? this.hasFocusBorder : this.noFocusBorder);
            return this;
        }
    }
}

