/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.text.Collator;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.filechooser.FileView;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.queries.CollocationQuery;
import org.netbeans.modules.project.ui.OpenProjectList;
import org.netbeans.modules.project.ui.OpenProjectListSettings;
import org.netbeans.spi.project.SubprojectProvider;
import org.openide.ErrorManager;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Cancellable;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class ProjectChooserAccessory
extends JPanel
implements ActionListener,
PropertyChangeListener {
    private RequestProcessor.Task updateSubprojectsTask;
    private RequestProcessor RP;
    private ModelUpdater modelUpdater;
    private Boolean tempSetAsMain;
    private Map<Project, Set<? extends Project>> subprojectsCache = new HashMap<Project, Set<? extends Project>>();
    private JCheckBox jCheckBoxMain;
    private JCheckBox jCheckBoxSubprojects;
    private JLabel jLabelProjectName;
    private JList jListSubprojects;
    private JScrollPane jScrollPaneSubprojects;
    private JTextField jTextFieldProjectName;

    public ProjectChooserAccessory(JFileChooser chooser, boolean isOpenSubprojects, boolean isOpenAsMain) {
        this.initComponents();
        this.modelUpdater = new ModelUpdater();
        this.RP = new RequestProcessor(ModelUpdater.class.getName(), 1);
        this.updateSubprojectsTask = this.RP.create((Runnable)this.modelUpdater);
        this.updateSubprojectsTask.setPriority(1);
        this.jCheckBoxSubprojects.setSelected(isOpenSubprojects);
        this.jCheckBoxSubprojects.addActionListener(this);
        this.jCheckBoxMain.setSelected(isOpenAsMain);
        this.jCheckBoxMain.addActionListener(this);
        chooser.addPropertyChangeListener(this);
        this.jListSubprojects.setModel(new DefaultListModel());
        this.setAccessoryEnablement(false, 0);
    }

    private void initComponents() {
        this.jLabelProjectName = new JLabel();
        this.jTextFieldProjectName = new JTextField();
        this.jCheckBoxMain = new JCheckBox();
        this.jCheckBoxSubprojects = new JCheckBox();
        this.jScrollPaneSubprojects = new JScrollPane();
        this.jListSubprojects = new JList();
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(new Insets(0, 12, 0, 0)));
        this.jLabelProjectName.setLabelFor(this.jTextFieldProjectName);
        Mnemonics.setLocalizedText((JLabel)this.jLabelProjectName, (String)NbBundle.getMessage(ProjectChooserAccessory.class, (String)"LBL_PrjChooser_ProjectName_Label"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.add((Component)this.jLabelProjectName, gridBagConstraints);
        this.jLabelProjectName.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ProjectChooserAccessory.class, (String)"AN_ProjectName"));
        this.jLabelProjectName.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectChooserAccessory.class, (String)"AD_ProjectName"));
        this.jTextFieldProjectName.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.add((Component)this.jTextFieldProjectName, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.jCheckBoxMain, (String)NbBundle.getMessage(ProjectChooserAccessory.class, (String)"LBL_PrjChooser_Main_CheckBox"));
        this.jCheckBoxMain.setMargin(new Insets(2, 0, 2, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.jCheckBoxMain, gridBagConstraints);
        this.jCheckBoxMain.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectChooserAccessory.class, (String)"ACSD_ProjectChooserAccessory_jCheckBoxMain"));
        Mnemonics.setLocalizedText((AbstractButton)this.jCheckBoxSubprojects, (String)NbBundle.getMessage(ProjectChooserAccessory.class, (String)"LBL_PrjChooser_Subprojects_CheckBox"));
        this.jCheckBoxSubprojects.setMargin(new Insets(2, 0, 2, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.add((Component)this.jCheckBoxSubprojects, gridBagConstraints);
        this.jCheckBoxSubprojects.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectChooserAccessory.class, (String)"ACSD_ProjectChooserAccessory_jCheckBoxSubprojects"));
        this.jListSubprojects.setSelectionMode(0);
        this.jListSubprojects.setEnabled(false);
        this.jScrollPaneSubprojects.setViewportView(this.jListSubprojects);
        this.jListSubprojects.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ProjectChooserAccessory.class, (String)"ACSN_ProjectChooserAccessory_jListSubprojects"));
        this.jListSubprojects.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectChooserAccessory.class, (String)"ACSD_ProjectChooserAccessory_jListSubprojects"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jScrollPaneSubprojects, gridBagConstraints);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.jCheckBoxSubprojects) {
            OpenProjectListSettings.getInstance().setOpenSubprojects(this.jCheckBoxSubprojects.isSelected());
        } else if (e.getSource() == this.jCheckBoxMain) {
            OpenProjectListSettings.getInstance().setOpenAsMain(this.jCheckBoxMain.isSelected());
        }
    }

    public void propertyChange(PropertyChangeEvent e) {
        if ("SelectedFileChangedProperty".equals(e.getPropertyName()) || "SelectedFilesChangedProperty".equals(e.getPropertyName())) {
            JFileChooser chooser = (JFileChooser)e.getSource();
            final ListModel spListModel = this.jListSubprojects.getModel();
            final File[] projectDirs = chooser.isMultiSelectionEnabled() ? chooser.getSelectedFiles() : new File[]{chooser.getSelectedFile()};
            this.jTextFieldProjectName.setText(NbBundle.getMessage(ProjectChooserAccessory.class, (String)"MSG_PrjChooser_WaitMessage"));
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    final ArrayList<Project> projects = new ArrayList<Project>(projectDirs.length);
                    for (File dir : projectDirs) {
                        Project project;
                        if (dir == null || (project = ProjectChooserAccessory.getProject(FileUtil.normalizeFile((File)dir))) == null) continue;
                        projects.add(project);
                    }
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            if (!projects.isEmpty()) {
                                ProjectChooserAccessory.this.setAccessoryEnablement(true, projects.size());
                                if (projects.size() == 1) {
                                    String projectName = ProjectUtils.getInformation((Project)((Project)projects.get(0))).getDisplayName();
                                    ProjectChooserAccessory.this.jTextFieldProjectName.setText(projectName);
                                    ProjectChooserAccessory.this.jTextFieldProjectName.setToolTipText(projectName);
                                } else {
                                    ProjectChooserAccessory.this.jTextFieldProjectName.setText(NbBundle.getMessage(ProjectChooserAccessory.class, (String)"LBL_PrjChooser_Multiselection", (Object)projects.size()));
                                    StringBuffer toolTipText = new StringBuffer("<html>");
                                    Iterator it = projects.iterator();
                                    while (it.hasNext()) {
                                        Project p = (Project)it.next();
                                        toolTipText.append(ProjectUtils.getInformation((Project)p).getDisplayName());
                                        if (!it.hasNext()) continue;
                                        toolTipText.append("<br>");
                                    }
                                    toolTipText.append("</html>");
                                    ProjectChooserAccessory.this.jTextFieldProjectName.setToolTipText(toolTipText.toString());
                                }
                                if (spListModel instanceof DefaultListModel) {
                                    ((DefaultListModel)spListModel).clear();
                                } else {
                                    ProjectChooserAccessory.this.jListSubprojects.setListData(new String[0]);
                                }
                                if (ProjectChooserAccessory.this.modelUpdater != null) {
                                    ((ProjectChooserAccessory)ProjectChooserAccessory.this).modelUpdater.projects = projects;
                                    ProjectChooserAccessory.this.updateSubprojectsTask.schedule(100);
                                }
                            } else {
                                File dir;
                                FileObject fo;
                                ProjectChooserAccessory.this.jTextFieldProjectName.setText("");
                                if (ProjectChooserAccessory.this.modelUpdater != null) {
                                    ((ProjectChooserAccessory)ProjectChooserAccessory.this).modelUpdater.projects = null;
                                }
                                if (spListModel instanceof DefaultListModel) {
                                    ((DefaultListModel)spListModel).clear();
                                } else {
                                    ProjectChooserAccessory.this.jListSubprojects.setListData(new String[0]);
                                }
                                ProjectChooserAccessory.this.setAccessoryEnablement(false, 0);
                                if (projectDirs.length == 1 && projectDirs[0] != null && (fo = FileUtil.toFileObject((File)(dir = FileUtil.normalizeFile((File)projectDirs[0])))) != null && fo.isFolder() && ProjectManager.getDefault().isProject(fo)) {
                                    try {
                                        Project prj = ProjectManager.getDefault().findProject(fo);
                                        if (prj == null) {
                                            ProjectChooserAccessory.this.jTextFieldProjectName.setText(NbBundle.getMessage(ProjectChooserAccessory.class, (String)"LBL_PrjChooser_Unrecognized"));
                                            ProjectChooserAccessory.this.jLabelProjectName.setEnabled(true);
                                            ProjectChooserAccessory.this.jTextFieldProjectName.setEnabled(true);
                                        }
                                    }
                                    catch (IOException x) {
                                        String msg = x.toString();
                                        ErrorManager.Annotation[] anns = ErrorManager.getDefault().findAnnotations((Throwable)x);
                                        for (int i = 0; i < anns.length; ++i) {
                                            if (anns[i].getLocalizedMessage() == null) continue;
                                            msg = anns[i].getLocalizedMessage();
                                            break;
                                        }
                                        ProjectChooserAccessory.this.jTextFieldProjectName.setText(msg);
                                        ProjectChooserAccessory.this.jTextFieldProjectName.setCaretPosition(0);
                                        Color error = UIManager.getColor("nb.errorForeground");
                                        if (error != null) {
                                            ProjectChooserAccessory.this.jTextFieldProjectName.setForeground(error);
                                        }
                                        ProjectChooserAccessory.this.jLabelProjectName.setEnabled(true);
                                        ProjectChooserAccessory.this.jTextFieldProjectName.setEnabled(true);
                                    }
                                }
                            }
                        }
                    });
                }
            });
        } else if ("directoryChanged".equals(e.getPropertyName())) {
            this.setAccessoryEnablement(false, 0);
        }
    }

    private static boolean isProjectDir(File dir) {
        FileObject fo;
        boolean retVal = false;
        if (dir != null && (fo = ProjectChooserAccessory.convertToValidDir(dir)) != null) {
            retVal = Utilities.isUnix() && fo.getParent() != null && fo.getParent().getParent() == null ? false : ProjectManager.getDefault().isProject(fo);
        }
        return retVal;
    }

    private static FileObject convertToValidDir(File f) {
        File testFile = new File(f.getPath());
        if (testFile == null || testFile.getParent() == null) {
            return null;
        }
        if (!testFile.isDirectory()) {
            return null;
        }
        FileObject fo = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)f));
        return fo;
    }

    private static Project getProject(File dir) {
        return OpenProjectList.fileToProject(dir);
    }

    private void setAccessoryEnablement(boolean enable, int numberOfProjects) {
        this.jLabelProjectName.setEnabled(enable);
        this.jTextFieldProjectName.setEnabled(enable);
        this.jTextFieldProjectName.setForeground(null);
        this.jCheckBoxSubprojects.setEnabled(enable);
        this.jScrollPaneSubprojects.setEnabled(enable);
        if (numberOfProjects <= 1) {
            if (this.tempSetAsMain != null) {
                this.jCheckBoxMain.setSelected(this.tempSetAsMain);
                this.tempSetAsMain = null;
            }
            this.jCheckBoxMain.setEnabled(enable);
        } else if (this.tempSetAsMain == null) {
            this.tempSetAsMain = this.jCheckBoxMain.isSelected();
            this.jCheckBoxMain.setSelected(false);
            this.jCheckBoxMain.setEnabled(false);
        }
    }

    private static String relativizePath(File f1, File f2) {
        if (f1 == null || f2 == null) {
            return null;
        }
        if (!CollocationQuery.areCollocated((File)f1, (File)f2)) {
            return null;
        }
        StringBuffer b = new StringBuffer();
        File base = f1;
        String filepath = f2.getAbsolutePath();
        while (!filepath.startsWith(ProjectChooserAccessory.slashify(base.getAbsolutePath()))) {
            if ((base = base.getParentFile()) == null) {
                return null;
            }
            if (base.equals(f2)) {
                b.append("..");
                return b.toString();
            }
            b.append("../");
        }
        URI u = base.toURI().relativize(f2.toURI());
        assert (!u.isAbsolute()) : u + " from " + f1 + " and " + f2 + " with common root " + base;
        b.append(u.getPath());
        if (b.charAt(b.length() - 1) == '/') {
            b.setLength(b.length() - 1);
        }
        return b.toString();
    }

    private static String slashify(String path) {
        if (path.endsWith(File.separator)) {
            return path;
        }
        return path + File.separatorChar;
    }

    public static JFileChooser createProjectChooser(boolean defaultAccessory) {
        File d;
        ProjectManager.getDefault().clearNonProjectCache();
        OpenProjectListSettings opls = OpenProjectListSettings.getInstance();
        ProjectFileChooser chooser = new ProjectFileChooser();
        chooser.setFileSelectionMode(1);
        if ("GTK".equals(UIManager.getLookAndFeel().getID())) {
            chooser.putClientProperty("GTKFileChooser.showDirectoryIcons", Boolean.TRUE);
        }
        chooser.setApproveButtonText(NbBundle.getMessage(ProjectChooserAccessory.class, (String)"BTN_PrjChooser_ApproveButtonText"));
        chooser.setApproveButtonMnemonic(NbBundle.getMessage(ProjectChooserAccessory.class, (String)"MNM_PrjChooser_ApproveButtonText").charAt(0));
        chooser.setApproveButtonToolTipText(NbBundle.getMessage(ProjectChooserAccessory.class, (String)"BTN_PrjChooser_ApproveButtonTooltipText"));
        chooser.setDialogTitle(NbBundle.getMessage(ProjectChooserAccessory.class, (String)"LBL_PrjChooser_Title"));
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.setFileFilter(ProjectDirFilter.INSTANCE);
        chooser.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ProjectChooserAccessory.class, (String)"AN_ProjectChooserAccessory"));
        chooser.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectChooserAccessory.class, (String)"AD_ProjectChooserAccessory"));
        if (defaultAccessory) {
            chooser.setAccessory(new ProjectChooserAccessory(chooser, opls.isOpenSubprojects(), opls.isOpenAsMain()));
        }
        File currDir = null;
        String dir = opls.getLastOpenProjectDir();
        if (dir != null && (d = new File(dir)).exists() && d.isDirectory()) {
            currDir = d;
        }
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)chooser, currDir);
        chooser.setFileView(new ProjectFileView(chooser.getFileSystemView()));
        return chooser;
    }

    public void removeNotify() {
        super.removeNotify();
        if (this.modelUpdater != null) {
            this.modelUpdater.cancel();
        }
        this.modelUpdater = null;
        this.subprojectsCache = null;
        this.updateSubprojectsTask = null;
    }

    private static class MergedIcon
    implements Icon {
        private Icon icon1;
        private Icon icon2;
        private int xMerge;
        private int yMerge;

        MergedIcon(Icon icon1, Icon icon2, int xMerge, int yMerge) {
            this.icon1 = icon1;
            this.icon2 = icon2;
            if (xMerge == -1) {
                xMerge = icon1.getIconWidth() - icon2.getIconWidth();
            }
            if (yMerge == -1) {
                yMerge = icon1.getIconHeight() - icon2.getIconHeight();
            }
            this.xMerge = xMerge;
            this.yMerge = yMerge;
        }

        public int getIconHeight() {
            return Math.max(this.icon1.getIconHeight(), this.yMerge + this.icon2.getIconHeight());
        }

        public int getIconWidth() {
            return Math.max(this.icon1.getIconWidth(), this.yMerge + this.icon2.getIconWidth());
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            this.icon1.paintIcon(c, g, x, y);
            this.icon2.paintIcon(c, g, x + this.xMerge, y + this.yMerge);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ModelUpdater
    implements Runnable,
    Cancellable {
        volatile List<Project> projects;
        private DefaultListModel subprojectsToSet;
        private boolean cancel = false;

        private ModelUpdater() {
        }

        @Override
        public void run() {
            if (!SwingUtilities.isEventDispatchThread()) {
                if (this.cancel) {
                    return;
                }
                List<Project> currentProjects = this.projects;
                if (currentProjects == null) {
                    return;
                }
                Map cache = ProjectChooserAccessory.this.subprojectsCache;
                if (cache == null) {
                    return;
                }
                ProjectChooserAccessory.this.jListSubprojects.setListData(new String[]{NbBundle.getMessage(ProjectChooserAccessory.class, (String)"MSG_PrjChooser_WaitMessage")});
                ArrayList<Project> subprojects = new ArrayList<Project>(currentProjects.size() * 5);
                for (Project p : currentProjects) {
                    if (this.cancel) {
                        return;
                    }
                    this.addSubprojects(p, subprojects, cache);
                }
                if (this.cancel) {
                    return;
                }
                ArrayList<String> subprojectNames = new ArrayList<String>(subprojects.size());
                if (!subprojects.isEmpty()) {
                    String pattern = NbBundle.getMessage(ProjectChooserAccessory.class, (String)"LBL_PrjChooser_SubprojectName_Format");
                    File pDir = currentProjects.size() == 1 ? FileUtil.toFile((FileObject)currentProjects.get(0).getProjectDirectory()) : null;
                    for (Project p : subprojects) {
                        if (this.cancel) {
                            return;
                        }
                        FileObject spDir = p.getProjectDirectory();
                        String relPath = null;
                        if (pDir != null) {
                            relPath = ProjectChooserAccessory.relativizePath(pDir, FileUtil.toFile((FileObject)spDir));
                        }
                        if (relPath == null) {
                            relPath = FileUtil.getFileDisplayName((FileObject)spDir);
                        }
                        String displayName = MessageFormat.format(pattern, ProjectUtils.getInformation((Project)p).getDisplayName(), relPath);
                        subprojectNames.add(displayName);
                    }
                    Collections.sort(subprojectNames, Collator.getInstance());
                }
                if (currentProjects != this.projects || this.cancel) {
                    return;
                }
                DefaultListModel<String> listModel = new DefaultListModel<String>();
                for (String displayName : subprojectNames) {
                    listModel.addElement(displayName);
                }
                this.subprojectsToSet = listModel;
                if (this.cancel) {
                    return;
                }
                SwingUtilities.invokeLater(this);
                return;
            }
            if (this.projects == null) {
                ListModel spListModel = ProjectChooserAccessory.this.jListSubprojects.getModel();
                if (spListModel instanceof DefaultListModel) {
                    ((DefaultListModel)spListModel).clear();
                } else {
                    ProjectChooserAccessory.this.jListSubprojects.setListData(new String[0]);
                }
                ProjectChooserAccessory.this.jCheckBoxSubprojects.setEnabled(false);
            } else {
                ProjectChooserAccessory.this.jListSubprojects.setModel(this.subprojectsToSet);
                ProjectChooserAccessory.this.jCheckBoxSubprojects.setEnabled(!this.subprojectsToSet.isEmpty());
                this.projects = null;
            }
        }

        void addSubprojects(Project p, List<Project> result, Map<Project, Set<? extends Project>> cache) {
            if (this.cancel) {
                return;
            }
            Set<? extends Project> subprojects = cache.get(p);
            if (subprojects == null) {
                SubprojectProvider spp = (SubprojectProvider)p.getLookup().lookup(SubprojectProvider.class);
                if (spp != null) {
                    if (this.cancel) {
                        return;
                    }
                    subprojects = spp.getSubprojects();
                } else {
                    subprojects = Collections.emptySet();
                }
                cache.put(p, subprojects);
            }
            for (Project project : subprojects) {
                if (this.cancel) {
                    return;
                }
                if (result.contains(project)) continue;
                result.add(project);
                this.addSubprojects(project, result, cache);
            }
        }

        public boolean cancel() {
            this.cancel = true;
            return true;
        }
    }

    private static class ProjectDirFilter
    extends FileFilter {
        private static final FileFilter INSTANCE = new ProjectDirFilter();

        private ProjectDirFilter() {
        }

        public boolean accept(File f) {
            return f.isDirectory();
        }

        public String getDescription() {
            return NbBundle.getMessage(ProjectDirFilter.class, (String)"LBL_PrjChooser_ProjectDirectoryFilter_Name");
        }
    }

    private static class ProjectFileChooser
    extends JFileChooser {
        private ProjectFileChooser() {
        }

        public void approveSelection() {
            File dir = FileUtil.normalizeFile((File)this.getSelectedFile());
            if (ProjectChooserAccessory.isProjectDir(dir) && ProjectChooserAccessory.getProject(dir) != null) {
                super.approveSelection();
            } else {
                this.setCurrentDirectory(dir);
            }
        }
    }

    private static class ProjectFileView
    extends FileView {
        private static final Icon BADGE = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/project/ui/resources/projectBadge.gif"));
        private static final Icon EMPTY = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/project/ui/resources/empty.gif"));
        private FileSystemView fsv;
        private Icon lastOriginal;
        private Icon lastMerged;

        public ProjectFileView(FileSystemView fsv) {
            this.fsv = fsv;
        }

        public Icon getIcon(File _f) {
            if (!_f.exists()) {
                return null;
            }
            File f = FileUtil.normalizeFile((File)_f);
            Icon original = this.fsv.getSystemIcon(f);
            if (original == null) {
                original = EMPTY;
            }
            if (ProjectChooserAccessory.isProjectDir(f)) {
                if (original.equals(this.lastOriginal)) {
                    return this.lastMerged;
                }
                this.lastOriginal = original;
                this.lastMerged = new MergedIcon(original, BADGE, -1, -1);
                return this.lastMerged;
            }
            return original;
        }
    }
}

