/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OptionalDataException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.project.ui.OpenProjectList;
import org.netbeans.modules.project.ui.ProjectsRootNode;
import org.netbeans.modules.project.ui.groups.Group;
import org.netbeans.spi.project.ActionProvider;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.view.BeanTreeView;
import org.openide.explorer.view.Visualizer;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.nodes.NodeNotFoundException;
import org.openide.nodes.NodeOp;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectTab
extends TopComponent
implements ExplorerManager.Provider {
    public static final String ID_LOGICAL = "projectTabLogical_tc";
    public static final String ID_PHYSICAL = "projectTab_tc";
    private static final Image ICON_LOGICAL = Utilities.loadImage((String)"org/netbeans/modules/project/ui/resources/projectTab.png");
    private static final Image ICON_PHYSICAL = Utilities.loadImage((String)"org/netbeans/modules/project/ui/resources/filesTab.png");
    private static Map<String, ProjectTab> tabs = new HashMap<String, ProjectTab>();
    private final transient ExplorerManager manager;
    private transient Node rootNode;
    private String id;
    private final transient ProjectTreeView btv;
    private static final long serialVersionUID = 9374872358L;
    private final RequestProcessor RP = new RequestProcessor();

    public ProjectTab(String id) {
        this();
        this.id = id;
        this.initValues();
    }

    public ProjectTab() {
        this.manager = new ExplorerManager();
        ActionMap map = this.getActionMap();
        map.put("copy-to-clipboard", ExplorerUtils.actionCopy((ExplorerManager)this.manager));
        map.put("cut-to-clipboard", ExplorerUtils.actionCut((ExplorerManager)this.manager));
        map.put("paste-from-clipboard", ExplorerUtils.actionPaste((ExplorerManager)this.manager));
        map.put("delete", new DelegatingAction("delete", ExplorerUtils.actionDelete((ExplorerManager)this.manager, (boolean)true)));
        this.initComponents();
        this.btv = new ProjectTreeView();
        this.btv.setDragSource(true);
        this.btv.setRootVisible(false);
        this.add((Component)((Object)this.btv), "Center");
        this.associateLookup(ExplorerUtils.createLookup((ExplorerManager)this.manager, (ActionMap)map));
    }

    public void setGroup(Group g) {
        if (this.id.equals(ID_LOGICAL)) {
            if (g != null) {
                this.setName(NbBundle.getMessage(ProjectTab.class, (String)"LBL_projectTabLogical_tc_with_group", (Object)g.getName()));
            } else {
                this.setName(NbBundle.getMessage(ProjectTab.class, (String)"LBL_projectTabLogical_tc"));
            }
        } else {
            this.setName(NbBundle.getMessage(ProjectTab.class, (String)"LBL_projectTab_tc"));
        }
    }

    private void initValues() {
        this.setGroup(Group.getActiveGroup());
        if (this.id.equals(ID_LOGICAL)) {
            this.setIcon(ICON_LOGICAL);
        } else {
            this.setIcon(ICON_PHYSICAL);
        }
        if (this.rootNode == null) {
            this.rootNode = new ProjectsRootNode(this.id.equals(ID_LOGICAL) ? 1 : 0);
        }
        this.manager.setRootContext(this.rootNode);
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    public static synchronized ProjectTab findDefault(String tcID) {
        ProjectTab tab = tabs.get(tcID);
        if (tab == null) {
            TopComponent tc = WindowManager.getDefault().findTopComponent(tcID);
            if (tc != null) {
                if (!(tc instanceof ProjectTab)) {
                    IllegalStateException exc = new IllegalStateException("Incorrect settings file. Unexpected class returned. Expected:" + ProjectTab.class.getName() + " Returned:" + tc.getClass().getName());
                    ErrorManager.getDefault().notify(1, (Throwable)exc);
                    tab = ProjectTab.getDefault(tcID);
                } else {
                    tab = (ProjectTab)tc;
                }
            } else {
                tab = ProjectTab.getDefault(tcID);
            }
        }
        return tab;
    }

    public static synchronized ProjectTab getDefault(String tcID) {
        ProjectTab tab = tabs.get(tcID);
        if (tab == null) {
            tab = new ProjectTab(tcID);
            tabs.put(tcID, tab);
        }
        return tab;
    }

    public static TopComponent getLogical() {
        return ProjectTab.getDefault(ID_LOGICAL);
    }

    public static TopComponent getPhysical() {
        return ProjectTab.getDefault(ID_PHYSICAL);
    }

    protected String preferredID() {
        return this.id;
    }

    public HelpCtx getHelpCtx() {
        return ExplorerUtils.getHelpCtx((Node[])this.manager.getSelectedNodes(), (HelpCtx)(ID_LOGICAL.equals(this.id) ? new HelpCtx("ProjectTab_Projects") : new HelpCtx("ProjectTab_Files")));
    }

    public int getPersistenceType() {
        return 0;
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    public boolean requestFocusInWindow() {
        super.requestFocusInWindow();
        return this.btv.requestFocusInWindow();
    }

    public void requestFocus() {
        super.requestFocus();
        this.btv.requestFocus();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.id);
        out.writeObject(this.rootNode.getHandle());
        out.writeObject(this.btv.getExpandedPaths());
        out.writeObject(this.getSelectedPaths());
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.id = (String)in.readObject();
        this.rootNode = ((Node.Handle)in.readObject()).getNode();
        List exPaths = (List)in.readObject();
        List selPaths = null;
        try {
            selPaths = (List)in.readObject();
        }
        catch (OptionalDataException e) {
            // empty catch block
        }
        this.initValues();
        if (System.getProperty("netbeans.keep.expansion") != null) {
            this.btv.expandNodes(exPaths);
            this.selectPaths(selPaths);
        }
    }

    protected void componentActivated() {
        ExplorerUtils.activateActions((ExplorerManager)this.manager, (boolean)true);
    }

    protected void componentDeactivated() {
        ExplorerUtils.activateActions((ExplorerManager)this.manager, (boolean)false);
    }

    public Action[] getActions() {
        Action[] actions = super.getActions();
        if (ID_LOGICAL.equals(this.id)) {
            ArrayList<Action> allActions = new ArrayList<Action>(Arrays.asList(this.manager.getRootContext().getActions(false)));
            allActions.add(null);
            allActions.addAll(Arrays.asList(actions));
            return allActions.toArray(new Action[allActions.size()]);
        }
        return actions;
    }

    public void selectNodeAsync(final FileObject object) {
        this.setCursor(Utilities.createProgressCursor((Component)((Object)this)));
        this.open();
        this.requestActive();
        this.RP.post(new Runnable(){

            public void run() {
                Project project;
                ProjectsRootNode root = (ProjectsRootNode)ProjectTab.this.manager.getRootContext();
                Node tempNode = root.findNode(object);
                if (tempNode == null && (project = FileOwnerQuery.getOwner((FileObject)object)) != null && !OpenProjectList.getDefault().isOpen(project)) {
                    DialogDisplayer dd = DialogDisplayer.getDefault();
                    String message = NbBundle.getMessage(ProjectTab.class, (String)"MSG_openProject_confirm", (Object)ProjectUtils.getInformation((Project)project).getDisplayName());
                    String title = NbBundle.getMessage(ProjectTab.class, (String)"MSG_openProject_confirm_title");
                    NotifyDescriptor.Confirmation confirm = new NotifyDescriptor.Confirmation((Object)message, title, 2);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)confirm);
                    if (confirm.getValue() == NotifyDescriptor.OK_OPTION) {
                        if (!OpenProjectList.getDefault().isOpen(project)) {
                            OpenProjects.getDefault().open(new Project[]{project}, false);
                        }
                        tempNode = root.findNode(object);
                    }
                }
                final Node selectedNode = tempNode;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (selectedNode != null) {
                            try {
                                ProjectTab.this.manager.setSelectedNodes(new Node[]{selectedNode});
                                ProjectTab.this.btv.scrollToNode(selectedNode);
                                StatusDisplayer.getDefault().setStatusText("");
                            }
                            catch (PropertyVetoException propertyVetoException) {}
                        } else {
                            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(ProjectTab.class, (String)(ProjectTab.ID_LOGICAL.equals(ProjectTab.this.id) ? "MSG_NodeNotFound_ProjectsTab" : "MSG_NodeNotFound_FilesTab")));
                        }
                        ProjectTab.this.setCursor(null);
                    }
                });
            }
        });
    }

    public boolean selectNode(FileObject object) {
        ProjectsRootNode root = (ProjectsRootNode)this.manager.getRootContext();
        Node selectedNode = root.findNode(object);
        if (selectedNode != null) {
            try {
                this.manager.setSelectedNodes(new Node[]{selectedNode});
                this.btv.scrollToNode(selectedNode);
                return true;
            }
            catch (PropertyVetoException e) {
                return false;
            }
        }
        return false;
    }

    public void expandNode(Node node) {
        this.btv.expandNode(node);
    }

    private List<String[]> getSelectedPaths() {
        Node[] selectedNodes = this.manager.getSelectedNodes();
        ArrayList<String[]> result = new ArrayList<String[]>();
        Node rootNode = this.manager.getRootContext();
        for (int i = 0; i < selectedNodes.length; ++i) {
            String[] path = NodeOp.createPath((Node)selectedNodes[i], (Node)rootNode);
            if (path == null) continue;
            result.add(path);
        }
        return result;
    }

    private void selectPaths(List<String[]> paths) {
        if (paths == null) {
            return;
        }
        ArrayList<Node> selectedNodes = new ArrayList<Node>();
        Node rootNode = this.manager.getRootContext();
        for (String[] sp : paths) {
            try {
                Node n = NodeOp.findPath((Node)rootNode, (String[])sp);
                if (n == null) continue;
                selectedNodes.add(n);
            }
            catch (NodeNotFoundException e) {}
        }
        if (!selectedNodes.isEmpty()) {
            Node[] nodes = new Node[selectedNodes.size()];
            selectedNodes.toArray(nodes);
            try {
                this.manager.setSelectedNodes(nodes);
            }
            catch (PropertyVetoException e) {
                // empty catch block
            }
        }
    }

    private class DelegatingAction
    extends AbstractAction
    implements PropertyChangeListener {
        private Action explorerAction;
        private String projectAction;

        public DelegatingAction(String projectAction, Action explorerAction) {
            this.projectAction = projectAction;
            this.explorerAction = explorerAction;
            ProjectTab.this.manager.addPropertyChangeListener((PropertyChangeListener)this);
            explorerAction.addPropertyChangeListener(this);
        }

        private boolean isProject() {
            Node[] nodes = ProjectTab.this.manager.getSelectedNodes();
            if (nodes.length == 1) {
                return nodes[0].getParentNode() == ProjectTab.this.rootNode;
            }
            return false;
        }

        public void actionPerformed(ActionEvent e) {
            if (this.isProject()) {
                Node[] nodes = ProjectTab.this.manager.getSelectedNodes();
                Project p = (Project)nodes[0].getLookup().lookup(Project.class);
                assert (p != null);
                ActionProvider ap = (ActionProvider)p.getLookup().lookup(ActionProvider.class);
                ap.invokeAction(this.projectAction, nodes[0].getLookup());
            } else {
                this.explorerAction.actionPerformed(e);
            }
        }

        public void updateIsEnabled() {
            if (this.isProject()) {
                Node[] nodes = ProjectTab.this.manager.getSelectedNodes();
                Project p = (Project)nodes[0].getLookup().lookup(Project.class);
                if (p == null) {
                    this.setEnabled(false);
                    return;
                }
                ActionProvider ap = (ActionProvider)p.getLookup().lookup(ActionProvider.class);
                String[] sa = ap != null ? ap.getSupportedActions() : new String[]{};
                int k = sa.length;
                for (int i = 0; i < k; ++i) {
                    if (!"delete".equals(sa[i])) continue;
                    this.setEnabled(ap.isActionEnabled(this.projectAction, nodes[0].getLookup()));
                    return;
                }
                this.setEnabled(false);
            } else {
                this.setEnabled(this.explorerAction.isEnabled());
            }
        }

        public void propertyChange(PropertyChangeEvent evt) {
            this.updateIsEnabled();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ProjectTreeView
    extends BeanTreeView {
        private ProjectTreeView() {
        }

        public void scrollToNode(Node n) {
            TreeNode tn = Visualizer.findVisualizer((Node)n);
            if (tn == null) {
                return;
            }
            TreeModel model = this.tree.getModel();
            if (!(model instanceof DefaultTreeModel)) {
                return;
            }
            TreePath path = new TreePath(((DefaultTreeModel)model).getPathToRoot(tn));
            Rectangle r = this.tree.getPathBounds(path);
            if (r != null) {
                this.tree.scrollRectToVisible(r);
            }
        }

        public List<String[]> getExpandedPaths() {
            ArrayList<String[]> result = new ArrayList<String[]>();
            TreeNode rtn = Visualizer.findVisualizer((Node)ProjectTab.this.rootNode);
            TreePath tp = new TreePath(rtn);
            Enumeration<TreePath> exPaths = this.tree.getExpandedDescendants(tp);
            while (exPaths != null && exPaths.hasMoreElements()) {
                TreePath ep = exPaths.nextElement();
                Node en = Visualizer.findNode((Object)ep.getLastPathComponent());
                String[] path = NodeOp.createPath((Node)en, (Node)ProjectTab.this.rootNode);
                result.add(path);
            }
            return result;
        }

        public void expandNodes(List exPaths) {
            for (String[] sp : exPaths) {
                TreePath tp = this.stringPath2TreePath(sp);
                if (tp == null) continue;
                this.showPath(tp);
            }
        }

        private TreePath stringPath2TreePath(String[] sp) {
            try {
                Node n = NodeOp.findPath((Node)ProjectTab.this.rootNode, (String[])sp);
                Object[] tns = new TreeNode[sp.length + 1];
                for (int i = sp.length; i >= 0; --i) {
                    if (n == null) {
                        return null;
                    }
                    tns[i] = Visualizer.findVisualizer((Node)n);
                    n = n.getParentNode();
                }
                return new TreePath(tns);
            }
            catch (NodeNotFoundException e) {
                return null;
            }
        }
    }
}

