/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.project.ui.ExitDialog;
import org.netbeans.modules.project.ui.ProjectTab;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.openide.ErrorManager;
import org.openide.cookies.EditCookie;
import org.openide.cookies.OpenCookie;
import org.openide.explorer.ExplorerManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.ContextAwareAction;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.windows.CloneableTopComponent;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectUtilities {
    static final String OPEN_FILES_NS = "http://www.netbeans.org/ns/projectui-open-files/1";
    static final String OPEN_FILES_ELEMENT = "open-files";
    static final String FILE_ELEMENT = "file";
    static OpenCloseProjectDocument OPEN_CLOSE_PROJECT_DOCUMENT_IMPL = new OpenCloseProjectDocument(){

        @Override
        public boolean open(FileObject fo) {
            DataObject dobj;
            try {
                dobj = DataObject.find((FileObject)fo);
            }
            catch (DataObjectNotFoundException donfo) {
                assert (false) : "DataObject must exist for " + fo;
                return false;
            }
            EditCookie ec = (EditCookie)dobj.getCookie(EditCookie.class);
            OpenCookie oc = (OpenCookie)dobj.getCookie(OpenCookie.class);
            if (ec != null) {
                ec.edit();
            } else if (oc != null) {
                oc.open();
            } else {
                if (ERR.isLoggable(1)) {
                    ERR.log("No EditCookie nor OpenCookie for " + dobj);
                }
                return false;
            }
            return true;
        }

        @Override
        public Map<Project, SortedSet<String>> close(final Project[] projects, final boolean notifyUI) {
            final Wrapper wr = new Wrapper();
            wr.urls4project = new HashMap<Project, SortedSet<String>>();
            if (SwingUtilities.isEventDispatchThread()) {
                this.doClose(projects, notifyUI, wr);
            } else {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        public void run() {
                            this.doClose(projects, notifyUI, wr);
                        }
                    });
                }
                catch (Exception ex) {
                    ERR.notify(1, (Throwable)ex);
                }
            }
            return wr.urls4project;
        }

        private void doClose(Project[] projects, boolean notifyUI, Wrapper wr) {
            List<Project> listOfProjects = Arrays.asList(projects);
            HashSet<DataObject> openFiles = new HashSet<DataObject>();
            HashSet<TopComponent> tc2close = new HashSet<TopComponent>();
            for (TopComponent tc : WindowManager.getDefault().getRegistry().getOpened()) {
                FileObject fobj;
                Project owner;
                DataObject dobj;
                if (!(tc instanceof CloneableTopComponent) || tc instanceof ExplorerManager.Provider || (dobj = (DataObject)tc.getLookup().lookup(DataObject.class)) == null || !listOfProjects.contains(owner = FileOwnerQuery.getOwner((FileObject)(fobj = dobj.getPrimaryFile())))) continue;
                if (notifyUI) {
                    openFiles.add(dobj);
                    tc2close.add(tc);
                } else if (!dobj.isModified()) {
                    tc2close.add(tc);
                }
                if (!wr.urls4project.containsKey(owner)) {
                    wr.urls4project.put(owner, new TreeSet());
                }
                URL url = null;
                try {
                    url = dobj.getPrimaryFile().getURL();
                    wr.urls4project.get(owner).add(url.toExternalForm());
                }
                catch (FileStateInvalidException fsie) {
                    assert (false) : "FileStateInvalidException in " + dobj.getPrimaryFile();
                }
            }
            if (notifyUI) {
                for (DataObject dobj : DataObject.getRegistry().getModifiedSet()) {
                    FileObject fobj = dobj.getPrimaryFile();
                    Project owner = FileOwnerQuery.getOwner((FileObject)fobj);
                    if (!listOfProjects.contains(owner) || openFiles.contains(dobj)) continue;
                    openFiles.add(dobj);
                }
            }
            if (!notifyUI || !openFiles.isEmpty() && ExitDialog.showDialog(openFiles)) {
                for (TopComponent tc : tc2close) {
                    tc.close();
                }
            } else if (!openFiles.isEmpty()) {
                wr.urls4project = null;
            }
        }
    };
    private static final ErrorManager ERR = ErrorManager.getDefault().getInstance(ProjectUtilities.class.getName());

    private ProjectUtilities() {
    }

    public static void selectAndExpandProject(final Project p) {
        SwingUtilities.invokeLater(new Runnable(){
            final ProjectTab ptLogial = ProjectTab.findDefault("projectTabLogical_tc");

            public void run() {
                Node root = this.ptLogial.getExplorerManager().getRootContext();
                Node projNode = null;
                for (Node n : root.getChildren().getNodes()) {
                    Project prj = (Project)n.getLookup().lookup(Project.class);
                    if (prj == null || !prj.getProjectDirectory().equals(p.getProjectDirectory())) continue;
                    projNode = n;
                    break;
                }
                if (projNode == null) {
                    projNode = root.getChildren().findChild(ProjectUtils.getInformation((Project)p).getName());
                }
                if (projNode != null) {
                    try {
                        this.ptLogial.getExplorerManager().setSelectedNodes(new Node[]{projNode});
                        this.ptLogial.expandNode(projNode);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
    }

    public static void openAndSelectNewObject(final DataObject newDo) {
        Mutex.EVENT.writeAccess(new Runnable(){

            public void run() {
                Node node = newDo.getNodeDelegate();
                Action a = node.getPreferredAction();
                if (a instanceof ContextAwareAction) {
                    a = ((ContextAwareAction)a).createContextAwareInstance(node.getLookup());
                }
                if (a != null) {
                    a.actionPerformed(new ActionEvent(node, 1001, ""));
                }
                final ProjectTab ptLogical = ProjectTab.findDefault("projectTabLogical_tc");
                final ProjectTab ptPhysical = ProjectTab.findDefault("projectTab_tc");
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        boolean success = ptLogical.selectNode(newDo.getPrimaryFile());
                        if (!success) {
                            ptPhysical.selectNode(newDo.getPrimaryFile());
                        }
                    }
                });
            }
        });
    }

    public static void makeProjectTabVisible(boolean requestFocus) {
        ProjectTab ptLogical = ProjectTab.findDefault("projectTabLogical_tc");
        ptLogical.open();
        if (requestFocus) {
            ptLogical.requestActive();
        } else {
            ptLogical.requestVisible();
        }
    }

    public static String canUseFileName(FileObject targetFolder, String folderName, String newObjectName, String extension, boolean allowFileSeparator) {
        assert (newObjectName != null);
        boolean allowSlash = false;
        boolean allowBackslash = false;
        int errorVariant = 0;
        if (allowFileSeparator) {
            if (File.separatorChar == '\\') {
                errorVariant = 3;
                allowBackslash = true;
                allowSlash = true;
            } else {
                errorVariant = 1;
                allowSlash = true;
            }
        }
        if (!allowSlash && newObjectName.indexOf(47) != -1 || !allowBackslash && newObjectName.indexOf(92) != -1) {
            assert (errorVariant == 0 || errorVariant == 1) : "Invalid error variant: " + errorVariant;
            return NbBundle.getMessage(ProjectUtilities.class, (String)"MSG_not_valid_filename", (Object)newObjectName, (Object)new Integer(errorVariant));
        }
        if (targetFolder == null) {
            return NbBundle.getMessage(ProjectUtilities.class, (String)"MSG_fs_or_folder_does_not_exist");
        }
        if (!targetFolder.canWrite()) {
            return NbBundle.getMessage(ProjectUtilities.class, (String)"MSG_fs_is_readonly");
        }
        StringBuffer relFileName = new StringBuffer();
        if (folderName != null) {
            if (!allowBackslash && folderName.indexOf(92) != -1) {
                return NbBundle.getMessage(ProjectUtilities.class, (String)"MSG_not_valid_folder", (Object)folderName, (Object)new Integer(1));
            }
            relFileName.append(folderName);
            relFileName.append('/');
        }
        relFileName.append(newObjectName);
        if (extension != null && extension.length() != 0) {
            relFileName.append('.');
            relFileName.append(extension);
        }
        if (targetFolder.getFileObject(relFileName.toString()) != null) {
            return NbBundle.getMessage(ProjectUtilities.class, (String)"MSG_file_already_exist", (Object)newObjectName);
        }
        return null;
    }

    public static boolean closeAllDocuments(Project[] projects, boolean notifyUI) {
        if (projects == null) {
            throw new IllegalArgumentException("No projects are specified.");
        }
        if (projects.length == 0) {
            return true;
        }
        Map<Project, SortedSet<String>> urls4project = OPEN_CLOSE_PROJECT_DOCUMENT_IMPL.close(projects, notifyUI);
        if (urls4project != null) {
            for (Map.Entry<Project, SortedSet<String>> entry : urls4project.entrySet()) {
                ProjectUtilities.storeProjectOpenFiles(entry.getKey(), entry.getValue());
            }
        }
        return urls4project != null;
    }

    private static void storeProjectOpenFiles(Project p, SortedSet<String> urls) {
        AuxiliaryConfiguration aux = (AuxiliaryConfiguration)p.getLookup().lookup(AuxiliaryConfiguration.class);
        if (aux != null) {
            aux.removeConfigurationFragment(OPEN_FILES_ELEMENT, OPEN_FILES_NS, false);
            Document xml = XMLUtil.createDocument((String)OPEN_FILES_ELEMENT, (String)OPEN_FILES_NS, null, null);
            Element openFiles = xml.createElementNS(OPEN_FILES_NS, OPEN_FILES_ELEMENT);
            for (String url : urls) {
                Element fileEl = openFiles.getOwnerDocument().createElement(FILE_ELEMENT);
                fileEl.appendChild(fileEl.getOwnerDocument().createTextNode(url));
                openFiles.appendChild(fileEl);
            }
            aux.putConfigurationFragment(openFiles, false);
        }
    }

    public static void openProjectFiles(Project p) {
        AuxiliaryConfiguration aux;
        boolean dolog = ERR.isLoggable(1);
        if (dolog) {
            ERR.log("Trying to open files from " + p + "...");
        }
        if ((aux = (AuxiliaryConfiguration)p.getLookup().lookup(AuxiliaryConfiguration.class)) == null) {
            if (dolog) {
                ERR.log("No AuxiliaryConfiguration in " + p);
            }
            return;
        }
        Element openFiles = aux.getConfigurationFragment(OPEN_FILES_ELEMENT, OPEN_FILES_NS, false);
        if (openFiles == null) {
            if (dolog) {
                ERR.log("No open-files in private.xml");
            }
            return;
        }
        NodeList list = openFiles.getElementsByTagName(FILE_ELEMENT);
        if (list == null) {
            if (dolog) {
                ERR.log("No file in open-files");
            }
            return;
        }
        for (int i = 0; i < list.getLength(); ++i) {
            FileObject fo;
            String url = list.item(i).getChildNodes().item(0).getNodeValue();
            if (dolog) {
                ERR.log("Will try to open " + url);
            }
            try {
                fo = URLMapper.findFileObject((URL)new URL(url));
            }
            catch (MalformedURLException mue) {
                assert (false) : "MalformedURLException in " + url;
                continue;
            }
            if (fo == null) {
                if (!dolog) continue;
                ERR.log("Could not find " + url);
                continue;
            }
            OPEN_CLOSE_PROJECT_DOCUMENT_IMPL.open(fo);
        }
        aux.removeConfigurationFragment(OPEN_FILES_ELEMENT, OPEN_FILES_NS, false);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface OpenCloseProjectDocument {
        public boolean open(FileObject var1);

        public Map<Project, SortedSet<String>> close(Project[] var1, boolean var2);
    }

    public static class WaitCursor
    implements Runnable {
        private boolean show;

        private WaitCursor(boolean show) {
            this.show = show;
        }

        public static void show() {
            WaitCursor.invoke(new WaitCursor(true));
        }

        public static void hide() {
            WaitCursor.invoke(new WaitCursor(false));
        }

        private static void invoke(WaitCursor wc) {
            if (SwingUtilities.isEventDispatchThread()) {
                wc.run();
            } else {
                SwingUtilities.invokeLater(wc);
            }
        }

        public void run() {
            try {
                JFrame f = (JFrame)WindowManager.getDefault().getMainWindow();
                Component c = f.getGlassPane();
                c.setVisible(this.show);
                c.setCursor(this.show ? Cursor.getPredefinedCursor(3) : null);
            }
            catch (NullPointerException npe) {
                ErrorManager.getDefault().notify(1, (Throwable)npe);
            }
        }
    }

    private static class Wrapper {
        Map<Project, SortedSet<String>> urls4project;

        private Wrapper() {
        }
    }
}

