/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui;

import java.awt.Component;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.modules.project.ui.TemplateChooserPanelGUI;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.TemplateWizard;
import org.openide.util.ChangeSupport;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

final class TemplateChooserPanel
implements WizardDescriptor.Panel,
ChangeListener {
    private static String lastCategory = null;
    private static String lastTemplate = null;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private TemplateChooserPanelGUI gui;
    private Project project;

    TemplateChooserPanel(Project p) {
        this.project = p;
    }

    public Component getComponent() {
        if (this.gui == null) {
            this.gui = new TemplateChooserPanelGUI();
            this.gui.addChangeListener(this);
        }
        return this.gui;
    }

    public HelpCtx getHelp() {
        return null;
    }

    public boolean isValid() {
        return this.gui != null && this.gui.getTemplate() != null;
    }

    public void addChangeListener(ChangeListener l) {
        this.changeSupport.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.changeSupport.removeChangeListener(l);
    }

    public void readSettings(Object settings) {
        TemplateChooserPanelGUI panel = (TemplateChooserPanelGUI)this.getComponent();
        panel.readValues(this.project, lastCategory, lastTemplate);
        ((WizardDescriptor)settings).putProperty("WizardPanel_contentSelectedIndex", (Object)new Integer(0));
        ((WizardDescriptor)settings).putProperty("WizardPanel_contentData", (Object)new String[]{NbBundle.getBundle(TemplateChooserPanel.class).getString("LBL_TemplatesPanel_Name"), NbBundle.getBundle(TemplateChooserPanel.class).getString("LBL_TemplatesPanel_Dots")});
        ((WizardDescriptor)settings).putProperty("NewFileWizard_Title", null);
    }

    public void storeSettings(Object settings) {
        WizardDescriptor wd = (WizardDescriptor)settings;
        Object value = wd.getValue();
        if (NotifyDescriptor.CANCEL_OPTION != value && NotifyDescriptor.CLOSED_OPTION != value) {
            try {
                Project newProject = this.gui.getProject();
                if (!this.project.equals(newProject)) {
                    this.project = newProject;
                    wd.putProperty("project", (Object)newProject);
                }
                if (this.gui.getTemplate() == null) {
                    return;
                }
                if (wd instanceof TemplateWizard) {
                    ((TemplateWizard)wd).setTemplate(DataObject.find((FileObject)this.gui.getTemplate()));
                } else {
                    wd.putProperty("targetTemplate", (Object)this.gui.getTemplate());
                }
                lastCategory = this.gui.getCategoryName();
                lastTemplate = this.gui.getTemplateName();
            }
            catch (DataObjectNotFoundException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }
    }

    public void stateChanged(ChangeEvent e) {
        this.changeSupport.fireChange();
    }
}

