/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui.actions;

import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.spi.project.ActionProvider;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.Lookup;
import org.openide.util.WeakSet;

class ActionsUtil {
    public static final ShortcutsManager SHORCUTS_MANAGER = new ShortcutsManager();
    public static HashMap<String, MessageFormat> pattern2format = new HashMap();

    ActionsUtil() {
    }

    public static Project[] getProjectsFromLookup(Lookup lookup, String command) {
        HashSet<Project> result = new HashSet<Project>();
        for (Project p : lookup.lookupAll(Project.class)) {
            result.add(p);
        }
        for (DataObject dObj : lookup.lookupAll(DataObject.class)) {
            FileObject fObj = dObj.getPrimaryFile();
            Project p = FileOwnerQuery.getOwner((FileObject)fObj);
            if (p == null) continue;
            result.add(p);
        }
        Project[] projectsArray = result.toArray(new Project[result.size()]);
        if (command != null) {
            for (Project p : projectsArray) {
                if (ActionsUtil.commandSupported(p, command, lookup)) continue;
                return new Project[0];
            }
        }
        return projectsArray;
    }

    public static FileObject[] getFilesFromLookup(Lookup lookup, Project project) {
        HashSet<FileObject> result = new HashSet<FileObject>();
        for (DataObject dObj : lookup.lookupAll(DataObject.class)) {
            FileObject fObj = dObj.getPrimaryFile();
            Project p = FileOwnerQuery.getOwner((FileObject)fObj);
            if (p == null || !p.equals(project)) continue;
            result.add(fObj);
        }
        FileObject[] fos = new FileObject[result.size()];
        result.toArray(fos);
        return fos;
    }

    public static boolean commandSupported(Project project, String command, Lookup context) {
        List<String> commands;
        ActionProvider ap = (ActionProvider)project.getLookup().lookup(ActionProvider.class);
        return ap != null && (commands = Arrays.asList(ap.getSupportedActions())).contains(command) && (context == null || ap.isActionEnabled(command, context));
    }

    public static String formatProjectSensitiveName(String namePattern, Project[] projects) {
        if (projects == null || projects.length == 0) {
            return ActionsUtil.formatName(namePattern, 0, null);
        }
        return ActionsUtil.formatName(namePattern, projects.length, ProjectUtils.getInformation((Project)projects[0]).getDisplayName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatName(String namePattern, int numberOfObjects, String firstObjectName) {
        MessageFormat mf = null;
        HashMap<String, MessageFormat> hashMap = pattern2format;
        synchronized (hashMap) {
            mf = pattern2format.get(namePattern);
            if (mf == null) {
                mf = new MessageFormat(namePattern);
                pattern2format.put(namePattern, mf);
            }
        }
        StringBuffer result = new StringBuffer();
        mf.format(new Object[]{numberOfObjects, firstObjectName == null ? "" : firstObjectName}, result, (FieldPosition)null);
        return result.toString();
    }

    public static class ShortcutsManager {
        Map<String, Object> shorcuts = new HashMap<String, Object>();
        HashMap<String, Set<Action>> actions = new HashMap();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void registerAction(String command, Action action) {
            ShortcutsManager shortcutsManager = this;
            synchronized (shortcutsManager) {
                WeakSet commandActions = this.actions.get(command);
                if (commandActions == null) {
                    commandActions = new WeakSet();
                    this.actions.put(command, (Set<Action>)commandActions);
                }
                commandActions.add((Action)action);
            }
            Object shorcut = this.getShortcut(command);
            if (shorcut != null) {
                action.putValue("AcceleratorKey", shorcut);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void registerShortcut(String command, Object shortcut) {
            HashSet<Action> actionsToChange = null;
            ShortcutsManager shortcutsManager = this;
            synchronized (shortcutsManager) {
                Object exShorcut = this.getShortcut(command);
                if (exShorcut != null && exShorcut.equals(shortcut) || exShorcut == null && shortcut == null) {
                    return;
                }
                this.shorcuts.put(command, shortcut);
                Set<Action> commandActions = this.actions.get(command);
                if (commandActions != null && !commandActions.isEmpty()) {
                    actionsToChange = new HashSet<Action>();
                    actionsToChange.addAll(commandActions);
                }
            }
            if (actionsToChange != null) {
                for (Action a : actionsToChange) {
                    if (a == null) continue;
                    a.putValue("AcceleratorKey", shortcut);
                }
            }
        }

        public synchronized Object getShortcut(String command) {
            return this.shorcuts.get(command);
        }
    }
}

