/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui.actions;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.project.ui.OpenProjectList;
import org.netbeans.spi.project.ProjectConfiguration;
import org.netbeans.spi.project.ProjectConfigurationProvider;
import org.openide.awt.Actions;
import org.openide.awt.DynamicMenuContent;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.MultiFileSystem;
import org.openide.util.ContextAwareAction;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;
import org.openide.util.actions.CallableSystemAction;
import org.openide.util.actions.Presenter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActiveConfigAction
extends CallableSystemAction
implements ContextAwareAction {
    private static final Logger LOGGER = Logger.getLogger(ActiveConfigAction.class.getName());
    private static final DefaultComboBoxModel EMPTY_MODEL = new DefaultComboBoxModel();
    private static final Object CUSTOMIZE_ENTRY = new Object();
    private final PropertyChangeListener lst;
    private final JComboBox configListCombo;
    private boolean listeningToCombo = true;
    private Project currentProject;
    private ProjectConfigurationProvider pcp;

    public ActiveConfigAction() {
        this.putValue("noIconInMenu", Boolean.TRUE);
        this.configListCombo = new JComboBox();
        this.configListCombo.setRenderer(new ConfigCellRenderer());
        this.configListCombo.setToolTipText(Actions.cutAmpersand((String)this.getName()));
        this.configurationsListChanged(null);
        this.configListCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (!ActiveConfigAction.this.listeningToCombo) {
                    return;
                }
                Object o = ActiveConfigAction.this.configListCombo.getSelectedItem();
                if (o == CUSTOMIZE_ENTRY) {
                    ActiveConfigAction.this.activeConfigurationChanged(ActiveConfigAction.this.pcp != null ? ActiveConfigAction.getActiveConfiguration(ActiveConfigAction.this.pcp) : null);
                    ActiveConfigAction.this.pcp.customize();
                } else if (o != null) {
                    ActiveConfigAction.this.activeConfigurationSelected((ProjectConfiguration)o);
                }
            }
        });
        this.lst = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if ("configurations".equals(evt.getPropertyName())) {
                    ActiveConfigAction.this.configurationsListChanged(ActiveConfigAction.getConfigurations(ActiveConfigAction.this.pcp));
                } else if ("activeConfiguration".equals(evt.getPropertyName())) {
                    ActiveConfigAction.this.activeConfigurationChanged(ActiveConfigAction.getActiveConfiguration(ActiveConfigAction.this.pcp));
                }
            }
        };
        this.activeProjectChanged(OpenProjectList.getDefault().getMainProject());
        OpenProjectList.getDefault().addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if ("MainProject".equals(evt.getPropertyName())) {
                    ActiveConfigAction.this.activeProjectChanged(OpenProjectList.getDefault().getMainProject());
                }
            }
        });
    }

    private synchronized void configurationsListChanged(Collection<? extends ProjectConfiguration> configs) {
        LOGGER.log(Level.FINER, "configurationsListChanged: {0}", configs);
        if (configs == null) {
            this.configListCombo.setModel(EMPTY_MODEL);
            DynLayer.INSTANCE.setEnabled(false);
            this.configListCombo.setEnabled(false);
        } else {
            DefaultComboBoxModel<Object> model = new DefaultComboBoxModel<Object>(configs.toArray());
            if (this.pcp.hasCustomizer()) {
                model.addElement(CUSTOMIZE_ENTRY);
            }
            this.configListCombo.setModel(model);
            DynLayer.INSTANCE.setEnabled(true);
            this.configListCombo.setEnabled(true);
        }
        if (this.pcp != null) {
            this.activeConfigurationChanged(ActiveConfigAction.getActiveConfiguration(this.pcp));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void activeConfigurationChanged(ProjectConfiguration config) {
        block4: {
            LOGGER.log(Level.FINER, "activeConfigurationChanged: {0}", config);
            this.listeningToCombo = false;
            try {
                this.configListCombo.setSelectedIndex(-1);
                if (config == null) break block4;
                ComboBoxModel m = this.configListCombo.getModel();
                for (int i = 0; i < m.getSize(); ++i) {
                    if (!config.equals(m.getElementAt(i))) continue;
                    this.configListCombo.setSelectedIndex(i);
                    break;
                }
            }
            finally {
                this.listeningToCombo = true;
            }
        }
    }

    private synchronized void activeConfigurationSelected(ProjectConfiguration cfg) {
        LOGGER.log(Level.FINER, "activeConfigurationSelected: {0}", cfg);
        if (this.pcp != null && cfg != null && !cfg.equals(ActiveConfigAction.getActiveConfiguration(this.pcp))) {
            try {
                ActiveConfigAction.setActiveConfiguration(this.pcp, cfg);
            }
            catch (IOException x) {
                LOGGER.log(Level.WARNING, null, x);
            }
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(ActiveConfigAction.class);
    }

    public String getName() {
        return NbBundle.getMessage(ActiveConfigAction.class, (String)"ActiveConfigAction.label");
    }

    public void performAction() {
        assert (false);
    }

    public Component getToolbarPresenter() {
        JPanel toolbarPanel = new JPanel(new GridBagLayout());
        toolbarPanel.setOpaque(false);
        toolbarPanel.setMaximumSize(new Dimension(150, 80));
        toolbarPanel.setMinimumSize(new Dimension(150, 0));
        toolbarPanel.setPreferredSize(new Dimension(150, 23));
        toolbarPanel.add((Component)this.configListCombo, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 2, new Insets(1, 6, 1, 5), 0, 0));
        return toolbarPanel;
    }

    public JMenuItem getMenuPresenter() {
        return new ConfigMenu(null);
    }

    private synchronized void activeProjectChanged(Project p) {
        LOGGER.log(Level.FINER, "activeProjectChanged: {0} -> {1}", new Object[]{this.currentProject, p});
        if (this.currentProject != p) {
            if (this.pcp != null) {
                this.pcp.removePropertyChangeListener(this.lst);
            }
            this.currentProject = p;
            if (this.currentProject != null) {
                this.pcp = (ProjectConfigurationProvider)this.currentProject.getLookup().lookup(ProjectConfigurationProvider.class);
                if (this.pcp != null) {
                    this.pcp.addPropertyChangeListener(this.lst);
                }
            } else {
                this.pcp = null;
            }
            this.configurationsListChanged(this.pcp == null ? null : ActiveConfigAction.getConfigurations(this.pcp));
        }
    }

    public Action createContextAwareInstance(final Lookup actionContext) {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class A
        extends AbstractAction
        implements Presenter.Popup {
            A() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                assert (false);
            }

            public JMenuItem getPopupPresenter() {
                return new ConfigMenu(actionContext);
            }
        }
        return new A();
    }

    private static Collection<? extends ProjectConfiguration> getConfigurations(final ProjectConfigurationProvider<?> pcp) {
        return (Collection)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<Collection<? extends ProjectConfiguration>>(){

            public Collection<? extends ProjectConfiguration> run() {
                return pcp.getConfigurations();
            }
        });
    }

    private static ProjectConfiguration getActiveConfiguration(final ProjectConfigurationProvider<?> pcp) {
        return (ProjectConfiguration)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<ProjectConfiguration>(){

            public ProjectConfiguration run() {
                return pcp.getActiveConfiguration();
            }
        });
    }

    private static void setActiveConfiguration(ProjectConfigurationProvider<?> pcp, final ProjectConfiguration pc) throws IOException {
        final ProjectConfigurationProvider<?> _pcp = pcp;
        try {
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                public Void run() throws IOException {
                    _pcp.setActiveConfiguration(pc);
                    return null;
                }
            });
        }
        catch (MutexException e) {
            throw (IOException)e.getException();
        }
    }

    private static class ConfigCellRenderer
    extends JLabel
    implements ListCellRenderer,
    UIResource {
        private Border defaultBorder = this.getBorder();

        public ConfigCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setName("ComboBox.listRenderer");
            String label = null;
            if (value instanceof ProjectConfiguration) {
                label = ((ProjectConfiguration)value).getDisplayName();
                this.setBorder(this.defaultBorder);
            } else if (value == CUSTOMIZE_ENTRY) {
                label = Actions.cutAmpersand((String)NbBundle.getMessage(ActiveConfigAction.class, (String)"ActiveConfigAction.customize"));
                this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, UIManager.getColor("controlDkShadow")), this.defaultBorder));
            } else {
                assert (value == null);
                label = null;
                this.setBorder(this.defaultBorder);
            }
            this.setText(label);
            this.setIcon(null);
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            return this;
        }

        public String getName() {
            String name = super.getName();
            return name == null ? "ComboBox.renderer" : name;
        }
    }

    class ConfigMenu
    extends JMenu
    implements DynamicMenuContent {
        private final Lookup context;

        public ConfigMenu(Lookup context) {
            this.context = context;
            if (context != null) {
                Mnemonics.setLocalizedText((AbstractButton)this, (String)NbBundle.getMessage(ActiveConfigAction.class, (String)"ActiveConfigAction.context.label"));
            } else {
                Mnemonics.setLocalizedText((AbstractButton)this, (String)ActiveConfigAction.this.getName());
            }
        }

        public JComponent[] getMenuPresenters() {
            Collection projects;
            this.removeAll();
            Object pcp = this.context != null ? ((projects = this.context.lookupAll(Project.class)).size() == 1 ? (ProjectConfigurationProvider)((Project)projects.iterator().next()).getLookup().lookup(ProjectConfigurationProvider.class) : null) : ActiveConfigAction.this.pcp;
            if (pcp != null) {
                boolean something = false;
                ProjectConfiguration activeConfig = ActiveConfigAction.getActiveConfiguration(pcp);
                for (final ProjectConfiguration config : ActiveConfigAction.getConfigurations(pcp)) {
                    JRadioButtonMenuItem jmi = new JRadioButtonMenuItem(config.getDisplayName(), config.equals(activeConfig));
                    jmi.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            ActiveConfigAction.this.activeConfigurationSelected(config);
                        }
                    });
                    this.add(jmi);
                    something = true;
                }
                if (pcp.hasCustomizer()) {
                    if (something) {
                        this.addSeparator();
                    }
                    something = true;
                    JMenuItem customize = new JMenuItem();
                    Mnemonics.setLocalizedText((AbstractButton)customize, (String)NbBundle.getMessage(ActiveConfigAction.class, (String)"ActiveConfigAction.customize"));
                    customize.addActionListener(new ActionListener((ProjectConfigurationProvider)pcp){
                        final /* synthetic */ ProjectConfigurationProvider val$pcp;
                        {
                            this.val$pcp = projectConfigurationProvider;
                        }

                        public void actionPerformed(ActionEvent e) {
                            this.val$pcp.customize();
                        }
                    });
                    this.add(customize);
                }
                this.setEnabled(something);
            } else {
                this.setEnabled(false);
            }
            return new JComponent[]{this};
        }

        public JComponent[] synchMenuPresenters(JComponent[] items) {
            return this.getMenuPresenters();
        }
    }

    public static final class DynLayer
    extends MultiFileSystem {
        static DynLayer INSTANCE;
        private final FileSystem fragment;

        public DynLayer() {
            INSTANCE = this;
            this.fragment = FileUtil.createMemoryFileSystem();
            try {
                FileUtil.createData((FileObject)this.fragment.getRoot(), (String)"Toolbars/Build/org-netbeans-modules-project-ui-actions-ActiveConfigAction.shadow").setAttribute("originalFile", (Object)"Actions/Project/org-netbeans-modules-project-ui-actions-ActiveConfigAction.instance");
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
        }

        void setEnabled(boolean enabled) {
            if (enabled) {
                this.setDelegates(new FileSystem[]{this.fragment});
            } else {
                this.setDelegates(new FileSystem[0]);
            }
        }
    }
}

