/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui.actions;

import java.util.HashSet;
import java.util.List;
import javax.swing.Action;
import javax.swing.JMenuItem;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.project.ui.ExitDialog;
import org.netbeans.modules.project.ui.actions.ActionsUtil;
import org.netbeans.modules.project.ui.actions.ProjectAction;
import org.netbeans.spi.project.support.ProjectOperations;
import org.netbeans.spi.project.ui.CustomizerProvider;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.Presenter;

public class CustomizeProject
extends ProjectAction
implements Presenter.Popup {
    private static final String namePattern = NbBundle.getMessage(CustomizeProject.class, (String)"LBL_CustomizeProjectAction_Name");
    private static final String namePatternPopup = NbBundle.getMessage(CustomizeProject.class, (String)"LBL_CustomizeProjectAction_Popup_Name");

    public CustomizeProject() {
        this((Lookup)null);
    }

    public CustomizeProject(Lookup context) {
        super((String)null, namePattern, null, context);
        this.refresh(this.getLookup());
    }

    protected void refresh(Lookup context) {
        super.refresh(context);
        Project[] projects = ActionsUtil.getProjectsFromLookup(context, null);
        if (projects.length != 1 || projects[0].getLookup().lookup(CustomizerProvider.class) == null) {
            this.setEnabled(false);
        } else {
            this.setEnabled(true);
        }
    }

    public void actionPerformed(Lookup context) {
        CustomizerProvider cp;
        Project[] projects = ActionsUtil.getProjectsFromLookup(context, null);
        if (projects.length == 1 && (cp = (CustomizerProvider)projects[0].getLookup().lookup(CustomizerProvider.class)) != null) {
            if (!DataObject.getRegistry().getModifiedSet().isEmpty()) {
                HashSet<DataObject> candidates = new HashSet<DataObject>();
                List dataFiles = ProjectOperations.getDataFiles((Project)projects[0]);
                boolean opSupported = ProjectOperations.isCopyOperationSupported((Project)projects[0]) || ProjectOperations.isMoveOperationSupported((Project)projects[0]) || ProjectOperations.isDeleteOperationSupported((Project)projects[0]);
                for (DataObject dobj : DataObject.getRegistry().getModifiedSet()) {
                    if (projects[0] != FileOwnerQuery.getOwner((FileObject)dobj.getPrimaryFile())) continue;
                    boolean found = false;
                    for (FileObject df : dataFiles) {
                        if (!df.equals(dobj.getPrimaryFile()) && (!df.isFolder() || !FileUtil.isParentOf((FileObject)df, (FileObject)dobj.getPrimaryFile()))) continue;
                        found = true;
                        break;
                    }
                    if (found && opSupported) continue;
                    candidates.add(dobj);
                }
                if (!candidates.isEmpty()) {
                    String saveAll = NbBundle.getMessage(CustomizeProject.class, (String)"CustomizeProject.saveAll");
                    Object ret = DialogDisplayer.getDefault().notify(new NotifyDescriptor((Object)NbBundle.getMessage(CustomizeProject.class, (String)"CustomizeProject.save_modified_files"), NbBundle.getMessage(CustomizeProject.class, (String)"CustomizeProject.save_modified_title"), 2, 2, new Object[]{saveAll, NotifyDescriptor.CANCEL_OPTION}, (Object)saveAll));
                    if (ret != saveAll) {
                        return;
                    }
                    for (DataObject dobj : candidates) {
                        ExitDialog.doSave(dobj);
                    }
                }
            }
            cp.showCustomizer();
        }
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        return new CustomizeProject(actionContext);
    }

    public JMenuItem getPopupPresenter() {
        JMenuItem popupPresenter = new JMenuItem(this);
        popupPresenter.setText(namePatternPopup);
        popupPresenter.setIcon(null);
        return popupPresenter;
    }
}

