/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui.actions;

import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.netbeans.api.project.Project;
import org.netbeans.modules.project.ui.actions.ActionsUtil;
import org.netbeans.modules.project.ui.actions.ProjectAction;
import org.netbeans.spi.project.ActionProvider;
import org.openide.awt.Actions;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.Utilities;

public final class FileCommandAction
extends ProjectAction {
    private String presenterName;

    public FileCommandAction(String command, String namePattern, String iconResource, Lookup lookup) {
        this(command, namePattern, (Icon)new ImageIcon(Utilities.loadImage((String)iconResource)), lookup);
    }

    public FileCommandAction(String command, String namePattern, Icon icon, Lookup lookup) {
        super(command, namePattern, icon, lookup);
        assert (namePattern != null) : "Name patern must not be null";
        this.presenterName = ActionsUtil.formatName(this.getNamePattern(), 0, "");
        this.setDisplayName(this.presenterName);
        this.putValue("ShortDescription", Actions.cutAmpersand((String)this.presenterName));
    }

    protected void refresh(Lookup context) {
        Project[] projects = ActionsUtil.getProjectsFromLookup(context, this.getCommand());
        if (projects.length != 1) {
            this.setEnabled(false);
            this.presenterName = ActionsUtil.formatName(this.getNamePattern(), 0, "");
        } else {
            FileObject[] files = ActionsUtil.getFilesFromLookup(context, projects[0]);
            this.setEnabled(true);
            this.presenterName = ActionsUtil.formatName(this.getNamePattern(), files.length, files.length > 0 ? files[0].getNameExt() : "");
        }
        this.setLocalizedTextToMenuPresented(this.presenterName);
        this.putValue("ShortDescription", Actions.cutAmpersand((String)this.presenterName));
    }

    protected void actionPerformed(Lookup context) {
        Project[] projects = ActionsUtil.getProjectsFromLookup(context, this.getCommand());
        if (projects.length == 1) {
            ActionProvider ap = (ActionProvider)projects[0].getLookup().lookup(ActionProvider.class);
            ap.invokeAction(this.getCommand(), context);
        }
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        return new FileCommandAction(this.getCommand(), this.getNamePattern(), (Icon)this.getValue("SmallIcon"), actionContext);
    }
}

