/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui.actions;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.modules.project.ui.NoMainProjectWarning;
import org.netbeans.modules.project.ui.OpenProjectList;
import org.netbeans.modules.project.ui.actions.ActionsUtil;
import org.netbeans.modules.project.ui.actions.BasicAction;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.ProjectConfiguration;
import org.netbeans.spi.project.ProjectConfigurationProvider;
import org.netbeans.spi.project.ui.support.ProjectActionPerformer;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Actions;
import org.openide.awt.MouseUtils;
import org.openide.awt.ToolbarPool;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.actions.Presenter;
import org.openide.util.lookup.Lookups;

public class MainProjectAction
extends BasicAction
implements Presenter.Toolbar,
PropertyChangeListener {
    private String command;
    private ProjectActionPerformer performer;
    private String name;
    private static final boolean SHOW_CONFIG_DROPDOWN = Boolean.getBoolean("org.netbeans.modules.project.ui.actions.MainProjectAction.SHOW_CONFIG_DROPDOWN");
    private static final String PREFERRED_ICON_SIZE = "PreferredIconSize";

    public MainProjectAction(ProjectActionPerformer performer, String name, Icon icon) {
        this(null, performer, name, icon);
    }

    public MainProjectAction(String command, String name, Icon icon) {
        this(command, null, name, icon);
    }

    public MainProjectAction(String command, ProjectActionPerformer performer, String name, Icon icon) {
        this.command = command;
        this.performer = performer;
        this.name = name;
        this.setDisplayName(name);
        if (icon != null) {
            this.setSmallIcon(icon);
        }
        this.refreshView();
        OpenProjectList.getDefault().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)OpenProjectList.getDefault()));
    }

    public void actionPerformed(ActionEvent e) {
        Project p = OpenProjectList.getDefault().getMainProject();
        if (p == null) {
            if (this.showNoMainProjectWarning(OpenProjectList.getDefault().getOpenProjects(), this.name)) {
                return;
            }
            p = OpenProjectList.getDefault().getMainProject();
        }
        if (this.command != null) {
            ActionProvider ap = (ActionProvider)p.getLookup().lookup(ActionProvider.class);
            if (Arrays.asList(ap.getSupportedActions()).contains(this.command)) {
                ap.invokeAction(this.command, Lookup.EMPTY);
            } else {
                Toolkit.getDefaultToolkit().beep();
                this.refreshView();
            }
        } else {
            this.performer.perform(p);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName() == "MainProject" || evt.getPropertyName() == "OpenProjects") {
            Mutex.EVENT.readAccess(new Runnable(){

                public void run() {
                    MainProjectAction.this.refreshView();
                }
            });
        }
    }

    private void refreshView() {
        boolean noOpenProject;
        Project p = OpenProjectList.getDefault().getMainProject();
        boolean bl = noOpenProject = OpenProjectList.getDefault().getOpenProjects().length == 0;
        if (this.command == null) {
            this.setEnabled(this.performer.enable(p));
        } else if (p == null) {
            this.setEnabled(!noOpenProject);
        } else if (ActionsUtil.commandSupported(p, this.command, Lookup.EMPTY)) {
            this.setEnabled(!noOpenProject);
        } else {
            this.setEnabled(false);
        }
    }

    private boolean showNoMainProjectWarning(Project[] projects, String action) {
        boolean canceled;
        final JButton okButton = new JButton(NbBundle.getMessage(NoMainProjectWarning.class, (String)"LBL_NoMainClassWarning_ChooseMainProject_OK"));
        okButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NoMainProjectWarning.class, (String)"AD_NoMainClassWarning_ChooseMainProject_OK"));
        final NoMainProjectWarning panel = new NoMainProjectWarning(projects);
        Object[] options = new Object[]{okButton, DialogDescriptor.CANCEL_OPTION};
        panel.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (e.getSource() instanceof MouseEvent && MouseUtils.isDoubleClick((MouseEvent)((MouseEvent)e.getSource()))) {
                    if (panel.getSelectedProject() != null) {
                        okButton.doClick();
                    }
                } else {
                    okButton.setEnabled(panel.getSelectedProject() != null);
                }
            }
        });
        okButton.setEnabled(panel.getSelectedProject() != null);
        DialogDescriptor desc = new DialogDescriptor((Object)panel, action == null ? NbBundle.getMessage(NoMainProjectWarning.class, (String)"CTL_NoMainProjectWarning_Title") : Actions.cutAmpersand((String)action), true, options, options[0], 0, null, null);
        desc.setMessageType(1);
        Dialog dlg = DialogDisplayer.getDefault().createDialog(desc);
        dlg.setVisible(true);
        if (desc.getValue() != options[0]) {
            canceled = true;
        } else {
            Project mainProject = panel.getSelectedProject();
            OpenProjectList.getDefault().setMainProject(mainProject);
            canceled = false;
        }
        dlg.dispose();
        return canceled;
    }

    public Component getToolbarPresenter() {
        final JButton main = new JButton();
        Actions.connect((AbstractButton)main, (Action)this);
        if (!SHOW_CONFIG_DROPDOWN) {
            return main;
        }
        final JPanel panel = new JPanel(new BorderLayout());
        panel.addPropertyChangeListener(PREFERRED_ICON_SIZE, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                main.putClientProperty(MainProjectAction.PREFERRED_ICON_SIZE, panel.getClientProperty(MainProjectAction.PREFERRED_ICON_SIZE));
            }
        });
        panel.setBorder(new EmptyBorder(0, 0, 0, 0));
        panel.add((Component)main, "Center");
        ConfigButton configs = new ConfigButton(main.getPreferredSize().height);
        panel.add((Component)configs, "After");
        return panel;
    }

    private static final class ArrowIcon
    implements Icon {
        private static final int SIZE = 6;
        private static final int HEIGHT = ToolbarPool.getDefault().getPreferredIconSize();
        private static final int PAD = 3;

        private ArrowIcon() {
        }

        public int getIconWidth() {
            return 17;
        }

        public int getIconHeight() {
            return Math.max(12, HEIGHT);
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.setColor(Color.BLACK);
            int offx = 3;
            int offy = (g.getClipBounds().height - 6) / 2;
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.fillPolygon(new int[]{offx, offx + 12 - 2, offx + 6 - 1}, new int[]{offy, offy, offy + 6 - 1}, 3);
        }
    }

    private final class ConfigButton
    extends JButton
    implements PropertyChangeListener,
    ActionListener {
        private final PropertyChangeListener pcl;
        private JPopupMenu menu;

        public ConfigButton(int height) {
            super(new ArrowIcon());
            this.pcl = WeakListeners.propertyChange((PropertyChangeListener)this, null);
            OpenProjectList.getDefault().addPropertyChangeListener(this.pcl);
            this.propertyChange(null);
            this.addActionListener(this);
            this.setPreferredSize(new Dimension(this.getIcon().getIconWidth(), height));
            this.setFocusPainted(false);
        }

        public void propertyChange(PropertyChangeEvent evt) {
            String prop;
            String string = prop = evt != null ? evt.getPropertyName() : null;
            if (prop == null || prop.equals("MainProject") || prop.equals("configurations")) {
                Mutex.EVENT.readAccess(new Runnable(){

                    public void run() {
                        ProjectConfigurationProvider pcp;
                        ActionProvider ap;
                        boolean v = false;
                        Project p = OpenProjectList.getDefault().getMainProject();
                        if (p != null && (ap = (ActionProvider)p.getLookup().lookup(ActionProvider.class)) != null && Arrays.asList(ap.getSupportedActions()).contains(MainProjectAction.this.command) && (pcp = (ProjectConfigurationProvider)p.getLookup().lookup(ProjectConfigurationProvider.class)) != null) {
                            pcp.removePropertyChangeListener(ConfigButton.this.pcl);
                            pcp.addPropertyChangeListener(ConfigButton.this.pcl);
                            v = pcp.configurationsAffectAction(MainProjectAction.this.command) && pcp.getConfigurations().size() > 1;
                        }
                        ConfigButton.this.setVisible(v);
                    }
                });
            }
        }

        public void actionPerformed(ActionEvent e) {
            if (this.menu != null) {
                this.menu.setVisible(false);
                this.menu = null;
                return;
            }
            final Project p = OpenProjectList.getDefault().getMainProject();
            ProjectConfigurationProvider pcp = (ProjectConfigurationProvider)p.getLookup().lookup(ProjectConfigurationProvider.class);
            this.menu = new JPopupMenu();
            for (final ProjectConfiguration config : pcp.getConfigurations()) {
                JMenuItem item = new JMenuItem(config.getDisplayName());
                this.menu.add(item);
                item.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        ConfigButton.this.menu = null;
                        ((ActionProvider)p.getLookup().lookup(ActionProvider.class)).invokeAction(MainProjectAction.this.command, Lookups.singleton((Object)config));
                    }
                });
            }
            this.menu.show(this, 0, this.getSize().height);
        }
    }
}

